/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.entity;

import com.google.common.collect.ImmutableMap;
import greekfantasy.GFRegistry;
import greekfantasy.GreekFantasy;
import greekfantasy.deity.favor.IFavor;
import greekfantasy.deity.favor_effect.ConfiguredFavorRange;
import greekfantasy.deity.favor_effect.ConfiguredSpecialFavorEffect;
import greekfantasy.deity.favor_effect.SpecialFavorEffect;
import greekfantasy.entity.SatyrEntity;
import greekfantasy.entity.ai.EffectGoal;
import greekfantasy.entity.ai.FindBlockGoal;
import greekfantasy.network.SSimpleParticlesPacket;
import greekfantasy.util.BiomeHelper;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IAngerable;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.ResetAngerGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.LootTable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.potion.Effects;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.RangedInteger;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.TickRangeConverter;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.Tags;
import net.minecraftforge.fml.network.PacketDistributor;

public class DryadEntity
extends CreatureEntity
implements IAngerable {
    protected static final DataParameter<String> DATA_VARIANT = EntityDataManager.func_187226_a(DryadEntity.class, (IDataSerializer)DataSerializers.field_187194_d);
    protected static final String KEY_VARIANT = "Variant";
    protected static final String KEY_TREE_POS = "Tree";
    protected static final String KEY_HIDING = "HidingTime";
    protected Variant variant = Variant.OAK;
    protected Optional<BlockPos> treePos = Optional.empty();
    protected static final Tags.IOptionalNamedTag<Item> DRYAD_TRADES = ItemTags.createOptional((ResourceLocation)new ResourceLocation("greekfantasy", "dryad_trade"));
    protected Optional<PlayerEntity> tradingPlayer = Optional.empty();
    protected static final RangedInteger ANGER_RANGE = TickRangeConverter.func_233037_a_((int)4, (int)10);
    protected int angerTime;
    protected UUID angerTarget;
    protected boolean isGoingToTree;
    protected int hidingTime;

    public DryadEntity(EntityType<? extends DryadEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public static AttributeModifierMap.MutableAttribute getAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 24.0).func_233815_a_(Attributes.field_233821_d_, 0.25).func_233815_a_(Attributes.field_233823_f_, 3.0);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.1, false));
        this.field_70714_bg.func_75776_a(2, (Goal)new TradeGoal(50 + this.field_70146_Z.nextInt(20)));
        this.field_70714_bg.func_75776_a(3, (Goal)new FindTreeGoal(8, 28));
        this.field_70714_bg.func_75776_a(4, (Goal)new HideGoal(640));
        this.field_70714_bg.func_75776_a(5, (Goal)new GoToTreeGoal(0.9f, 320));
        this.field_70714_bg.func_75776_a(6, new EffectGoal<LivingEntity>((LivingEntity)this, () -> Effects.field_76428_l, 60, 120, 0, 1, EffectGoal.randomPredicate(400).and(e -> ((DryadEntity)((Object)e)).isHiding())));
        this.field_70714_bg.func_75776_a(7, (Goal)new AvoidEntityGoal((CreatureEntity)this, SatyrEntity.class, 10.0f, 1.2, 1.1, entity -> !this.isHiding() && !this.isGoingToTree && !this.tradingPlayer.isPresent()));
        this.field_70714_bg.func_75776_a(8, (Goal)new WalkingGoal(0.8f, 140));
        this.field_70714_bg.func_75776_a(9, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, 10, true, false, arg_0 -> ((DryadEntity)this).func_233680_b_(arg_0)));
        this.field_70715_bh.func_75776_a(3, (Goal)new ResetAngerGoal((MobEntity)this, true));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(DATA_VARIANT, (Object)Variant.OAK.func_176610_l());
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70173_aa % 28 == 0 && this.treePos.isPresent() && !DryadEntity.isTreeAt((IWorldReader)this.func_130014_f_(), this.treePos.get(), this.getVariant().getLogs())) {
            this.tryExitTree();
            this.setTreePos(Optional.empty());
        }
        if (!this.field_70170_p.func_201670_d()) {
            this.func_241359_a_((ServerWorld)this.field_70170_p, true);
        }
    }

    public void func_213315_a(MoverType type, Vector3d vec) {
        super.func_213315_a(type, vec);
        this.func_145775_I();
    }

    public void func_70071_h_() {
        boolean isHidingInTree;
        boolean bl = isHidingInTree = this.isHiding() && this.isWithinDistanceOfTree(2.05) && this.func_70661_as().func_75500_f();
        if (isHidingInTree) {
            this.field_70145_X = true;
            this.func_213317_d(this.func_213322_ci().func_216372_d(1.0, 0.0, 1.0));
            Optional<Vector3d> treeVec = this.getTreeVec();
            this.func_70107_b(treeVec.get().func_82615_a(), treeVec.get().func_82617_b(), treeVec.get().func_82616_c());
        }
        super.func_70071_h_();
        this.func_189654_d(isHidingInTree);
        this.field_70145_X = false;
    }

    public boolean func_180431_b(DamageSource source) {
        if (source == DamageSource.field_76368_d) {
            return !this.field_70170_p.func_180495_p(this.func_233580_cy_().func_177984_a()).func_235714_a_(this.getVariant().getLogs());
        }
        return super.func_180431_b(source);
    }

    public boolean func_70652_k(Entity entity) {
        if (super.func_70652_k(entity)) {
            if (entity.func_110124_au().equals(this.func_230257_G__())) {
                this.func_230259_a_(null);
            }
            return true;
        }
        return false;
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74778_a(KEY_VARIANT, (String)this.func_184212_Q().func_187225_a(DATA_VARIANT));
        this.func_233682_c_(compound);
        if (this.treePos.isPresent()) {
            compound.func_74768_a("Tree.x", this.treePos.get().func_177958_n());
            compound.func_74768_a("Tree.y", this.treePos.get().func_177956_o());
            compound.func_74768_a("Tree.z", this.treePos.get().func_177952_p());
        }
        compound.func_74768_a(KEY_HIDING, this.hidingTime);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setVariant(this.getVariantByName(compound.func_74779_i(KEY_VARIANT)));
        this.func_241358_a_((ServerWorld)this.field_70170_p, compound);
        if (compound.func_74764_b("Tree.x")) {
            int x = compound.func_74762_e("Tree.x");
            int y = compound.func_74762_e("Tree.y");
            int z = compound.func_74762_e("Tree.z");
            this.setTreePos(Optional.of(new BlockPos(x, y, z)));
        }
        this.hidingTime = compound.func_74762_e(KEY_HIDING);
    }

    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        ILivingEntityData data = super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        Variant variant = reason == SpawnReason.COMMAND || reason == SpawnReason.SPAWN_EGG || reason == SpawnReason.SPAWNER || reason == SpawnReason.DISPENSER ? Variant.getRandom(worldIn.func_201674_k()) : Variant.getForBiome(worldIn.func_242406_i(this.func_233580_cy_()));
        this.setVariant(variant);
        return data;
    }

    public ResourceLocation func_184647_J() {
        return this.getVariant().getDeathLootTable();
    }

    public void func_230258_H__() {
        this.func_230260_a__(ANGER_RANGE.func_233018_a_(this.field_70146_Z));
    }

    public void func_230260_a__(int time) {
        this.angerTime = time;
    }

    public int func_230256_F__() {
        return this.angerTime;
    }

    public void func_230259_a_(@Nullable UUID target) {
        this.angerTarget = target;
    }

    public UUID func_230257_G__() {
        return this.angerTarget;
    }

    public float func_70013_c() {
        return 1.0f;
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return !this.treePos.isPresent() && this.field_70173_aa > 4800;
    }

    protected ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!this.field_70170_p.func_201670_d() && !this.func_213398_dR() && !this.tradingPlayer.isPresent() && this.func_184614_ca().func_190926_b() && !stack.func_190926_b() && this.getTradeTag().func_230235_a_((Object)stack.func_77973_b())) {
            if (this.canPlayerTrade(player)) {
                this.setTradingPlayer(player);
                this.func_184611_a(Hand.MAIN_HAND, new ItemStack((IItemProvider)stack.func_77973_b()));
                if (!player.func_184812_l_()) {
                    stack.func_190918_g(1);
                }
                player.func_184611_a(hand, stack);
                return ActionResultType.CONSUME;
            }
            GreekFantasy.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new SSimpleParticlesPacket(false, this.func_233580_cy_().func_177981_b(1), 4));
        }
        return super.func_230254_b_(player, hand);
    }

    public boolean canPlayerTrade(PlayerEntity player) {
        IFavor favor;
        if (player != null && (favor = (IFavor)player.getCapability(GreekFantasy.FAVOR).orElse(GreekFantasy.FAVOR.getDefaultInstance())).isEnabled()) {
            for (ConfiguredSpecialFavorEffect effect : GreekFantasy.PROXY.getFavorConfiguration().getSpecials(SpecialFavorEffect.Type.TRADING_CANCEL)) {
                if (!effect.canApply(player, favor)) continue;
                return false;
            }
            if (GreekFantasy.PROXY.getFavorConfiguration().hasEntity(this.func_200600_R())) {
                ConfiguredFavorRange range = GreekFantasy.PROXY.getFavorConfiguration().getEntity(this.func_200600_R());
                return !range.hasHostileRange() || !range.getHostileRange().isInFavorRange(player, favor);
            }
        }
        return true;
    }

    public void setTradingPlayer(PlayerEntity player) {
        this.tradingPlayer = Optional.ofNullable(player);
    }

    public Tags.IOptionalNamedTag<Item> getTradeTag() {
        return DRYAD_TRADES;
    }

    public ResourceLocation getTradeLootTable() {
        return this.getVariant().getTradeLootTable();
    }

    protected List<ItemStack> getTradeResult(Optional<PlayerEntity> player, ItemStack tradeItem) {
        LootTable loottable = this.field_70170_p.func_73046_m().func_200249_aQ().func_186521_a(this.getTradeLootTable());
        return loottable.func_216113_a(new LootContext.Builder((ServerWorld)this.field_70170_p).func_216023_a(this.field_70170_p.field_73012_v).func_216015_a(LootParameters.field_216281_a, (Object)this).func_216015_a(LootParameters.field_237457_g_, (Object)this.func_213303_ch()).func_216015_a(LootParameters.field_216289_i, (Object)tradeItem).func_216022_a(LootParameterSets.field_237453_h_));
    }

    public void trade(Optional<PlayerEntity> player, ItemStack tradeItem) {
        this.getTradeResult(player, tradeItem).forEach(i -> this.func_70099_a((ItemStack)i, 1.2f));
        tradeItem.func_190918_g(1);
        this.func_184611_a(Hand.MAIN_HAND, tradeItem);
        if (tradeItem.func_190916_E() <= 0) {
            this.setTradingPlayer(null);
        }
        if (this.field_70146_Z.nextInt(3) == 0) {
            this.field_70170_p.func_217376_c((Entity)new ExperienceOrbEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 1 + this.field_70146_Z.nextInt(2)));
        }
        GreekFantasy.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new SSimpleParticlesPacket(true, this.func_233580_cy_().func_177981_b(1), 6));
    }

    public void setVariant(Variant variantIn) {
        this.variant = variantIn;
        this.func_184212_Q().func_187227_b(DATA_VARIANT, (Object)variantIn.func_176610_l());
    }

    public Variant getVariant() {
        return this.variant;
    }

    public Variant getVariantByName(String name) {
        return Variant.getByName(name);
    }

    public void func_184206_a(DataParameter<?> key) {
        super.func_184206_a(key);
        if (key.equals(DATA_VARIANT)) {
            this.variant = this.getVariantByName((String)this.func_184212_Q().func_187225_a(DATA_VARIANT));
        }
    }

    public Optional<BlockPos> getTreePos() {
        return this.treePos;
    }

    public Optional<Vector3d> getTreeVec() {
        return this.treePos.isPresent() ? Optional.of(new Vector3d((double)this.treePos.get().func_177958_n() + 0.5, (double)this.treePos.get().func_177956_o() + 1.0, (double)this.treePos.get().func_177952_p() + 0.5)) : Optional.empty();
    }

    public boolean isHiding() {
        return this.hidingTime > 0;
    }

    public void setHiding(boolean hiding) {
        this.hidingTime = hiding ? 1 : 0;
    }

    public void setTreePos(Optional<BlockPos> pos) {
        this.treePos = pos;
        if (pos.isPresent()) {
            this.func_213390_a(pos.get(), (int)this.func_110148_a(Attributes.field_233819_b_).func_111125_b());
        } else {
            this.func_213390_a(BlockPos.field_177992_a, -1);
        }
    }

    public static boolean isTreeAt(IWorldReader worldIn, BlockPos pos, ITag<Block> logs) {
        return worldIn.func_180495_p(pos).canSustainPlant((IBlockReader)worldIn, pos, Direction.UP, (IPlantable)Blocks.field_196674_t) && worldIn.func_180495_p(pos.func_177981_b(1)).func_235714_a_(logs) && worldIn.func_180495_p(pos.func_177981_b(2)).func_235714_a_(logs);
    }

    public boolean tryExitTree() {
        this.isGoingToTree = false;
        this.setHiding(false);
        if (this.treePos.isPresent() && this.isWithinDistanceOfTree(2.0) && this.func_70661_as().func_75500_f()) {
            int radius = 2;
            for (int i = 0; i < 10; ++i) {
                double x = this.func_226277_ct_() + (double)this.field_70146_Z.nextInt(radius * 2) - (double)radius;
                double y = this.func_226278_cu_() + (double)this.field_70146_Z.nextInt(radius) - (double)(radius / 2);
                double z = this.func_226281_cx_() + (double)this.field_70146_Z.nextInt(radius * 2) - (double)radius;
                if (!this.func_70661_as().func_75492_a(x, y, z, 1.0)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isWithinDistanceOfTree(double dis) {
        Optional<Vector3d> treeVec = this.getTreeVec();
        if (!treeVec.isPresent()) {
            return false;
        }
        return treeVec.get().func_237488_a_((IPosition)this.func_213303_ch(), dis);
    }

    public static class Variant
    implements IStringSerializable {
        public static final Variant ACACIA = new Variant("acacia", () -> Blocks.field_196679_x);
        public static final Variant BIRCH = new Variant("birch", () -> Blocks.field_196676_v);
        public static final Variant DARK_OAK = new Variant("dark_oak", () -> Blocks.field_196680_y);
        public static final Variant JUNGLE = new Variant("jungle", () -> Blocks.field_196678_w);
        public static final Variant OAK = new Variant("oak", () -> Blocks.field_196674_t);
        public static final Variant SPRUCE = new Variant("spruce", () -> Blocks.field_196675_u);
        public static final Variant OLIVE = new Variant("greekfantasy", "olive", "dryad", "logs", () -> GFRegistry.OLIVE_SAPLING);
        public static ImmutableMap<String, Variant> OVERWORLD = ImmutableMap.builder().put((Object)Variant.ACACIA.name, (Object)ACACIA).put((Object)Variant.BIRCH.name, (Object)BIRCH).put((Object)Variant.DARK_OAK.name, (Object)DARK_OAK).put((Object)Variant.JUNGLE.name, (Object)JUNGLE).put((Object)Variant.OAK.name, (Object)OAK).put((Object)Variant.SPRUCE.name, (Object)SPRUCE).put((Object)Variant.OLIVE.name, (Object)OLIVE).build();
        protected final String name;
        protected final Supplier<Block> sapling;
        protected final ResourceLocation tag;
        protected final ResourceLocation deathLootTable;
        protected final ResourceLocation tradeLootTable;

        protected Variant(String nameIn, Supplier<Block> saplingIn) {
            this("minecraft", nameIn, "dryad", "logs", saplingIn);
        }

        protected Variant(String modid, String nameIn, String entityIn, String tagSuffixIn, Supplier<Block> saplingIn) {
            this.name = nameIn;
            this.sapling = saplingIn;
            this.tag = new ResourceLocation(modid, this.name + "_" + tagSuffixIn);
            this.deathLootTable = new ResourceLocation("greekfantasy", "entities/" + entityIn + "/" + this.name);
            this.tradeLootTable = new ResourceLocation("greekfantasy", "gameplay/" + entityIn + "_trade");
        }

        public static Variant getForBiome(Optional<RegistryKey<Biome>> biome) {
            return BiomeHelper.getDryadVariantForBiome(biome);
        }

        public static Variant getRandom(Random rand) {
            int len = OVERWORLD.size();
            return len > 0 ? (Variant)((Map.Entry)OVERWORLD.entrySet().asList().get(rand.nextInt(len))).getValue() : OAK;
        }

        public static Variant getByName(String n) {
            if (n != null && !n.isEmpty()) {
                return (Variant)OVERWORLD.getOrDefault((Object)n, (Object)OAK);
            }
            return OAK;
        }

        public ITag<Block> getLogs() {
            return Optional.ofNullable(BlockTags.func_199896_a().func_199910_a(this.tag)).orElse((ITag)BlockTags.field_200031_h);
        }

        public BlockState getSapling() {
            return this.sapling.get().func_176223_P();
        }

        public ResourceLocation getDeathLootTable() {
            return this.deathLootTable;
        }

        public ResourceLocation getTradeLootTable() {
            return this.tradeLootTable;
        }

        public String func_176610_l() {
            return this.name;
        }
    }

    class TradeGoal
    extends Goal {
        protected final int maxThinkingTime;
        protected int thinkingTime;

        public TradeGoal(int maxThinkingTimeIn) {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
            this.maxThinkingTime = maxThinkingTimeIn;
            this.thinkingTime = 0;
        }

        public boolean func_75250_a() {
            return !DryadEntity.this.func_213398_dR() && !DryadEntity.this.func_184614_ca().func_190926_b() && DryadEntity.this.getTradeTag().func_230235_a_((Object)DryadEntity.this.func_184614_ca().func_77973_b());
        }

        public boolean func_75253_b() {
            return this.thinkingTime > 0 && this.thinkingTime <= this.maxThinkingTime && this.func_75250_a();
        }

        public void func_75249_e() {
            this.thinkingTime = 1;
        }

        public void func_75246_d() {
            if (DryadEntity.this.tradingPlayer.isPresent()) {
                DryadEntity.this.field_70749_g.func_75651_a((Entity)DryadEntity.this.tradingPlayer.get(), (float)DryadEntity.this.func_184649_cE(), 100.0f);
            }
            DryadEntity.this.func_70661_as().func_75499_g();
            DryadEntity.this.func_70671_ap().func_220674_a(DryadEntity.this.func_174824_e(1.0f).func_72441_c(0.0, -0.25, 0.0));
            if (this.thinkingTime++ >= this.maxThinkingTime) {
                DryadEntity.this.trade(DryadEntity.this.tradingPlayer, DryadEntity.this.func_184614_ca());
                this.func_75251_c();
            }
        }

        public void func_75251_c() {
            this.thinkingTime = 0;
        }
    }

    class WalkingGoal
    extends RandomWalkingGoal {
        public WalkingGoal(double speed, int chance) {
            super((CreatureEntity)DryadEntity.this, speed, chance);
        }

        public boolean func_75250_a() {
            return !DryadEntity.this.isHiding() && !DryadEntity.this.isGoingToTree && DryadEntity.this.func_70638_az() == null && super.func_75250_a();
        }
    }

    class GoToTreeGoal
    extends Goal {
        private final double speed;
        private final int chance;

        public GoToTreeGoal(double speedIn, int chanceIn) {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
            this.speed = speedIn;
            this.chance = chanceIn;
        }

        public boolean func_75250_a() {
            return !DryadEntity.this.isHiding() && DryadEntity.this.getTreePos().isPresent() && DryadEntity.this.func_70638_az() == null && DryadEntity.this.func_70681_au().nextInt(this.chance) == 0;
        }

        public boolean func_75253_b() {
            return DryadEntity.this.isGoingToTree && DryadEntity.this.getTreePos().isPresent() && !DryadEntity.this.func_70661_as().func_75500_f() && DryadEntity.this.func_70638_az() == null;
        }

        public void func_75249_e() {
            DryadEntity.this.isGoingToTree = true;
            Optional<Vector3d> vec = DryadEntity.this.getTreeVec();
            DryadEntity.this.func_70661_as().func_75492_a(vec.get().func_82615_a(), vec.get().func_82617_b(), vec.get().func_82616_c(), this.speed);
        }

        public void func_75251_c() {
            DryadEntity.this.func_70661_as().func_75499_g();
            DryadEntity.this.isGoingToTree = false;
        }
    }

    class FindTreeGoal
    extends FindBlockGoal {
        public FindTreeGoal(int radius, int cooldown) {
            super(DryadEntity.this, radius, cooldown);
        }

        @Override
        public boolean func_75250_a() {
            return (!DryadEntity.this.getTreePos().isPresent() || DryadEntity.this.func_70681_au().nextInt(500) == 0) && super.func_75250_a();
        }

        @Override
        public boolean isTargetBlock(IWorldReader worldIn, BlockPos pos) {
            return DryadEntity.isTreeAt(worldIn, pos, DryadEntity.this.getVariant().getLogs()) && DryadEntity.this.func_130014_f_().func_217357_a(DryadEntity.class, new AxisAlignedBB(pos.func_177984_a()).func_186662_g(0.5)).isEmpty();
        }

        @Override
        public void onFoundBlock(IWorldReader worldIn, BlockPos target) {
            DryadEntity.this.setTreePos(Optional.of(target));
        }
    }

    class HideGoal
    extends Goal {
        private final int maxHidingTime;
        private final int maxCooldown;
        private int cooldown;

        public HideGoal(int maxHidingTimeIn) {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP));
            this.maxHidingTime = maxHidingTimeIn;
            this.maxCooldown = 120;
        }

        public boolean func_75250_a() {
            if (this.cooldown > 0) {
                --this.cooldown;
            } else if (DryadEntity.this.treePos.isPresent() && DryadEntity.this.isWithinDistanceOfTree(1.5) && DryadEntity.this.func_70638_az() == null) {
                return DryadEntity.isTreeAt((IWorldReader)DryadEntity.this.func_130014_f_(), DryadEntity.this.treePos.get(), DryadEntity.this.getVariant().getLogs());
            }
            return false;
        }

        public void func_75249_e() {
            DryadEntity.this.setHiding(true);
            DryadEntity.this.isGoingToTree = false;
        }

        public void func_75246_d() {
            super.func_75246_d();
            DryadEntity.this.func_70661_as().func_75499_g();
            if (DryadEntity.this.hidingTime++ > this.maxHidingTime && DryadEntity.this.func_70681_au().nextInt(100) == 0) {
                this.func_75251_c();
            }
        }

        public void func_75251_c() {
            DryadEntity.this.tryExitTree();
            this.cooldown = this.maxCooldown;
        }
    }
}

