/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.entity;

import greekfantasy.GFRegistry;
import java.util.EnumSet;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.FlyingMovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.passive.IFlyingAnimal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.FlyingPathNavigator;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.Tags;

public class ElpisEntity
extends CreatureEntity
implements IFlyingAnimal {
    private static final DataParameter<Byte> STATE = EntityDataManager.func_187226_a(ElpisEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final String KEY_STATE = "ElpisState";
    private static final String KEY_HOME = "ElpisHome";
    private static final String KEY_AGE = "ElpisAge";
    private static final String KEY_DESPAWN_TIMER = "DespawnTimer";
    protected static final Tags.IOptionalNamedTag<Item> ELPIS_TRADE = ItemTags.createOptional((ResourceLocation)new ResourceLocation("greekfantasy", "elpis_trade"));
    private static final Predicate<Item> TRADE_ITEM = i -> ELPIS_TRADE.func_230235_a_(i);
    private static final Supplier<ItemStack> TRADE_RESULT = () -> new ItemStack((IItemProvider)GFRegistry.ICHOR);
    public static final int wanderDistance = 8;
    private static final int maxAge = 4800;
    private static final int maxDespawnTime = 40;
    protected static final byte STATE_NONE = 5;
    protected static final byte STATE_TRADING = 6;
    protected static final byte STATE_DESPAWNING = 7;
    private static final byte DESPAWN_CLIENT = 10;
    private int despawnTime;
    private int age;

    public ElpisEntity(EntityType<? extends CreatureEntity> type, World world) {
        super(type, world);
        this.field_70765_h = new FlyingMovementController((MobEntity)this, 20, true);
        this.func_184644_a(PathNodeType.DANGER_FIRE, -1.0f);
        this.func_184644_a(PathNodeType.DAMAGE_FIRE, -1.0f);
    }

    public static AttributeModifierMap.MutableAttribute getAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 24.0).func_233815_a_(Attributes.field_233821_d_, 0.15).func_233815_a_(Attributes.field_233823_f_, 0.5).func_233815_a_(Attributes.field_233822_e_, 0.4);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(STATE, (Object)5);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(1, (Goal)new DoNothingGoal());
        this.field_70714_bg.func_75776_a(2, (Goal)new TradeGoal(TRADE_RESULT, 80));
        this.field_70714_bg.func_75776_a(3, (Goal)new PanicGoal(1.0));
        this.field_70714_bg.func_75776_a(4, (Goal)new MoveRandomGoal(20, 8, 0.75));
        this.field_70714_bg.func_75776_a(5, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookRandomlyGoal((MobEntity)this));
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70170_p.func_201670_d() && this.field_70146_Z.nextInt(12) == 0) {
            this.spawnParticle((IParticleData)ParticleTypes.field_197608_a, true);
        }
        ++this.age;
        if (this.despawnTime > 0) {
            if (this.despawnTime > 20 && this.field_70146_Z.nextInt(3) == 0) {
                this.spawnParticle((IParticleData)ParticleTypes.field_197599_J, false);
            }
            if (this.despawnTime++ >= 40) {
                this.func_70106_y();
            }
        }
        if (this.isTrading()) {
            this.spawnParticle((IParticleData)ParticleTypes.field_197632_y, false);
        } else if (TRADE_ITEM.test(this.func_184586_b(Hand.OFF_HAND).func_77973_b())) {
            this.func_184611_a(Hand.OFF_HAND, ItemStack.field_190927_a);
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.func_189654_d(true);
    }

    protected ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (this.isNoneState() && TRADE_ITEM.test(stack.func_77973_b())) {
            this.setState((byte)6);
            this.func_184611_a(Hand.OFF_HAND, new ItemStack((IItemProvider)stack.func_77973_b()));
            if (!player.func_184812_l_()) {
                stack.func_190918_g(1);
            }
            player.func_184611_a(hand, stack);
            return ActionResultType.CONSUME;
        }
        return super.func_230254_b_(player, hand);
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_193808_ex;
    }

    protected float func_70599_aP() {
        return 0.8f;
    }

    public SoundCategory func_184176_by() {
        return SoundCategory.NEUTRAL;
    }

    public float func_205022_a(BlockPos pos, IWorldReader worldIn) {
        return worldIn.func_175623_d(pos) ? 10.0f : 0.0f;
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    protected void func_184231_a(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    protected PathNavigator func_175447_b(World worldIn) {
        FlyingPathNavigator flyingpathnavigator = new FlyingPathNavigator((MobEntity)this, worldIn);
        flyingpathnavigator.func_192879_a(false);
        flyingpathnavigator.func_212239_d(false);
        flyingpathnavigator.func_192878_b(true);
        return flyingpathnavigator;
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74774_a(KEY_STATE, ((Byte)this.func_184212_Q().func_187225_a(STATE)).byteValue());
        compound.func_74768_a(KEY_AGE, this.age);
        compound.func_74768_a(KEY_DESPAWN_TIMER, this.despawnTime);
        if (this.func_213384_dI() != BlockPos.field_177992_a && this.func_213391_dJ() > -1.0f) {
            compound.func_74768_a("ElpisHome.x", this.func_213384_dI().func_177958_n());
            compound.func_74768_a("ElpisHome.y", this.func_213384_dI().func_177956_o());
            compound.func_74768_a("ElpisHome.z", this.func_213384_dI().func_177952_p());
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.func_184212_Q().func_187227_b(STATE, (Object)compound.func_74771_c(KEY_STATE));
        this.age = compound.func_74762_e(KEY_AGE);
        this.despawnTime = compound.func_74762_e(KEY_DESPAWN_TIMER);
        if (compound.func_74764_b("ElpisHome.x")) {
            int x = compound.func_74762_e("ElpisHome.x");
            int y = compound.func_74762_e("ElpisHome.y");
            int z = compound.func_74762_e("ElpisHome.z");
            this.func_213390_a(new BlockPos(x, y, z), 8);
        }
    }

    public boolean func_213397_c(double disToPlayer) {
        return this.isNoneState() && this.age > 4800 && disToPlayer > 12.0;
    }

    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        spawnDataIn = super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.func_184641_n(false);
        this.setState((byte)5);
        return spawnDataIn;
    }

    public BlockPos getWanderCenter() {
        BlockPos home = this.func_213384_dI();
        return this.func_213391_dJ() > -1.0f && home != BlockPos.field_177992_a ? home : this.func_233580_cy_();
    }

    protected void spawnParticle(IParticleData particle, boolean colored) {
        if (this.field_70170_p.func_201670_d()) {
            double motion = 0.09;
            double radius = 0.25;
            this.field_70170_p.func_195594_a(particle, this.func_226277_ct_() + (this.field_70170_p.field_73012_v.nextDouble() - 0.5) * 0.25, this.func_226280_cw_() + (this.field_70170_p.field_73012_v.nextDouble() - 0.5) * 0.25 * 0.75, this.func_226281_cx_() + (this.field_70170_p.field_73012_v.nextDouble() - 0.5) * 0.25, colored ? 1.0 : (this.field_70170_p.field_73012_v.nextDouble() - 0.5) * 0.09, colored ? (double)0.6f : (this.field_70170_p.field_73012_v.nextDouble() - 0.5) * 0.09 * 0.5, colored ? (double)0.92f : (this.field_70170_p.field_73012_v.nextDouble() - 0.5) * 0.09);
        }
    }

    public void setState(byte state) {
        this.func_184212_Q().func_187227_b(STATE, (Object)state);
        if (state == 7) {
            this.despawnTime = 1;
            if (!this.field_70170_p.func_201670_d()) {
                this.field_70170_p.func_72960_a((Entity)this, (byte)10);
            }
        }
    }

    public byte getState() {
        return (Byte)this.func_184212_Q().func_187225_a(STATE);
    }

    public boolean isNoneState() {
        return this.getState() == 5;
    }

    public boolean isTrading() {
        return this.getState() == 6;
    }

    public boolean isDespawning() {
        return this.getState() == 7;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 10) {
            this.setState((byte)7);
        } else {
            super.func_70103_a(id);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getAlpha(float partialTick) {
        byte state = this.getState();
        switch (state) {
            case 6: {
                return 1.0f;
            }
            case 7: {
                return 1.0f - this.getDespawnPercent(partialTick);
            }
        }
        float minAlpha = 0.14f;
        float cosAlpha = 0.5f + 0.5f * MathHelper.func_76134_b((float)(((float)(this.func_145782_y() + this.field_70173_aa) + partialTick) * 0.025f));
        return MathHelper.func_76131_a((float)cosAlpha, (float)0.14f, (float)1.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getDespawnPercent(float partialTick) {
        return (float)this.despawnTime / 40.0f;
    }

    class MoveRandomGoal
    extends Goal {
        private final int chance;
        private final int radius;
        private final double speed;

        public MoveRandomGoal(int chanceIn, int radiusIn, double speedIn) {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
            this.chance = chanceIn;
            this.radius = radiusIn;
            this.speed = speedIn;
        }

        public boolean func_75250_a() {
            return ElpisEntity.this.func_70661_as().func_75500_f() && ElpisEntity.this.field_70146_Z.nextInt(this.chance) == 0;
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75246_d() {
            BlockPos pos = ElpisEntity.this.getWanderCenter();
            for (int checks = 0; checks < 3; ++checks) {
                BlockPos posCheck = pos.func_177982_a(ElpisEntity.this.field_70146_Z.nextInt(this.radius * 2) - this.radius, ElpisEntity.this.field_70146_Z.nextInt(this.radius) - this.radius / 2, ElpisEntity.this.field_70146_Z.nextInt(this.radius * 2) - this.radius);
                if (!ElpisEntity.this.field_70170_p.func_175623_d(posCheck)) continue;
                ElpisEntity.this.func_70661_as().func_75492_a((double)posCheck.func_177958_n() + 0.5, (double)posCheck.func_177956_o() + 0.5, (double)posCheck.func_177952_p() + 0.5, this.speed);
                if (ElpisEntity.this.func_70638_az() != null) break;
                ElpisEntity.this.func_70671_ap().func_75650_a((double)posCheck.func_177958_n() + 0.5, (double)posCheck.func_177956_o() + 0.5, (double)posCheck.func_177952_p() + 0.5, 180.0f, 20.0f);
                break;
            }
        }
    }

    class PanicGoal
    extends net.minecraft.entity.ai.goal.PanicGoal {
        public PanicGoal(double speed) {
            super((CreatureEntity)ElpisEntity.this, speed);
        }
    }

    class DoNothingGoal
    extends Goal {
        public DoNothingGoal() {
            this.func_220684_a(EnumSet.allOf(Goal.Flag.class));
        }

        public boolean func_75250_a() {
            return ElpisEntity.this.isDespawning();
        }
    }

    class TradeGoal
    extends Goal {
        final Supplier<ItemStack> result;
        final int duration;
        PlayerEntity player;
        int progress;

        public TradeGoal(Supplier<ItemStack> resultStack, int durationIn) {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
            this.result = resultStack;
            this.duration = durationIn;
        }

        public boolean func_75250_a() {
            this.player = ElpisEntity.this.field_70170_p.func_217362_a((Entity)ElpisEntity.this, 8.0);
            return this.player != null && ElpisEntity.this.isTrading();
        }

        public void func_75246_d() {
            ElpisEntity.this.func_70671_ap().func_75651_a((Entity)this.player, (float)ElpisEntity.this.func_184649_cE(), (float)ElpisEntity.this.func_70646_bf());
            ElpisEntity.this.func_70661_as().func_75499_g();
            if (this.progress++ >= this.duration) {
                ItemEntity item = new ItemEntity(ElpisEntity.this.field_70170_p, ElpisEntity.this.func_226277_ct_(), ElpisEntity.this.func_226278_cu_(), ElpisEntity.this.func_226281_cx_(), this.result.get());
                ElpisEntity.this.func_130014_f_().func_217376_c((Entity)item);
                ElpisEntity.this.func_184185_a(SoundEvents.field_187802_ec, 0.8f, 1.0f);
                ElpisEntity.this.despawnTime = 1;
                ElpisEntity.this.setState((byte)7);
            }
        }

        public void func_75251_c() {
            if (ElpisEntity.this.isTrading()) {
                ElpisEntity.this.setState((byte)5);
            }
            this.progress = 0;
        }
    }
}

