/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.entity;

import greekfantasy.GreekFantasy;
import java.util.EnumSet;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EmpusaEntity
extends MonsterEntity {
    private static final byte DRAINING_START = 4;
    private static final byte DRAINING_END = 5;
    private boolean isDraining;

    public EmpusaEntity(EntityType<? extends EmpusaEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public static AttributeModifierMap.MutableAttribute getAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 24.0).func_233815_a_(Attributes.field_233821_d_, 0.21).func_233815_a_(Attributes.field_233823_f_, 3.0);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(3, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, false));
        this.field_70714_bg.func_75776_a(4, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.8));
        this.field_70714_bg.func_75776_a(5, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
        if (((Boolean)GreekFantasy.CONFIG.EMPUSA_ATTACK.get()).booleanValue()) {
            this.field_70714_bg.func_75776_a(2, (Goal)new DrainAttackGoal(this));
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.func_70613_aW() && this.func_130014_f_().func_72820_D() % 24000L < 11000L && this.field_70737_aN == 0 && this.field_70146_Z.nextInt(20) == 0) {
            this.func_70097_a(DamageSource.field_76366_f, 1.0f);
            if (this.func_110143_aJ() < this.func_110138_aP() / 2.0f && this.func_70638_az() == null) {
                this.func_70106_y();
                return;
            }
        }
        if (this.field_70170_p.func_201670_d() && this.isDraining()) {
            this.particleRay();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        switch (id) {
            case 4: {
                this.isDraining = true;
                this.func_184185_a(SoundEvents.field_187532_aV, this.func_70599_aP(), this.func_70647_i());
                break;
            }
            case 5: {
                this.isDraining = false;
                break;
            }
            default: {
                super.func_70103_a(id);
            }
        }
    }

    public void setDraining(boolean draining) {
        this.isDraining = draining;
        if (this.func_70613_aW()) {
            this.field_70170_p.func_72960_a((Entity)this, draining ? (byte)4 : 5);
        }
    }

    public boolean isDraining() {
        return this.isDraining;
    }

    public void particleRay() {
        Vector3d pos = this.func_174824_e(1.0f).func_72441_c(0.0, (double)(-this.func_213302_cg()) * 0.25, 0.0);
        Vector3d lookVec = this.func_70040_Z();
        double l = lookVec.func_186678_a(12.0).func_72433_c();
        double stepSize = 0.25;
        for (double i = 0.0; i < l; i += stepSize) {
            Vector3d scaled = lookVec.func_186678_a(i);
            double x = pos.field_72450_a + scaled.field_72450_a;
            double y = pos.field_72448_b + scaled.field_72448_b;
            double z = pos.field_72449_c + scaled.field_72449_c;
            AxisAlignedBB aabb = new AxisAlignedBB(x - 0.1, y - 0.1, z - 0.1, x + 0.1, y + 0.1, z + 0.1);
            if (!this.func_130014_f_().func_72839_b((Entity)this, aabb).isEmpty()) {
                return;
            }
            this.func_130014_f_().func_195594_a((IParticleData)ParticleTypes.field_197614_g, x, y, z, 0.0, 0.0, 0.0);
        }
    }

    static class DrainAttackGoal
    extends Goal {
        private final EmpusaEntity entity;
        private final int MAX_DRAIN_TIME = 80;
        private final int MAX_COOLDOWN = 160;
        private int drainingTime;
        private int cooldown;

        protected DrainAttackGoal(EmpusaEntity entityIn) {
            this.func_220684_a(EnumSet.allOf(Goal.Flag.class));
            this.entity = entityIn;
            this.cooldown = 80;
        }

        public boolean func_75250_a() {
            if (this.cooldown > 0) {
                --this.cooldown;
            } else if (this.entity.func_70638_az() != null && this.entity.func_70068_e((Entity)this.entity.func_70638_az()) < 36.0 && this.entity.func_70685_l((Entity)this.entity.func_70638_az())) {
                return true;
            }
            return false;
        }

        public boolean func_75253_b() {
            return this.entity.isDraining() && this.entity.func_70638_az() != null && this.entity.func_70685_l((Entity)this.entity.func_70638_az());
        }

        public void func_75249_e() {
            this.drainingTime = 1;
            this.entity.setDraining(true);
        }

        public void func_75246_d() {
            if (this.drainingTime > 0 && this.drainingTime < 80) {
                ++this.drainingTime;
                this.entity.func_70661_as().func_75499_g();
                this.entity.func_70625_a((Entity)this.entity.func_70638_az(), 100.0f, 100.0f);
                if (this.drainingTime > 26 && this.entity.func_70638_az().field_70737_aN == 0) {
                    DamageSource src = DamageSource.func_76354_b((Entity)this.entity, (Entity)this.entity);
                    float amount = (float)this.entity.func_110148_a(Attributes.field_233823_f_).func_111126_e() * 0.5f;
                    if (this.entity.func_70638_az().func_70097_a(src, amount)) {
                        this.entity.func_70691_i(amount * 1.5f);
                    }
                }
            } else {
                this.func_75251_c();
            }
        }

        public void func_75251_c() {
            this.entity.setDraining(false);
            this.drainingTime = 0;
            this.cooldown = 160;
        }
    }
}

