/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.entity;

import greekfantasy.GFRegistry;
import greekfantasy.GreekFantasy;
import greekfantasy.entity.MadCowEntity;
import greekfantasy.entity.ai.SummonMobGoal;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.BossInfo;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerBossInfo;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class GeryonEntity
extends MonsterEntity {
    private static final DataParameter<Byte> STATE = EntityDataManager.func_187226_a(GeryonEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final String KEY_STATE = "GeryonState";
    private static final byte NONE = 0;
    private static final byte SPAWNING = 1;
    private static final byte SMASH = 2;
    private static final byte SUMMON_COW = 4;
    private static final byte SPAWN_CLIENT = 9;
    private static final byte SMASH_CLIENT = 10;
    private static final byte SUMMON_COW_CLIENT = 11;
    private static final int MAX_SPAWN_TIME = 110;
    private static final int MAX_SMASH_TIME = 42;
    private static final int MAX_SUMMON_TIME = 35;
    private static final double SMASH_RANGE = 12.0;
    private static final int ATTACK_COOLDOWN = 38;
    private static final int STUN_DURATION = 35;
    private final ServerBossInfo bossInfo = (ServerBossInfo)new ServerBossInfo(this.func_145748_c_(), BossInfo.Color.RED, BossInfo.Overlay.PROGRESS).func_186741_a(true);
    private int spawnTime;
    private int smashTime;
    private int summonTime;
    private int attackCooldown;

    public GeryonEntity(EntityType<? extends GeryonEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70138_W = 1.0f;
        this.field_70728_aV = 50;
    }

    public static AttributeModifierMap.MutableAttribute getAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 160.0).func_233815_a_(Attributes.field_233821_d_, 0.21).func_233815_a_(Attributes.field_233820_c_, 0.98).func_233815_a_(Attributes.field_233819_b_, 48.0).func_233815_a_(Attributes.field_233823_f_, 5.0).func_233815_a_(Attributes.field_233824_g_, 1.8).func_233815_a_(Attributes.field_233826_i_, 7.0);
    }

    public static boolean canGeryonSpawnOn(IWorld world, BlockPos pos) {
        AxisAlignedBB box = new AxisAlignedBB(pos).func_72321_a(-1.0, 0.0, -1.0).func_72321_a(1.0, 5.0, 1.0);
        for (double x = box.field_72340_a; x < box.field_72336_d; x += 1.0) {
            for (double y = box.field_72338_b; y < box.field_72337_e; y += 1.0) {
                for (double z = box.field_72339_c; z < box.field_72334_f; z += 1.0) {
                    BlockPos p = new BlockPos(x, y, z);
                    BlockState s = world.func_180495_p(p);
                    if (!s.func_235714_a_((ITag)BlockTags.field_219755_X)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static GeryonEntity spawnGeryon(World world, BlockPos pos, float yaw) {
        GeryonEntity entity = (GeryonEntity)GFRegistry.GERYON_ENTITY.func_200721_a(world);
        entity.func_70012_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.1, (double)pos.func_177952_p() + 0.5, yaw, 0.0f);
        entity.field_70761_aq = yaw;
        entity.func_184611_a(Hand.MAIN_HAND, new ItemStack((IItemProvider)GFRegistry.IRON_CLUB));
        world.func_217376_c((Entity)entity);
        entity.setSpawning(true);
        for (ServerPlayerEntity player : world.func_217357_a(ServerPlayerEntity.class, entity.func_174813_aQ().func_186662_g(25.0))) {
            CriteriaTriggers.field_192133_m.func_192229_a(player, (Entity)entity);
        }
        world.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187855_gD, entity.func_184176_by(), 1.2f, 1.0f, false);
        return entity;
    }

    public void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(STATE, (Object)0);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new SpawningGoal());
        this.field_70714_bg.func_75776_a(1, (Goal)new SummonCowGoal(35, 440));
        this.field_70714_bg.func_75776_a(2, (Goal)new SmashAttackGoal(12.0, 210));
        this.field_70714_bg.func_75776_a(3, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, false));
        this.field_70714_bg.func_75776_a(5, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 10.0f));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, false));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, IronGolemEntity.class, false));
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
        this.attackCooldown = Math.max(this.attackCooldown - 1, 0);
        if (this.isSpawning()) {
            if (--this.spawnTime <= 0) {
                this.setSpawning(false);
                if (!this.field_70170_p.func_201670_d()) {
                    this.destroyIntersectingBlocks(0.0);
                }
            }
            this.addBlockParticles(10);
        }
        if (this.isSmashAttack()) {
            ++this.smashTime;
        } else if (this.smashTime > 0) {
            this.smashTime = 0;
        }
        if (this.isSummoning()) {
            ++this.summonTime;
            if (this.func_184586_b(Hand.OFF_HAND).func_190926_b()) {
                this.func_184611_a(Hand.OFF_HAND, new ItemStack((IItemProvider)GFRegistry.HORN));
            }
        } else if (this.summonTime > 0) {
            this.summonTime = 0;
            if (this.func_184586_b(Hand.OFF_HAND).func_77973_b() == GFRegistry.HORN) {
                this.func_184611_a(Hand.OFF_HAND, ItemStack.field_190927_a);
            }
        }
        if (GeryonEntity.func_213296_b((Vector3d)this.func_213322_ci()) > 2.500000277905201E-7 && this.field_70146_Z.nextInt(5) == 0) {
            this.addBlockParticles(2);
        }
    }

    public boolean func_70652_k(Entity entityIn) {
        if (super.func_70652_k(entityIn)) {
            entityIn.func_213317_d(entityIn.func_213322_ci().func_72441_c(0.0, 0.25, 0.0));
            return true;
        }
        return false;
    }

    protected float func_175134_bD() {
        return 0.82f * this.func_226269_ah_();
    }

    public boolean func_70104_M() {
        return false;
    }

    protected void func_85033_bc() {
    }

    public boolean func_184222_aU() {
        return false;
    }

    public boolean func_213397_c(double disToPlayer) {
        return false;
    }

    protected boolean func_184228_n(Entity entityIn) {
        return false;
    }

    public void func_184178_b(ServerPlayerEntity player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(ServerPlayerEntity player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    public boolean func_180431_b(DamageSource source) {
        return this.isSpawning() || source == DamageSource.field_76368_d || source == DamageSource.field_82727_n || super.func_180431_b(source);
    }

    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        ILivingEntityData data = super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.func_184611_a(Hand.MAIN_HAND, new ItemStack((IItemProvider)GFRegistry.IRON_CLUB));
        this.setSpawning(true);
        return data;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187910_gj;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187912_gl;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187911_gk;
    }

    protected float func_70599_aP() {
        return 1.5f;
    }

    protected float func_70647_i() {
        return 0.089f;
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74774_a(KEY_STATE, this.getGeryonState());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setGeryonState(compound.func_74771_c(KEY_STATE));
    }

    public byte getGeryonState() {
        return (Byte)this.func_184212_Q().func_187225_a(STATE);
    }

    public void setGeryonState(byte state) {
        this.func_184212_Q().func_187227_b(STATE, (Object)state);
    }

    public boolean isNoneState() {
        return this.getGeryonState() == 0;
    }

    public boolean isSmashAttack() {
        return this.getGeryonState() == 2;
    }

    public void setSmashAttack(boolean smash) {
        this.setGeryonState(smash ? (byte)2 : 0);
    }

    public boolean isSummoning() {
        return this.getGeryonState() == 4;
    }

    public void setSummoning(boolean smash) {
        this.setGeryonState(smash ? (byte)4 : 0);
    }

    public boolean isSpawning() {
        return this.spawnTime > 0 || this.getGeryonState() == 1;
    }

    public void setSpawning(boolean spawning) {
        this.spawnTime = spawning ? 110 : 0;
        this.setGeryonState(spawning ? (byte)1 : 0);
        if (spawning && !this.field_70170_p.func_201670_d()) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)9);
        }
    }

    public void setAttackCooldown() {
        this.attackCooldown = 38;
    }

    public boolean hasNoCooldown() {
        return this.attackCooldown <= 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        switch (id) {
            case 9: {
                this.setSpawning(true);
                break;
            }
            case 10: {
                List targets = this.func_130014_f_().func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b(12.0, 6.0, 12.0));
                for (Entity e : targets) {
                    this.addSmashParticlesAt(e);
                }
                this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187596_cD, this.func_184176_by(), 2.0f, 0.4f, false);
                this.addBlockParticles(45);
                break;
            }
            case 11: {
                int i;
                for (i = 0; i < 4; ++i) {
                    this.func_130014_f_().func_184134_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_219663_hb, this.func_184176_by(), 2.0f, 0.2f, false);
                }
                for (i = 0; i < 2; ++i) {
                    this.func_130014_f_().func_184134_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_219663_hb, this.func_184176_by(), 1.8f, 0.4f, false);
                }
                break;
            }
            default: {
                super.func_70103_a(id);
            }
        }
    }

    private void addBlockParticles(int count) {
        int k;
        int j;
        int i = MathHelper.func_76128_c((double)this.func_226277_ct_());
        BlockPos pos = new BlockPos(i, j = MathHelper.func_76128_c((double)(this.func_226278_cu_() - (double)0.2f)), k = MathHelper.func_76128_c((double)this.func_226281_cx_()));
        BlockState blockstate = this.field_70170_p.func_180495_p(pos);
        if (!blockstate.isAir((IBlockReader)this.field_70170_p, pos)) {
            BlockParticleData data = new BlockParticleData(ParticleTypes.field_197611_d, blockstate).setPos(pos);
            double radius = this.func_213311_cf();
            double motion = 4.0;
            for (int c = 0; c < count; ++c) {
                this.field_70170_p.func_195594_a((IParticleData)data, this.func_226277_ct_() + (this.field_70146_Z.nextDouble() - 0.5) * radius * 2.0, this.func_226278_cu_() + 0.1, this.func_226281_cx_() + (this.field_70146_Z.nextDouble() - 0.5) * radius * 2.0, 4.0 * (this.field_70146_Z.nextDouble() - 0.5), 0.5, (this.field_70146_Z.nextDouble() - 0.5) * 4.0);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void addSmashParticlesAt(Entity e) {
        double x = e.func_226277_ct_() + 0.5;
        double y = e.func_226278_cu_() + 0.1;
        double z = e.func_226281_cx_() + 0.5;
        double motion = 0.08;
        double radius = e.func_213311_cf();
        for (int i = 0; i < 25; ++i) {
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197614_g, x + (this.field_70170_p.field_73012_v.nextDouble() - 0.5) * radius, y, z + (this.field_70170_p.field_73012_v.nextDouble() - 0.5) * radius, (this.field_70170_p.field_73012_v.nextDouble() - 0.5) * 0.08, 0.5, (this.field_70170_p.field_73012_v.nextDouble() - 0.5) * 0.08);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getSmashTime(float partialTick) {
        return (float)this.smashTime + (partialTick < 1.0f ? partialTick : 0.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getSmashPercent(float partialTick) {
        return this.smashTime > 0 ? this.getSmashTime(partialTick) / 42.0f : 0.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getSpawnTime(float ageInTicks) {
        return (float)this.spawnTime + (ageInTicks < 1.0f ? ageInTicks : 0.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getSpawnPercent(float ageInTicks) {
        return this.spawnTime > 0 ? 1.0f - this.getSpawnTime(ageInTicks) / 110.0f : 1.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getSummonTime(float partialTick) {
        return (float)this.summonTime + (partialTick < 1.0f ? partialTick : 0.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getSummonPercent(float partialTick) {
        return this.summonTime > 0 ? this.getSummonTime(partialTick) / 35.0f : 0.0f;
    }

    private boolean isExemptFromSmashAttack(Entity entity) {
        return !entity.func_184222_aU() || entity.func_189652_ae() || entity.func_200600_R() == GFRegistry.GIGANTE_ENTITY || entity.func_200600_R() == GFRegistry.MAD_COW_ENTITY || entity.func_175149_v() || entity instanceof PlayerEntity && ((PlayerEntity)entity).func_184812_l_();
    }

    private void useSmashAttack(Entity entity) {
        if (entity.func_233570_aj_() && !this.isExemptFromSmashAttack(entity)) {
            entity.func_70024_g(0.0, 0.65, 0.0);
            entity.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)this.func_110148_a(Attributes.field_233823_f_).func_111126_e());
            if (entity instanceof LivingEntity) {
                LivingEntity target = (LivingEntity)entity;
                if (GreekFantasy.CONFIG.isStunningNerf()) {
                    target.func_195064_c(new EffectInstance(Effects.field_76421_d, 35, 0));
                    target.func_195064_c(new EffectInstance(Effects.field_76437_t, 35, 0));
                } else {
                    target.func_195064_c(new EffectInstance(GFRegistry.STUNNED_EFFECT, 35, 0));
                }
            }
        }
    }

    private void destroyIntersectingBlocks(double offset) {
        if (!this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223599_b)) {
            return;
        }
        Vector3d facing = Vector3d.func_189984_a((Vector2f)this.func_189653_aC());
        AxisAlignedBB box = this.func_174813_aQ().func_191194_a(facing.func_72432_b().func_186678_a(offset));
        BlockPos.Mutable p = new BlockPos.Mutable();
        for (double x = box.field_72340_a - 0.25; x < box.field_72336_d + 0.25; x += 1.0) {
            for (double y = box.field_72338_b + 1.1; y < box.field_72337_e + 0.5; y += 1.0) {
                for (double z = box.field_72339_c - 0.25; z < box.field_72334_f + 0.25; z += 1.0) {
                    p.func_189532_c(x, y, z);
                    BlockState s = this.func_130014_f_().func_180495_p((BlockPos)p);
                    if (!s.func_200132_m() && !s.func_185904_a().func_76230_c() || s.func_235714_a_((ITag)BlockTags.field_219755_X)) continue;
                    this.func_130014_f_().func_175655_b((BlockPos)p, true);
                }
            }
        }
    }

    class SummonCowGoal
    extends SummonMobGoal<MadCowEntity> {
        public SummonCowGoal(int summonProgressIn, int summonCooldownIn) {
            super((MobEntity)GeryonEntity.this, summonProgressIn, summonCooldownIn, GFRegistry.MAD_COW_ENTITY);
        }

        @Override
        public boolean func_75250_a() {
            return super.func_75250_a() && GeryonEntity.this.hasNoCooldown() && GeryonEntity.this.isNoneState();
        }

        @Override
        public void func_75249_e() {
            super.func_75249_e();
            GeryonEntity.this.setSummoning(true);
        }

        @Override
        protected void summonMob(MadCowEntity mobEntity) {
            super.summonMob(mobEntity);
            GeryonEntity.this.func_130014_f_().func_72960_a((Entity)GeryonEntity.this, (byte)11);
        }

        @Override
        public void func_75251_c() {
            super.func_75251_c();
            GeryonEntity.this.setAttackCooldown();
            GeryonEntity.this.setSummoning(false);
        }
    }

    class SmashAttackGoal
    extends Goal {
        private final double range;
        private final int maxCooldown;
        private int cooldown = 90;
        private boolean isBlockSmash;

        public SmashAttackGoal(double rangeIn, int maxCooldownIn) {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
            this.range = rangeIn;
            this.maxCooldown = maxCooldownIn;
        }

        public void func_75249_e() {
            GeryonEntity.this.setSmashAttack(true);
            GeryonEntity.this.func_70661_as().func_75494_a((Entity)GeryonEntity.this.func_70638_az(), 0);
            this.isBlockSmash = GeryonEntity.this.func_70661_as().func_75500_f();
        }

        public boolean func_75250_a() {
            if (this.cooldown > 0) {
                --this.cooldown;
                return false;
            }
            return GeryonEntity.this.func_70638_az() != null && GeryonEntity.this.isNoneState() && GeryonEntity.this.hasNoCooldown() && GeryonEntity.this.func_70068_e((Entity)GeryonEntity.this.func_70638_az()) < this.range * this.range;
        }

        public void func_75246_d() {
            GeryonEntity.this.func_70661_as().func_75499_g();
            GeryonEntity.this.func_70671_ap().func_75651_a((Entity)GeryonEntity.this.func_70638_az(), (float)GeryonEntity.this.func_184649_cE(), (float)GeryonEntity.this.func_70646_bf());
            if (GeryonEntity.this.smashTime >= 42) {
                GeryonEntity.this.func_130014_f_().func_72960_a((Entity)GeryonEntity.this, (byte)10);
                GeryonEntity.this.func_130014_f_().func_72839_b((Entity)GeryonEntity.this, GeryonEntity.this.func_174813_aQ().func_72314_b(this.range, this.range / 2.0, this.range)).forEach(e -> GeryonEntity.this.useSmashAttack(e));
                GeryonEntity.this.setAttackCooldown();
                if (this.isBlockSmash) {
                    GeryonEntity.this.destroyIntersectingBlocks(2.5);
                }
                this.func_75251_c();
            }
        }

        public boolean func_75253_b() {
            return GeryonEntity.this.isSmashAttack() && GeryonEntity.this.func_70638_az() != null && GeryonEntity.this.func_70068_e((Entity)GeryonEntity.this.func_70638_az()) < this.range * this.range;
        }

        public void func_75251_c() {
            GeryonEntity.this.setSmashAttack(false);
            GeryonEntity.this.smashTime = 0;
            this.isBlockSmash = false;
            this.cooldown = this.maxCooldown;
        }
    }

    class MeleeAttackGoal
    extends net.minecraft.entity.ai.goal.MeleeAttackGoal {
        public MeleeAttackGoal(CreatureEntity creature, double speedIn, boolean useLongMemory) {
            super(creature, speedIn, useLongMemory);
        }

        protected void func_190102_a(LivingEntity enemy, double distToEnemySqr) {
            if (GeryonEntity.this.hasNoCooldown()) {
                super.func_190102_a(enemy, distToEnemySqr);
            }
        }

        protected void func_234039_g_() {
            super.func_234039_g_();
            GeryonEntity.this.setAttackCooldown();
        }
    }

    class SpawningGoal
    extends Goal {
        public SpawningGoal() {
            this.func_220684_a(EnumSet.allOf(Goal.Flag.class));
        }

        public boolean func_75250_a() {
            return GeryonEntity.this.isSpawning();
        }

        public void func_75246_d() {
            GeryonEntity.this.func_70661_as().func_75499_g();
        }
    }
}

