/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.entity;

import greekfantasy.GFRegistry;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.monster.HoglinEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.BossInfo;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerBossInfo;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class GiantBoarEntity
extends HoglinEntity {
    private static final DataParameter<Boolean> SPAWNING = EntityDataManager.func_187226_a(GiantBoarEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final String KEY_SPAWNING = "Spawning";
    private static final String KEY_SPAWN_TIME = "SpawnTime";
    private static final byte SPAWN_CLIENT = 9;
    private static final int MAX_SPAWN_TIME = 90;
    private final ServerBossInfo bossInfo = new ServerBossInfo(this.func_145748_c_(), BossInfo.Color.RED, BossInfo.Overlay.PROGRESS);
    private int spawnTime;

    public GiantBoarEntity(EntityType<? extends GiantBoarEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70138_W = 1.0f;
        this.field_70728_aV = 30;
    }

    public static AttributeModifierMap.MutableAttribute getAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 80.0).func_233815_a_(Attributes.field_233821_d_, 0.31).func_233815_a_(Attributes.field_233820_c_, 0.82).func_233815_a_(Attributes.field_233824_g_, 1.25).func_233815_a_(Attributes.field_233823_f_, 6.0).func_233815_a_(Attributes.field_233826_i_, 6.0);
    }

    public static GiantBoarEntity spawnGiantBoar(ServerWorld world, HoglinEntity hoglin) {
        GiantBoarEntity entity = (GiantBoarEntity)GFRegistry.GIANT_BOAR_ENTITY.func_200721_a((World)world);
        entity.func_82149_j((Entity)hoglin);
        entity.func_213386_a((IServerWorld)world, world.func_175649_E(hoglin.func_233580_cy_()), SpawnReason.CONVERSION, null, null);
        if (hoglin.func_145818_k_()) {
            entity.func_200203_b(hoglin.func_200201_e());
            entity.func_174805_g(hoglin.func_174833_aM());
        }
        entity.func_110163_bv();
        entity.field_70761_aq = hoglin.field_70761_aq;
        entity.func_242279_ag();
        world.func_217376_c((Entity)entity);
        entity.setSpawning(true);
        hoglin.func_70106_y();
        for (ServerPlayerEntity player : world.func_217357_a(ServerPlayerEntity.class, entity.func_174813_aQ().func_186662_g(25.0))) {
            CriteriaTriggers.field_192133_m.func_192229_a(player, (Entity)entity);
        }
        world.func_184134_a(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), SoundEvents.field_187855_gD, entity.func_184176_by(), 1.2f, 1.0f, false);
        return entity;
    }

    public void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(SPAWNING, (Object)false);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new SpawningGoal());
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
        if (this.spawnTime > 0) {
            this.func_70624_b(null);
            double width = this.func_213311_cf();
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197625_r, this.func_226277_ct_() + (this.field_70146_Z.nextDouble() - 0.5) * width, this.func_226278_cu_() + this.field_70146_Z.nextDouble(), this.func_226281_cx_() + (this.field_70146_Z.nextDouble() - 0.5) * width, 0.01, 0.01, 0.01);
            if (this.spawnTime++ >= 90) {
                this.setSpawning(false);
            }
        }
    }

    public boolean func_70877_b(ItemStack stack) {
        return false;
    }

    public boolean func_204701_dC() {
        return false;
    }

    public boolean func_234365_eM_() {
        return false;
    }

    public boolean func_234364_eK_() {
        return false;
    }

    public boolean func_180431_b(DamageSource source) {
        return this.isSpawning() || source == DamageSource.field_76368_d || source == DamageSource.field_82727_n || super.func_180431_b(source);
    }

    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        ILivingEntityData data = super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.func_234370_t_(true);
        this.func_82227_f(false);
        this.setSpawning(true);
        return data;
    }

    protected boolean func_225511_J_() {
        return true;
    }

    protected void func_175500_n() {
    }

    protected float func_70599_aP() {
        return 1.5f;
    }

    protected float func_70647_i() {
        return 0.62f + this.field_70146_Z.nextFloat() * 0.24f;
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a(KEY_SPAWNING, this.isSpawning());
        compound.func_74768_a(KEY_SPAWN_TIME, this.spawnTime);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setSpawning(compound.func_74767_n(KEY_SPAWNING));
        this.spawnTime = compound.func_74762_e(KEY_SPAWN_TIME);
    }

    public boolean func_70104_M() {
        return false;
    }

    protected void func_85033_bc() {
    }

    public boolean func_184222_aU() {
        return false;
    }

    public boolean func_213397_c(double disToPlayer) {
        return false;
    }

    protected boolean func_184228_n(Entity entityIn) {
        return false;
    }

    public void func_184178_b(ServerPlayerEntity player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(ServerPlayerEntity player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 9) {
            this.setSpawning(true);
        } else {
            super.func_70103_a(id);
        }
    }

    public boolean isSpawning() {
        return this.spawnTime > 0 || (Boolean)this.func_184212_Q().func_187225_a(SPAWNING) != false;
    }

    public void setSpawning(boolean spawning) {
        this.spawnTime = spawning ? 1 : 0;
        this.func_184212_Q().func_187227_b(SPAWNING, (Object)spawning);
        if (spawning && !this.field_70170_p.func_201670_d()) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)9);
        }
    }

    public float getSpawnPercent(float partialTick) {
        if (this.spawnTime <= 0) {
            return 1.0f;
        }
        float prevSpawnPercent = Math.max((float)this.spawnTime - partialTick, 0.0f) / 90.0f;
        float spawnPercent = (float)this.spawnTime / 90.0f;
        return MathHelper.func_219799_g((float)(partialTick / 8.0f), (float)prevSpawnPercent, (float)spawnPercent);
    }

    class SpawningGoal
    extends Goal {
        public SpawningGoal() {
            this.func_220684_a(EnumSet.allOf(Goal.Flag.class));
        }

        public boolean func_75250_a() {
            return GiantBoarEntity.this.isSpawning();
        }

        public void func_75246_d() {
            GiantBoarEntity.this.func_70661_as().func_75499_g();
        }
    }
}

