/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.entity;

import greekfantasy.GFRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IAngerable;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.SheepEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RangedInteger;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.TickRangeConverter;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class GoldenRamEntity
extends SheepEntity
implements IAngerable {
    private static final RangedInteger ANGER_RANGE = TickRangeConverter.func_233037_a_((int)20, (int)39);
    private int angerTime;
    private UUID angerTarget;

    public GoldenRamEntity(EntityType<? extends GoldenRamEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public static AttributeModifierMap.MutableAttribute getAttributes() {
        return SheepEntity.func_234225_eI_().func_233815_a_(Attributes.field_233818_a_, 20.0).func_233815_a_(Attributes.field_233826_i_, 4.0).func_233815_a_(Attributes.field_233823_f_, 3.0).func_233815_a_(Attributes.field_233824_g_, 1.5);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.54, true));
        this.field_70715_bh.func_75776_a(3, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.func_70892_o()) {
            SheepEntity entity = (SheepEntity)EntityType.field_200737_ac.func_200721_a(this.field_70170_p);
            entity.func_82149_j((Entity)this);
            entity.field_70761_aq = this.field_70761_aq;
            entity.func_242279_ag();
            entity.func_175512_b(this.func_175509_cj());
            entity.func_70893_e(true);
            entity.func_70873_a(this.func_70874_b());
            this.field_70170_p.func_217376_c((Entity)entity);
            this.func_70106_y();
        }
    }

    public List<ItemStack> onSheared(@Nullable PlayerEntity player, @Nonnull ItemStack item, World world, BlockPos pos, int fortune) {
        world.func_217384_a(null, (Entity)this, SoundEvents.field_187763_eJ, player == null ? SoundCategory.BLOCKS : SoundCategory.PLAYERS, 1.0f, 0.8f);
        if (!world.func_201670_d()) {
            this.func_70893_e(true);
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            items.add(new ItemStack((IItemProvider)GFRegistry.GOLDEN_FLEECE));
            if (this.field_70146_Z.nextBoolean() || fortune > 0) {
                items.add(new ItemStack((IItemProvider)GFRegistry.HORN));
            }
            return items;
        }
        return Collections.emptyList();
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return false;
    }

    public ResourceLocation func_184647_J() {
        return this.func_200600_R().func_220348_g();
    }

    public boolean func_70877_b(ItemStack stack) {
        return false;
    }

    public boolean func_70878_b(AnimalEntity otherAnimal) {
        return false;
    }

    @Nullable
    public SheepEntity func_241840_a(ServerWorld world, AgeableEntity parentB) {
        return null;
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        ILivingEntityData data = super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.func_175512_b(DyeColor.YELLOW);
        this.func_82227_f(false);
        return data;
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        this.func_233682_c_(compound);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.func_241358_a_((ServerWorld)this.field_70170_p, compound);
    }

    public void func_230258_H__() {
        this.func_230260_a__(ANGER_RANGE.func_233018_a_(this.field_70146_Z));
    }

    public void func_230260_a__(int time) {
        this.angerTime = time;
    }

    public int func_230256_F__() {
        return this.angerTime;
    }

    public void func_230259_a_(@Nullable UUID target) {
        this.angerTarget = target;
    }

    public UUID func_230257_G__() {
        return this.angerTarget;
    }
}

