/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.entity;

import greekfantasy.GFRegistry;
import greekfantasy.GreekFantasy;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.item.BowItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.BossInfo;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerBossInfo;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class GorgonEntity
extends MonsterEntity
implements IRangedAttackMob {
    private static final DataParameter<Boolean> MEDUSA = EntityDataManager.func_187226_a(GorgonEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final String KEY_MEDUSA = "Medusa";
    protected static final byte STARE_ATTACK = 9;
    protected static final int PETRIFY_DURATION = 80;
    private static final ResourceLocation MEDUSA_LOOT = new ResourceLocation("greekfantasy", "entities/medusa");
    private final ServerBossInfo bossInfo = new ServerBossInfo(this.func_145748_c_(), BossInfo.Color.GREEN, BossInfo.Overlay.PROGRESS);
    private final RangedAttackGoal rangedAttackGoal = new RangedAttackGoal(this, 1.0, 45, 15.0f);

    public GorgonEntity(EntityType<? extends GorgonEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public static AttributeModifierMap.MutableAttribute getAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 24.0).func_233815_a_(Attributes.field_233821_d_, 0.26).func_233815_a_(Attributes.field_233823_f_, 2.0).func_233815_a_(Attributes.field_233819_b_, 24.0);
    }

    public void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(MEDUSA, (Object)false);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(4, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, true));
        this.field_70714_bg.func_75776_a(5, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 10.0f));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
        if (((Boolean)GreekFantasy.CONFIG.GORGON_ATTACK.get()).booleanValue()) {
            this.field_70714_bg.func_75776_a(2, (Goal)new StareAttackGoal(this, 100));
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
    }

    public void func_241841_a(ServerWorld world, LightningBoltEntity bolt) {
        if (world.func_175659_aa() != Difficulty.PEACEFUL && (double)this.field_70146_Z.nextInt(100) < GreekFantasy.CONFIG.getLightningMedusaChance()) {
            this.setMedusa(true);
            this.func_70606_j(this.func_110138_aP());
            this.func_110163_bv();
            this.func_70015_d(2);
        } else {
            super.func_241841_a(world, bolt);
        }
    }

    public boolean func_180431_b(DamageSource source) {
        if (source.func_76346_g() != null && source.func_76346_g().func_200600_R() == GFRegistry.GORGON_ENTITY) {
            return true;
        }
        return super.func_180431_b(source);
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        if (this.func_70681_au().nextDouble() * 100.0 < GreekFantasy.CONFIG.getGorgonMedusaChance()) {
            this.setMedusa(true);
        }
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        switch (id) {
            case 9: {
                this.spawnStareParticles();
                break;
            }
            default: {
                super.func_70103_a(id);
            }
        }
    }

    public void spawnStareParticles() {
        if (this.field_70170_p.func_201670_d()) {
            double motion = 0.08;
            double radius = 1.2;
            for (int i = 0; i < 5; ++i) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197624_q, this.func_226277_ct_() + (this.field_70170_p.field_73012_v.nextDouble() - 0.5) * 1.2, this.func_226280_cw_() + (this.field_70170_p.field_73012_v.nextDouble() - 0.5) * 1.2 * 0.75, this.func_226281_cx_() + (this.field_70170_p.field_73012_v.nextDouble() - 0.5) * 1.2, (this.field_70170_p.field_73012_v.nextDouble() - 0.5) * 0.08, (this.field_70170_p.field_73012_v.nextDouble() - 0.5) * 0.08 * 0.5, (this.field_70170_p.field_73012_v.nextDouble() - 0.5) * 0.08);
            }
            List list = this.func_130014_f_().func_175647_a(PlayerEntity.class, this.func_174813_aQ().func_72314_b(16.0, 16.0, 16.0), e -> e.func_70660_b(GFRegistry.PETRIFIED_EFFECT) != null);
            for (PlayerEntity p : list) {
                this.field_70170_p.func_195590_a((IParticleData)GFRegistry.GORGON_PARTICLE, true, p.func_226277_ct_(), p.func_226278_cu_(), p.func_226281_cx_(), 0.0, 0.0, 0.0);
            }
        }
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_189106_R;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187817_fK;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187819_fL;
    }

    protected float func_70599_aP() {
        return 0.8f;
    }

    public void func_82196_d(LivingEntity target, float distanceFactor) {
        ItemStack itemstack = this.func_213356_f(this.func_184586_b(ProjectileHelper.func_221274_a((LivingEntity)this, (Item)Items.field_151031_f)));
        AbstractArrowEntity arrow = ProjectileHelper.func_221272_a((LivingEntity)this, (ItemStack)itemstack, (float)distanceFactor);
        if (this.func_184614_ca().func_77973_b() instanceof BowItem) {
            arrow = ((BowItem)this.func_184614_ca().func_77973_b()).customArrow(arrow);
        }
        arrow.func_70107_b(this.func_226277_ct_() - (double)(this.func_213311_cf() + 1.0f) * 0.5 * (double)MathHelper.func_76126_a((float)(this.field_70761_aq * ((float)Math.PI / 180))), this.func_226280_cw_() - 0.1, this.func_226281_cx_() + (double)(this.func_213311_cf() + 1.0f) * 0.5 * (double)MathHelper.func_76134_b((float)(this.field_70761_aq * ((float)Math.PI / 180))));
        double dx = target.func_226277_ct_() - arrow.func_226277_ct_();
        double dy = target.func_226283_e_(0.67) - arrow.func_226278_cu_();
        double dz = target.func_226281_cx_() - arrow.func_226281_cx_();
        double dis = MathHelper.func_76133_a((double)(dx * dx + dz * dz));
        arrow.func_70186_c(dx, dy + dis * (double)0.2f, dz, 1.6f, (float)(14 - this.field_70170_p.func_175659_aa().func_151525_a() * 4));
        this.func_184185_a(SoundEvents.field_187737_v, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_217376_c((Entity)arrow);
    }

    public boolean isPlayerStaring(PlayerEntity player) {
        Vector3d vector3d = player.func_70676_i(1.0f).func_72432_b();
        Vector3d vector3d1 = new Vector3d(this.func_226277_ct_() - player.func_226277_ct_(), this.func_226280_cw_() - player.func_226280_cw_(), this.func_226281_cx_() - player.func_226281_cx_());
        double d0 = vector3d1.func_72433_c();
        double d1 = vector3d.func_72430_b(vector3d1 = vector3d1.func_72432_b());
        return d1 > 1.0 - 0.025 / d0 ? player.func_70685_l((Entity)this) : false;
    }

    public boolean isImmuneToStareAttack(LivingEntity target) {
        if (GreekFantasy.CONFIG.isMirrorPotionEnabled() && target.func_70660_b(GFRegistry.MIRROR_EFFECT) != null || target.func_175149_v() || !target.func_184222_aU() || target instanceof PlayerEntity && ((PlayerEntity)target).func_184812_l_()) {
            return true;
        }
        return GreekFantasy.CONFIG.isMirrorEnabled() && EnchantmentHelper.func_82781_a((ItemStack)target.func_184586_b(Hand.OFF_HAND)).containsKey(GFRegistry.MIRROR_ENCHANTMENT);
    }

    protected void useStareAttack(LivingEntity target) {
        if (GreekFantasy.CONFIG.isParalysisNerf()) {
            target.func_195064_c(new EffectInstance(Effects.field_76421_d, 80, 1, false, false, true));
            target.func_195064_c(new EffectInstance(Effects.field_76437_t, 80, 1, false, false, true));
        } else {
            target.func_195064_c(new EffectInstance(GFRegistry.PETRIFIED_EFFECT, 80, 0, false, false, true));
        }
        if (this.isMedusa()) {
            target.func_195064_c(new EffectInstance(Effects.field_82731_v, 80, 0));
        }
        if (this.func_70613_aW()) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)9);
        }
    }

    public static boolean isMirrorShield(ItemStack stack) {
        return EnchantmentHelper.func_82781_a((ItemStack)stack).containsKey(GFRegistry.MIRROR_ENCHANTMENT);
    }

    public void setMedusa(boolean medusa) {
        this.func_184212_Q().func_187227_b(MEDUSA, (Object)medusa);
        this.updateCombatGoal(medusa);
        if (medusa) {
            this.func_200203_b((ITextComponent)new TranslationTextComponent(this.func_200600_R().func_210760_d().concat(".medusa")));
        }
    }

    public boolean isMedusa() {
        return (Boolean)this.func_184212_Q().func_187225_a(MEDUSA);
    }

    public void func_184206_a(DataParameter<?> key) {
        super.func_184206_a(key);
        if (key == MEDUSA) {
            if (this.isMedusa()) {
                double medusaHealth = 84.0;
                this.func_110148_a(Attributes.field_233818_a_).func_111128_a(84.0);
                this.func_110148_a(Attributes.field_233823_f_).func_111128_a(4.0);
                this.func_110148_a(Attributes.field_233821_d_).func_111128_a(0.3);
                this.func_70606_j(84.0f);
                this.updateCombatGoal(true);
                if (GreekFantasy.CONFIG.showMedusaBossBar()) {
                    this.bossInfo.func_186758_d(true);
                }
            } else {
                this.func_110148_a(Attributes.field_233823_f_).func_111128_a(2.0);
                this.func_110148_a(Attributes.field_233818_a_).func_111128_a(24.0);
                this.func_110148_a(Attributes.field_233821_d_).func_111128_a(0.26);
                this.bossInfo.func_186758_d(false);
                this.updateCombatGoal(false);
            }
        }
    }

    public void updateCombatGoal(boolean medusa) {
        if (this.func_70613_aW()) {
            if (medusa) {
                this.field_70714_bg.func_75776_a(3, (Goal)this.rangedAttackGoal);
                if (!(this.func_184614_ca().func_77973_b() instanceof BowItem)) {
                    this.func_184611_a(Hand.MAIN_HAND, new ItemStack((IItemProvider)Items.field_151031_f));
                }
            } else {
                this.field_70714_bg.func_85156_a((Goal)this.rangedAttackGoal);
                if (this.func_184614_ca().func_77973_b() instanceof BowItem) {
                    this.func_184611_a(Hand.MAIN_HAND, ItemStack.field_190927_a);
                }
            }
        }
    }

    public boolean func_184222_aU() {
        return !this.isMedusa();
    }

    public ResourceLocation func_184647_J() {
        return this.isMedusa() ? MEDUSA_LOOT : super.func_184647_J();
    }

    public void func_184178_b(ServerPlayerEntity player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
        this.bossInfo.func_186739_a(this.func_145818_k_() ? this.func_200201_e() : this.func_145748_c_());
        this.bossInfo.func_186758_d(this.isMedusa() && GreekFantasy.CONFIG.showMedusaBossBar());
    }

    public void func_184203_c(ServerPlayerEntity player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a(KEY_MEDUSA, this.isMedusa());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setMedusa(compound.func_74767_n(KEY_MEDUSA));
        this.updateCombatGoal(this.isMedusa());
    }

    class RangedAttackGoal
    extends net.minecraft.entity.ai.goal.RangedAttackGoal {
        public RangedAttackGoal(IRangedAttackMob entity, double moveSpeed, int attackInterval, float attackDistance) {
            super(entity, moveSpeed, attackInterval, attackDistance);
        }

        public boolean func_75250_a() {
            return super.func_75250_a() && GorgonEntity.this.func_70068_e((Entity)GorgonEntity.this.func_70638_az()) > 16.0 && GorgonEntity.this.func_184614_ca().func_77973_b() instanceof BowItem;
        }

        public void func_75249_e() {
            super.func_75249_e();
            GorgonEntity.this.func_213395_q(true);
        }

        public void func_75251_c() {
            super.func_75251_c();
            GorgonEntity.this.func_213395_q(false);
        }
    }

    public static class StareAttackGoal
    extends Goal {
        private final GorgonEntity entity;
        private final int maxCooldown;
        private int cooldown;
        private List<PlayerEntity> trackedPlayers = new ArrayList<PlayerEntity>();

        public StareAttackGoal(GorgonEntity entityIn, int cooldown) {
            this.func_220684_a(EnumSet.of(Goal.Flag.LOOK));
            this.entity = entityIn;
            this.maxCooldown = cooldown;
            this.cooldown = cooldown / 4;
        }

        public boolean func_75250_a() {
            if (this.cooldown > 0) {
                --this.cooldown;
            } else {
                this.trackedPlayers = this.entity.func_130014_f_().func_175647_a(PlayerEntity.class, this.entity.func_174813_aQ().func_72314_b(16.0, 16.0, 16.0), e -> this.entity.func_213336_c((LivingEntity)e) && !this.entity.isImmuneToStareAttack((LivingEntity)e) && this.entity.isPlayerStaring((PlayerEntity)e));
                return !this.trackedPlayers.isEmpty();
            }
            return false;
        }

        public void func_75249_e() {
            if (!this.trackedPlayers.isEmpty() && this.trackedPlayers.get(0) != null && this.cooldown <= 0) {
                this.entity.func_70661_as().func_75499_g();
                this.entity.func_70671_ap().func_75651_a((Entity)this.trackedPlayers.get(0), 100.0f, 100.0f);
                this.trackedPlayers.forEach(e -> this.entity.useStareAttack((LivingEntity)e));
                this.trackedPlayers.clear();
                this.cooldown = this.maxCooldown;
            }
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75251_c() {
            this.cooldown = this.maxCooldown;
        }
    }
}

