/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.entity;

import greekfantasy.GFRegistry;
import greekfantasy.entity.DryadEntity;
import greekfantasy.entity.ai.FindBlockGoal;
import java.util.EnumSet;
import java.util.Optional;
import net.minecraft.block.BlockState;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.FlyingMovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.IFlyingAnimal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.FlyingPathNavigator;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class HarpyEntity
extends MonsterEntity
implements IFlyingAnimal {
    private static final DataParameter<Optional<BlockPos>> DATA_NEST = EntityDataManager.func_187226_a(HarpyEntity.class, (IDataSerializer)DataSerializers.field_187201_k);
    private static final String KEY_NEST = "Nest";
    public float flyingTime;
    private boolean isGoingToNest;

    public HarpyEntity(EntityType<? extends HarpyEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70765_h = new FlyingMovementController((MobEntity)this, 10, false);
        this.func_184644_a(PathNodeType.DANGER_FIRE, -1.0f);
        this.func_184644_a(PathNodeType.DAMAGE_FIRE, -1.0f);
    }

    public static AttributeModifierMap.MutableAttribute getAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 24.0).func_233815_a_(Attributes.field_233821_d_, 0.22).func_233815_a_(Attributes.field_233823_f_, 3.0).func_233815_a_(Attributes.field_233822_e_, 1.29).func_233815_a_(Attributes.field_233820_c_, 0.32);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(DATA_NEST, Optional.empty());
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, true));
        this.field_70714_bg.func_75776_a(2, (Goal)new FindNestGoal(6, 10, 60));
        this.field_70714_bg.func_75776_a(3, (Goal)new GoToNestGoal(0.9, 120));
        this.field_70714_bg.func_75776_a(4, (Goal)new WaterAvoidingRandomFlyingGoal((CreatureEntity)this, 0.9){

            public boolean func_75250_a() {
                return !HarpyEntity.this.isGoingToNest && HarpyEntity.this.func_70681_au().nextInt(200) == 0 && super.func_75250_a();
            }
        });
        this.field_70714_bg.func_75776_a(5, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, DryadEntity.class, true));
    }

    protected PathNavigator func_175447_b(World worldIn) {
        FlyingPathNavigator flyingpathnavigator = new FlyingPathNavigator((MobEntity)this, worldIn);
        flyingpathnavigator.func_192879_a(false);
        flyingpathnavigator.func_212239_d(true);
        flyingpathnavigator.func_192878_b(true);
        return flyingpathnavigator;
    }

    public void func_70636_d() {
        Optional<BlockPos> nestPos;
        super.func_70636_d();
        Vector3d m = this.func_213322_ci();
        if (this.func_70613_aW() && !this.field_70122_E && m.field_72448_b < 0.0) {
            double multY = this.func_70638_az() != null ? 0.9 : 0.6;
            this.func_213317_d(m.func_216372_d(1.0, multY, 1.0));
        }
        this.flyingTime = this.isFlying() ? Math.min(1.0f, this.flyingTime + 0.1f) : Math.max(0.0f, this.flyingTime - 0.1f);
        if (this.field_70173_aa % 90 == 0 && (nestPos = this.getNestPos()).isPresent() && !this.field_70170_p.func_180495_p(nestPos.get()).func_203425_a(GFRegistry.NEST_BLOCK)) {
            this.setNestPos(Optional.empty());
        }
    }

    protected SoundEvent func_184639_G() {
        return this.field_70146_Z.nextFloat() < 0.18f ? SoundEvents.field_187920_gt : SoundEvents.field_192792_ep;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return this.field_70146_Z.nextFloat() < 0.09f ? SoundEvents.field_187923_gw : SoundEvents.field_192794_er;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187553_bI;
    }

    protected float func_70599_aP() {
        return 0.8f;
    }

    protected float func_70647_i() {
        return 0.7f + this.field_70146_Z.nextFloat() * 0.2f;
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        Optional<BlockPos> nestPos = this.getNestPos();
        if (nestPos.isPresent()) {
            compound.func_74768_a("Nest.x", nestPos.get().func_177958_n());
            compound.func_74768_a("Nest.y", nestPos.get().func_177956_o());
            compound.func_74768_a("Nest.z", nestPos.get().func_177952_p());
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("Nest.x")) {
            int x = compound.func_74762_e("Nest.x");
            int y = compound.func_74762_e("Nest.y");
            int z = compound.func_74762_e("Nest.z");
            this.setNestPos(Optional.of(new BlockPos(x, y, z)));
        }
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    protected void func_184231_a(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    protected boolean func_191957_ae() {
        return true;
    }

    protected float func_191954_d(float volume) {
        this.func_184185_a(SoundEvents.field_192796_et, 0.25f, 0.9f);
        return volume;
    }

    public boolean isFlying() {
        return !this.field_70122_E || this.func_213322_ci().func_189985_c() > 0.06;
    }

    public void setNestPos(Optional<BlockPos> pos) {
        this.func_184212_Q().func_187227_b(DATA_NEST, pos);
        if (pos.isPresent()) {
            this.func_213390_a(pos.get(), (int)(this.func_110148_a(Attributes.field_233819_b_).func_111125_b() * 1.75));
        } else {
            this.func_213390_a(BlockPos.field_177992_a, -1);
        }
    }

    public Optional<BlockPos> getNestPos() {
        return (Optional)this.func_184212_Q().func_187225_a(DATA_NEST);
    }

    class GoToNestGoal
    extends Goal {
        private final double speed;
        private final int chance;

        public GoToNestGoal(double speedIn, int chanceIn) {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
            this.speed = speedIn;
            this.chance = chanceIn;
        }

        public boolean func_75250_a() {
            return HarpyEntity.this.getNestPos().isPresent() && !this.isNearNest(4.0) && HarpyEntity.this.func_70638_az() == null && HarpyEntity.this.func_70681_au().nextInt(this.chance) == 0;
        }

        public void func_75249_e() {
            Optional<BlockPos> nestPos = HarpyEntity.this.getNestPos();
            if (nestPos.isPresent()) {
                Vector3d vec = new Vector3d((double)nestPos.get().func_177958_n() + 0.5, (double)nestPos.get().func_177956_o(), (double)nestPos.get().func_177952_p() + 0.5);
                HarpyEntity.this.func_70661_as().func_75492_a(vec.func_82615_a(), vec.func_82617_b(), vec.func_82616_c(), this.speed);
                HarpyEntity.this.isGoingToNest = true;
            }
        }

        public boolean func_75253_b() {
            return HarpyEntity.this.getNestPos().isPresent() && !HarpyEntity.this.func_70661_as().func_75500_f() && HarpyEntity.this.func_70638_az() == null;
        }

        public void func_75251_c() {
            HarpyEntity.this.func_70661_as().func_75499_g();
            HarpyEntity.this.isGoingToNest = false;
        }

        protected boolean isNearNest(double distance) {
            Optional<BlockPos> nestPos = HarpyEntity.this.getNestPos();
            if (nestPos.isPresent()) {
                Vector3d vec = new Vector3d((double)nestPos.get().func_177958_n() + 0.5, (double)nestPos.get().func_177956_o() + 0.5, (double)nestPos.get().func_177952_p() + 0.5);
                return vec.func_237488_a_((IPosition)HarpyEntity.this.func_213303_ch(), distance);
            }
            return false;
        }
    }

    class FindNestGoal
    extends FindBlockGoal {
        public FindNestGoal(int radiusXZ, int radiusY, int cooldown) {
            super((CreatureEntity)HarpyEntity.this, radiusXZ, radiusY, cooldown);
        }

        @Override
        public boolean func_75250_a() {
            return !this.isNearTarget(2.5) && super.func_75250_a();
        }

        @Override
        protected Optional<BlockPos> findNearbyBlock() {
            Optional<BlockPos> nestPos = HarpyEntity.this.getNestPos();
            if (nestPos.isPresent() && this.isTargetBlock((IWorldReader)HarpyEntity.this.field_70170_p, nestPos.get())) {
                return nestPos;
            }
            return super.findNearbyBlock();
        }

        @Override
        public boolean isTargetBlock(IWorldReader worldIn, BlockPos pos) {
            return worldIn.func_180495_p(pos).func_203425_a(GFRegistry.NEST_BLOCK);
        }

        @Override
        public void onFoundBlock(IWorldReader worldIn, BlockPos pos) {
            HarpyEntity.this.setNestPos(Optional.of(pos));
        }
    }
}

