/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.entity;

import greekfantasy.GFRegistry;
import greekfantasy.entity.HydraHeadEntity;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.eventbus.api.Event;

public class HydraEntity
extends MonsterEntity {
    private static final DataParameter<Byte> HEADS = EntityDataManager.func_187226_a(HydraEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final String KEY_HEADS = "Heads";
    public static final int MAX_HEADS = 11;

    public HydraEntity(EntityType<? extends HydraEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70138_W = 1.0f;
    }

    public static AttributeModifierMap.MutableAttribute getAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 200.0).func_233815_a_(Attributes.field_233821_d_, 0.24).func_233815_a_(Attributes.field_233823_f_, 0.0).func_233815_a_(Attributes.field_233820_c_, 0.66).func_233815_a_(Attributes.field_233826_i_, 5.0).func_233815_a_(Attributes.field_233819_b_, 16.0);
    }

    public void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(HEADS, (Object)0);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new MoveToTargetGoal((CreatureEntity)this, 1.0, false));
        this.field_70714_bg.func_75776_a(5, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.8){

            public boolean func_75250_a() {
                return HydraEntity.this.field_70146_Z.nextInt(400) == 0 && super.func_75250_a();
            }
        });
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, false));
        this.field_70715_bh.func_75776_a(4, (Goal)new NearestAttackableTargetGoal((MobEntity)this, AnimalEntity.class, false, false));
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (!this.func_184188_bt().isEmpty() && !this.field_70170_p.func_201670_d()) {
            int charred = 0;
            for (Entity entity : this.func_184188_bt()) {
                HydraHeadEntity head = (HydraHeadEntity)entity;
                if (!head.isCharred()) continue;
                ++charred;
            }
            if (charred == this.getHeads()) {
                DamageSource source = this.func_189748_bU();
                this.func_70097_a(source != null ? source : DamageSource.field_76366_f, this.func_110138_aP() * 2.0f);
                this.func_184188_bt().forEach(e -> e.func_70106_y());
            } else if (this.func_110143_aJ() < this.func_110138_aP() && this.field_70146_Z.nextFloat() < 0.125f) {
                this.func_70691_i(1.25f * (float)(this.getHeads() - charred));
            }
        }
    }

    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        ILivingEntityData data = super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.addHead(0);
        this.addHead(1);
        this.addHead(2);
        this.func_82227_f(false);
        return data;
    }

    public boolean func_70687_e(EffectInstance potioneffectIn) {
        if (potioneffectIn.func_188419_a() == Effects.field_76436_u) {
            PotionEvent.PotionApplicableEvent event = new PotionEvent.PotionApplicableEvent((LivingEntity)this, potioneffectIn);
            MinecraftForge.EVENT_BUS.post((Event)event);
            return event.getResult() == Event.Result.ALLOW;
        }
        return super.func_70687_e(potioneffectIn);
    }

    public int getHeads() {
        return ((Byte)this.func_184212_Q().func_187225_a(HEADS)).intValue();
    }

    public void setHeads(int heads) {
        this.func_184212_Q().func_187227_b(HEADS, (Object)((byte)heads));
    }

    public HydraHeadEntity addHead(int id) {
        if (!this.field_70170_p.func_201670_d()) {
            HydraHeadEntity head = (HydraHeadEntity)GFRegistry.HYDRA_HEAD_ENTITY.func_200721_a(this.field_70170_p);
            head.func_70012_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 0.0f, 0.0f);
            head.setPartId(id);
            if (head.func_184220_m((Entity)this)) {
                this.setHeads(this.getHeads() + 1);
            } else {
                head.func_70106_y();
            }
            return head;
        }
        return null;
    }

    protected void func_184225_p(Entity passenger) {
        super.func_184225_p(passenger);
        this.setHeads(Math.max(0, this.getHeads() - 1));
    }

    public void func_184226_ay() {
        super.func_184226_ay();
        this.setHeads(0);
    }

    public void func_70106_y() {
        super.func_70106_y();
        for (Entity e : this.func_184188_bt()) {
            if (e.func_200600_R() != GFRegistry.HYDRA_HEAD_ENTITY) continue;
            e.func_70106_y();
        }
    }

    protected boolean func_184228_n(Entity entityIn) {
        return false;
    }

    protected boolean func_184219_q(Entity passenger) {
        return this.func_184188_bt().size() < 11;
    }

    public void updatePassenger(Entity passenger, int id, Entity.IMoveCallback callback) {
        if (this.func_184196_w(passenger)) {
            int headsPerRow = 5;
            int row = id / headsPerRow;
            double heads = this.getHeads();
            double radius = 0.08 + 0.4 * (double)this.func_213311_cf() + 0.35 * (double)row;
            double index = (double)(id % headsPerRow) - 0.92 * (double)this.func_213311_cf();
            double angleOff = Math.toRadians((double)this.field_70177_z + heads / (double)headsPerRow * 6.0) + 1.5707963267948966;
            double dx = this.func_226277_ct_() + radius * Math.cos(index / Math.PI + angleOff);
            double dy = this.func_226278_cu_() + this.func_70042_X() + passenger.func_70033_W();
            double dz = this.func_226281_cx_() + radius * Math.sin(index / Math.PI + angleOff);
            callback.accept(passenger, dx, dy, dz);
        }
    }

    public double func_70042_X() {
        return super.func_70042_X() + 0.32;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187594_A;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187543_bD;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187661_by;
    }

    protected float func_70599_aP() {
        return 1.2f;
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74774_a(KEY_HEADS, (byte)this.getHeads());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setHeads(compound.func_74771_c(KEY_HEADS));
    }

    class MoveToTargetGoal
    extends MeleeAttackGoal {
        public MoveToTargetGoal(CreatureEntity creature, double speedIn, boolean useLongMemoryIn) {
            super(creature, speedIn, useLongMemoryIn);
        }

        protected void func_190102_a(LivingEntity enemy, double distToEnemySqr) {
            double d0 = this.func_179512_a(enemy);
            if (distToEnemySqr <= d0 && this.func_234041_j_() <= 0) {
                this.func_234039_g_();
                HydraEntity.this.func_130011_c((Entity)enemy);
            }
        }
    }
}

