/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.entity;

import greekfantasy.entity.HydraEntity;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class HydraHeadEntity
extends MonsterEntity {
    private static final DataParameter<Byte> PART_ID = EntityDataManager.func_187226_a(HydraHeadEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Byte> STATE = EntityDataManager.func_187226_a(HydraHeadEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final String KEY_ID = "HydraHeadId";
    private static final String KEY_STATE = "HydraHeadState";
    private static final byte NORMAL = 0;
    private static final byte SEVERED = 1;
    private static final byte GROWING = 2;
    private static final byte CHARRED = 3;
    private static final byte GROWING_CLIENT = 8;
    private static final byte CHANGE_SIZE_CLIENT = 9;
    private final int maxSeveredTime = 100;
    private int severedTime;
    private final int maxGrowTime = 60;
    private int growTime;
    private final EntitySize severedSize;

    public HydraHeadEntity(EntityType<? extends HydraHeadEntity> type, World world) {
        super(type, world);
        this.severedSize = EntitySize.func_220314_b((float)(type.func_220333_h() * 0.75f), (float)(type.func_220344_i() * 0.25f));
    }

    public static AttributeModifierMap.MutableAttribute getAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 22.0).func_233815_a_(Attributes.field_233821_d_, 0.24).func_233815_a_(Attributes.field_233823_f_, 6.0);
    }

    public void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(PART_ID, (Object)0);
        this.func_184212_Q().func_187214_a(STATE, (Object)0);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(4, (Goal)new BiteAttackGoal());
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
        this.field_70715_bh.func_75776_a(4, (Goal)new NearestAttackableTargetGoal((MobEntity)this, AnimalEntity.class, false, false));
    }

    public void func_70071_h_() {
        if (!this.hasHydra() && !this.field_70170_p.func_201670_d()) {
            this.func_70106_y();
            return;
        }
        if (!this.isCharred() && this.isSevered() && this.severedTime > 0 && ++this.severedTime > 100) {
            this.severedTime = 0;
            this.setGrowing();
        }
        if (!this.isCharred() && this.isGrowing() && this.growTime > 0 && ++this.growTime > 60) {
            this.growTime = 0;
            this.func_70606_j(this.func_110138_aP());
            this.setNormal();
        }
        if (this.isCharred() || this.isSevered()) {
            this.func_213323_x_();
        }
        if (this.isCharred() && this.field_70170_p.func_201670_d() && this.field_70146_Z.nextInt(5) == 0) {
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197601_L, this.func_226277_ct_() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf(), this.func_226278_cu_() + (double)this.func_213302_cg(), this.func_226281_cx_() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf(), 0.0, 0.0, 0.0);
        }
        super.func_70071_h_();
    }

    public boolean func_180431_b(DamageSource source) {
        return (this.isSevered() || this.isGrowing()) && !source.func_76347_k() || this.isCharred() || source == DamageSource.field_76368_d || source == DamageSource.field_82727_n || super.func_180431_b(source);
    }

    public void func_70645_a(DamageSource cause) {
        if (this.func_223314_ad() > 0) {
            this.func_94061_f(true);
            this.setCharred();
        } else {
            this.setSevered();
            HydraHeadEntity head = this.getHydra().addHead(this.getHydra().getHeads());
            head.setSevered();
            this.field_70170_p.func_217376_c((Entity)head);
        }
        this.func_70606_j(1.0f);
        this.func_213323_x_();
        this.field_70170_p.func_72960_a((Entity)this, (byte)9);
    }

    protected ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (!itemstack.func_190926_b() && itemstack.func_77973_b() == Items.field_151033_d) {
            Vector3d pos = this.func_213303_ch();
            this.field_70170_p.func_184148_a(player, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, SoundEvents.field_187649_bu, this.func_184176_by(), 1.0f, this.field_70146_Z.nextFloat() * 0.4f + 0.8f);
            player.func_184609_a(hand);
            if (!this.field_70170_p.func_201670_d()) {
                this.func_70015_d(4 + this.field_70146_Z.nextInt(3));
                itemstack.func_222118_a(1, (LivingEntity)player, c -> c.func_213334_d(hand));
            }
            return ActionResultType.SUCCESS;
        }
        return super.func_230254_b_(player, hand);
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return false;
    }

    public boolean func_70067_L() {
        return this.isNormal();
    }

    protected boolean func_184228_n(Entity entityIn) {
        return entityIn instanceof HydraEntity;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (super.func_70097_a(source, amount) && this.hasHydra()) {
            this.getHydra().func_70097_a(source, amount * 0.1f);
            if (this.func_70638_az() != null) {
                this.getHydra().func_70624_b(this.func_70638_az());
            }
        }
        return false;
    }

    public void setPartId(int id) {
        this.func_184212_Q().func_187227_b(PART_ID, (Object)((byte)id));
    }

    public int getPartId() {
        return ((Byte)this.func_184212_Q().func_187225_a(PART_ID)).intValue();
    }

    public boolean hasHydra() {
        return this.func_184187_bx() instanceof HydraEntity;
    }

    @Nullable
    public HydraEntity getHydra() {
        if (this.func_184187_bx() instanceof HydraEntity) {
            return (HydraEntity)this.func_184187_bx();
        }
        return null;
    }

    public void func_70098_U() {
        this.func_213317_d(Vector3d.field_186680_a);
        if (this.canUpdate()) {
            this.func_70071_h_();
        }
        if (this.func_184218_aH() && this.hasHydra()) {
            HydraEntity hydra = this.getHydra();
            hydra.updatePassenger((Entity)this, this.getPartId(), Entity::func_70107_b);
            if (this.field_70759_as > hydra.field_70177_z + 80.0f) {
                this.field_70759_as = hydra.field_70177_z + 80.0f;
            } else if (this.field_70759_as < hydra.field_70177_z - 80.0f) {
                this.field_70759_as = hydra.field_70177_z - 80.0f;
            }
        }
    }

    public byte getHeadState() {
        return (Byte)this.func_184212_Q().func_187225_a(STATE);
    }

    public void setHeadState(byte state) {
        this.func_184212_Q().func_187227_b(STATE, (Object)state);
        this.func_213323_x_();
        if (!this.field_70170_p.func_201670_d()) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)9);
        }
    }

    public boolean isNormal() {
        return this.getHeadState() == 0;
    }

    public boolean isSevered() {
        return this.severedTime > 0 || this.getHeadState() == 1;
    }

    public boolean isGrowing() {
        return this.growTime > 0 || this.getHeadState() == 2;
    }

    public boolean isCharred() {
        return this.getHeadState() == 3;
    }

    public void setNormal() {
        this.setHeadState((byte)0);
    }

    public void setCharred() {
        this.setHeadState((byte)3);
    }

    public void setSevered() {
        this.setHeadState((byte)1);
        this.severedTime = 1;
    }

    public void setGrowing() {
        this.setHeadState((byte)2);
        this.growTime = 1;
        if (!this.field_70170_p.func_201670_d()) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)8);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        switch (id) {
            case 8: {
                this.setGrowing();
                this.func_213323_x_();
                break;
            }
            case 9: {
                this.func_213323_x_();
                break;
            }
            default: {
                super.func_70103_a(id);
            }
        }
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return this.isNormal() ? super.func_213305_a(poseIn) : this.severedSize;
    }

    protected float func_213348_b(Pose pose, EntitySize size) {
        return this.isNormal() ? super.func_213348_b(pose, size) : this.severedSize.field_220316_b * 0.85f;
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74774_a(KEY_ID, (byte)this.getPartId());
        compound.func_74774_a(KEY_STATE, this.getHeadState());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setPartId(compound.func_74771_c(KEY_ID));
        this.setHeadState(compound.func_74771_c(KEY_STATE));
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getSpawnPercent() {
        return this.growTime > 0 ? (float)this.growTime / 60.0f : 1.0f;
    }

    protected class BiteAttackGoal
    extends Goal {
        private final int attackInterval = 20;
        private int swingCooldown;
        private long lastCheckTime;

        public BiteAttackGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            long i = HydraHeadEntity.this.field_70170_p.func_82737_E();
            if (i - this.lastCheckTime < 20L || !HydraHeadEntity.this.isNormal()) {
                return false;
            }
            this.lastCheckTime = i;
            LivingEntity livingentity = HydraHeadEntity.this.func_70638_az();
            if (livingentity == null) {
                return false;
            }
            if (!livingentity.func_70089_S()) {
                return false;
            }
            return this.getAttackReachSqr(livingentity) >= HydraHeadEntity.this.func_70092_e(livingentity.func_226277_ct_(), livingentity.func_226278_cu_(), livingentity.func_226281_cx_());
        }

        public boolean func_75253_b() {
            LivingEntity livingentity = HydraHeadEntity.this.func_70638_az();
            if (livingentity == null) {
                return false;
            }
            if (!livingentity.func_70089_S()) {
                return false;
            }
            return EntityPredicates.field_233583_f_.test(livingentity);
        }

        public void func_75249_e() {
            HydraHeadEntity.this.func_213395_q(true);
            this.swingCooldown = 0;
        }

        public void func_75246_d() {
            LivingEntity livingentity = HydraHeadEntity.this.func_70638_az();
            HydraHeadEntity.this.func_70671_ap().func_75651_a((Entity)livingentity, 30.0f, 30.0f);
            double d0 = HydraHeadEntity.this.func_70092_e(livingentity.func_226277_ct_(), livingentity.func_226278_cu_(), livingentity.func_226281_cx_());
            this.swingCooldown = Math.max(this.swingCooldown - 1, 0);
            this.checkAndPerformAttack(livingentity, d0);
        }

        public void func_75251_c() {
            LivingEntity livingentity = HydraHeadEntity.this.func_70638_az();
            if (!EntityPredicates.field_188444_d.test(livingentity)) {
                HydraHeadEntity.this.func_70624_b(null);
            }
            HydraHeadEntity.this.func_213395_q(false);
        }

        protected void checkAndPerformAttack(LivingEntity enemy, double distToEnemySqr) {
            double d0 = this.getAttackReachSqr(enemy);
            if (distToEnemySqr <= d0 && this.swingCooldown <= 0) {
                this.swingCooldown = 20;
                HydraHeadEntity.this.func_184609_a(Hand.MAIN_HAND);
                HydraHeadEntity.this.func_70652_k((Entity)enemy);
            }
        }

        protected double getAttackReachSqr(LivingEntity attackTarget) {
            return HydraHeadEntity.this.func_213311_cf() * 4.5f * HydraHeadEntity.this.func_213311_cf() * 4.5f + attackTarget.func_213311_cf();
        }
    }
}

