/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.entity;

import com.google.common.collect.ImmutableMap;
import greekfantasy.GFRegistry;
import greekfantasy.entity.DryadEntity;
import greekfantasy.util.BiomeHelper;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.Tags;

public class LampadEntity
extends DryadEntity {
    protected static final Tags.IOptionalNamedTag<Item> LAMPAD_TRADES = ItemTags.createOptional((ResourceLocation)new ResourceLocation("greekfantasy", "lampad_trade"));

    public LampadEntity(EntityType<? extends LampadEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public static AttributeModifierMap.MutableAttribute getAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 24.0).func_233815_a_(Attributes.field_233821_d_, 0.26).func_233815_a_(Attributes.field_233823_f_, 3.0);
    }

    @Override
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        ILivingEntityData data = super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        Variant variant = reason == SpawnReason.COMMAND || reason == SpawnReason.SPAWN_EGG || reason == SpawnReason.SPAWNER || reason == SpawnReason.DISPENSER ? Variant.getRandom(worldIn.func_201674_k()) : Variant.getForBiome(worldIn.func_242406_i(this.func_233580_cy_()));
        this.setVariant(variant);
        if (worldIn.func_201674_k().nextFloat() < 0.2f) {
            this.func_184611_a(Hand.OFF_HAND, new ItemStack((IItemProvider)Items.field_234737_dp_));
        }
        return data;
    }

    @Override
    public Tags.IOptionalNamedTag<Item> getTradeTag() {
        return LAMPAD_TRADES;
    }

    @Override
    public DryadEntity.Variant getVariantByName(String name) {
        return Variant.getByName(name);
    }

    public static class Variant
    extends DryadEntity.Variant {
        public static final Variant CRIMSON = new Variant("crimson", () -> Blocks.field_235382_mv_);
        public static final Variant WARPED = new Variant("warped", () -> Blocks.field_235373_mm_);
        public static final Variant POMEGRANATE = new Variant("greekfantasy", "pomegranate", "lampad", "logs", () -> GFRegistry.POMEGRANATE_SAPLING);
        public static ImmutableMap<String, Variant> NETHER = ImmutableMap.builder().put((Object)CRIMSON.func_176610_l(), (Object)CRIMSON).put((Object)POMEGRANATE.func_176610_l(), (Object)POMEGRANATE).put((Object)WARPED.func_176610_l(), (Object)WARPED).build();

        protected Variant(String nameIn, Supplier<Block> saplingIn) {
            this("minecraft", nameIn, "lampad", "stems", saplingIn);
        }

        protected Variant(String modid, String nameIn, String entityIn, String tagSuffixIn, Supplier<Block> saplingIn) {
            super(modid, nameIn, entityIn, tagSuffixIn, saplingIn);
        }

        public static Variant getForBiome(Optional<RegistryKey<Biome>> biome) {
            return BiomeHelper.getLampadVariantForBiome(biome);
        }

        public static Variant getRandom(Random rand) {
            int len = NETHER.size();
            return len > 0 ? (Variant)((Map.Entry)NETHER.entrySet().asList().get(rand.nextInt(len))).getValue() : CRIMSON;
        }

        public static Variant getByName(String n) {
            if (n != null && !n.isEmpty()) {
                return (Variant)NETHER.getOrDefault((Object)n, (Object)CRIMSON);
            }
            return CRIMSON;
        }
    }
}

