/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.entity;

import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.OwnerHurtByTargetGoal;
import net.minecraft.entity.ai.goal.OwnerHurtTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.GhastEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class MakhaiEntity
extends TameableEntity {
    protected static final DataParameter<Byte> STATE = EntityDataManager.func_187226_a(MakhaiEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    protected static final String KEY_STATE = "MakhaiState";
    private static final byte NONE = 0;
    private static final byte SPAWNING = 1;
    private static final byte DESPAWNING = 2;
    private static final byte SPAWN_CLIENT = 9;
    private static final byte DESPAWN_CLIENT = 10;
    protected final int maxSpawnTime = 25;
    protected int spawnTime;
    protected int despawnTime;

    public MakhaiEntity(EntityType<? extends MakhaiEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public static AttributeModifierMap.MutableAttribute getAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 12.0).func_233815_a_(Attributes.field_233821_d_, 0.29).func_233815_a_(Attributes.field_233823_f_, 5.0).func_233815_a_(Attributes.field_233826_i_, 3.0);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new SpawningGoal());
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, true));
        this.field_70714_bg.func_75776_a(3, (Goal)new FollowOwnerGoal((TameableEntity)this, 1.0, 10.0f, 2.0f, false));
        this.field_70714_bg.func_75776_a(4, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.78));
        this.field_70714_bg.func_75776_a(5, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(0, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, 5, false, false, e -> !this.func_184191_r((Entity)e)));
        this.field_70715_bh.func_75776_a(1, (Goal)new OwnerHurtByTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(2, (Goal)new OwnerHurtTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, MobEntity.class, 5, false, false, e -> e instanceof IMob && EntityPredicates.field_188444_d.test(e) && !this.func_184191_r((Entity)e)));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(STATE, (Object)0);
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.isSpawning() && --this.spawnTime <= 0) {
            this.setSpawning(false);
        }
        if (this.isDespawning() && --this.despawnTime <= 0) {
            this.setDespawning(false);
            this.func_70106_y();
            return;
        }
        if (!(this.field_70170_p.func_201670_d() || this.func_175446_cd() || this.func_70638_az() != null && !this.func_70661_as().func_75500_f() || this.isDespawning() || this.field_70146_Z.nextInt(280) != 0)) {
            this.setDespawning(true);
        }
        if (this.field_70170_p.func_201670_d() && (this.isSpawning() || this.isDespawning())) {
            double x = this.func_226277_ct_();
            double y = this.func_226278_cu_() + 0.5;
            double z = this.func_226281_cx_();
            double motion = 0.06;
            double radius = (double)this.func_213311_cf() * 1.15;
            for (int i = 0; i < 4; ++i) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197594_E, x + (this.field_70170_p.field_73012_v.nextDouble() - 0.5) * radius, y + (this.field_70170_p.field_73012_v.nextDouble() - 0.5) * radius, z + (this.field_70170_p.field_73012_v.nextDouble() - 0.5) * radius, (this.field_70170_p.field_73012_v.nextDouble() - 0.5) * 0.06, (this.field_70170_p.field_73012_v.nextDouble() - 0.5) * 0.07, (this.field_70170_p.field_73012_v.nextDouble() - 0.5) * 0.06);
            }
        }
    }

    public void setEquipmentOnSpawn() {
        this.func_184611_a(Hand.MAIN_HAND, new ItemStack((IItemProvider)Items.field_151040_l));
        this.func_184611_a(Hand.OFF_HAND, new ItemStack((IItemProvider)Items.field_151010_B));
        this.func_184642_a(EquipmentSlotType.MAINHAND, 0.0f);
        this.func_184642_a(EquipmentSlotType.OFFHAND, 0.0f);
    }

    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        ILivingEntityData data = super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.setEquipmentOnSpawn();
        this.setSpawning(true);
        this.func_82227_f(false);
        return data;
    }

    public boolean func_70877_b(ItemStack item) {
        return false;
    }

    public byte getState() {
        return (Byte)this.func_184212_Q().func_187225_a(STATE);
    }

    public void setState(byte state) {
        this.func_184212_Q().func_187227_b(STATE, (Object)state);
    }

    public boolean isNoneState() {
        return this.getState() == 0;
    }

    public boolean isSpawning() {
        return this.spawnTime > 0 || this.getState() == 1;
    }

    public boolean isDespawning() {
        return this.despawnTime > 0 || this.getState() == 2;
    }

    public void setSpawning(boolean spawning) {
        this.spawnTime = spawning ? 25 : 0;
        this.setState(spawning ? (byte)1 : 0);
        if (spawning && !this.field_70170_p.func_201670_d()) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)9);
        }
    }

    public void setDespawning(boolean despawning) {
        this.despawnTime = despawning ? 25 : 0;
        this.setState(despawning ? (byte)2 : 0);
        if (despawning && !this.field_70170_p.func_201670_d()) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)10);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        switch (id) {
            case 9: {
                this.setSpawning(true);
                this.spawnTime = 25;
                break;
            }
            case 10: {
                this.setDespawning(true);
                this.despawnTime = 25;
                break;
            }
            default: {
                super.func_70103_a(id);
            }
        }
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_204774_aY;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundEvents.field_204778_bc;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_203258_fv;
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(SoundEvents.field_187939_hm, 0.15f, 1.0f);
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223223_b_;
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return !this.func_70909_n();
    }

    protected float func_213348_b(Pose pose, EntitySize size) {
        return this.isSpawning() ? 0.05f : 1.74f;
    }

    public double func_70033_W() {
        return -0.6;
    }

    public boolean func_184652_a(PlayerEntity player) {
        return false;
    }

    public boolean func_70878_b(AnimalEntity otherAnimal) {
        return false;
    }

    public AgeableEntity func_241840_a(ServerWorld world, AgeableEntity mate) {
        return null;
    }

    public void func_233687_w_(boolean sitting) {
    }

    public void func_70645_a(DamageSource cause) {
        this.func_184754_b(null);
        super.func_70645_a(cause);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74774_a(KEY_STATE, this.getState());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setState(compound.func_74771_c(KEY_STATE));
    }

    public boolean func_213336_c(LivingEntity entity) {
        if (this.func_152114_e(entity)) {
            return false;
        }
        return super.func_213336_c(entity);
    }

    public boolean func_142018_a(LivingEntity target, LivingEntity owner) {
        if (!(target instanceof CreeperEntity) && !(target instanceof GhastEntity)) {
            if (target instanceof TameableEntity) {
                TameableEntity tameable = (TameableEntity)target;
                return !tameable.func_70909_n() || tameable.func_70902_q() != owner;
            }
            if (target instanceof PlayerEntity && owner instanceof PlayerEntity && !((PlayerEntity)owner).func_96122_a((PlayerEntity)target)) {
                return false;
            }
            if (target instanceof AbstractHorseEntity && ((AbstractHorseEntity)target).func_110248_bS()) {
                return false;
            }
            return !(target instanceof TameableEntity) || !((TameableEntity)target).func_70909_n();
        }
        return false;
    }

    class SpawningGoal
    extends Goal {
        public SpawningGoal() {
            this.func_220684_a(EnumSet.allOf(Goal.Flag.class));
        }

        public boolean func_75250_a() {
            return MakhaiEntity.this.isSpawning() || MakhaiEntity.this.isDespawning();
        }

        public void func_75246_d() {
            MakhaiEntity.this.func_70661_as().func_75499_g();
        }
    }
}

