/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.entity;

import greekfantasy.GFRegistry;
import greekfantasy.GreekFantasy;
import java.util.EnumSet;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public class MinotaurEntity
extends MonsterEntity {
    protected static final DataParameter<Byte> STATE = EntityDataManager.func_187226_a(MinotaurEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    protected static final String KEY_STATE = "MinotaurState";
    protected static final byte NONE = 0;
    protected static final byte CHARGING = 1;
    protected static final byte STUNNED = 2;
    protected static final int STUN_DURATION = 80;
    protected final AttributeModifier knockbackModifier = new AttributeModifier("Charge knockback bonus", 2.25, AttributeModifier.Operation.MULTIPLY_TOTAL);
    protected final AttributeModifier attackModifier = new AttributeModifier("Charge attack bonus", 2.5, AttributeModifier.Operation.MULTIPLY_TOTAL);

    public MinotaurEntity(EntityType<? extends MinotaurEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public static AttributeModifierMap.MutableAttribute getAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 24.0).func_233815_a_(Attributes.field_233821_d_, 0.24).func_233815_a_(Attributes.field_233823_f_, 3.5).func_233815_a_(Attributes.field_233824_g_, 1.25).func_233815_a_(Attributes.field_233820_c_, 0.97).func_233815_a_(Attributes.field_233826_i_, 2.0);
    }

    public void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(STATE, (Object)0);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new StunnedGoal(this));
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(4, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, false));
        this.field_70714_bg.func_75776_a(5, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.8));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
        this.registerChargeGoal();
    }

    protected void registerChargeGoal() {
        if (((Boolean)GreekFantasy.CONFIG.MINOTAUR_ATTACK.get()).booleanValue()) {
            this.field_70714_bg.func_75776_a(2, (Goal)new ChargeAttackGoal(1.68));
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70170_p.func_201670_d() && this.isStunned()) {
            this.spawnStunnedParticles();
        }
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187558_ak;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187562_am;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187560_al;
    }

    protected float func_70599_aP() {
        return 0.8f;
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(SoundEvents.field_187566_ao, 0.15f, 1.0f);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_70613_aW()) {
            this.setCharging(false);
            this.setStunned(false);
        }
        return super.func_70097_a(source, amount);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74774_a(KEY_STATE, this.getMinotaurState());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setMinotaurState(compound.func_74771_c(KEY_STATE));
    }

    public byte getMinotaurState() {
        return (Byte)this.func_184212_Q().func_187225_a(STATE);
    }

    public void setMinotaurState(byte state) {
        this.func_184212_Q().func_187227_b(STATE, (Object)state);
    }

    public boolean isNoneState() {
        return this.getMinotaurState() == 0;
    }

    public boolean isCharging() {
        return this.getMinotaurState() == 1;
    }

    public boolean isStunned() {
        return this.getMinotaurState() == 2;
    }

    public void setCharging(boolean charging) {
        this.setMinotaurState(charging ? (byte)1 : 0);
    }

    public void setStunned(boolean stunned) {
        this.setMinotaurState(stunned ? (byte)2 : 0);
    }

    public float getStompingSpeed() {
        return 0.58f;
    }

    public void spawnStunnedParticles() {
        double motion = 0.09;
        double radius = 0.7;
        for (int i = 0; i < 2; ++i) {
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197590_A, this.func_226277_ct_() + (this.field_70170_p.field_73012_v.nextDouble() - 0.5) * 0.7, this.func_226280_cw_() + (this.field_70170_p.field_73012_v.nextDouble() - 0.5) * 0.7 * 0.75, this.func_226281_cx_() + (this.field_70170_p.field_73012_v.nextDouble() - 0.5) * 0.7, (this.field_70170_p.field_73012_v.nextDouble() - 0.5) * 0.09, (this.field_70170_p.field_73012_v.nextDouble() - 0.5) * 0.09 * 0.5, (this.field_70170_p.field_73012_v.nextDouble() - 0.5) * 0.09);
        }
    }

    public void applyChargeAttack(LivingEntity target) {
        this.func_110148_a(Attributes.field_233823_f_).func_233767_b_(this.attackModifier);
        this.func_110148_a(Attributes.field_233824_g_).func_233767_b_(this.knockbackModifier);
        this.func_70652_k((Entity)target);
        this.func_110148_a(Attributes.field_233823_f_).func_111124_b(this.attackModifier);
        this.func_110148_a(Attributes.field_233824_g_).func_111124_b(this.knockbackModifier);
        if (GreekFantasy.CONFIG.isStunningNerf()) {
            target.func_195064_c(new EffectInstance(Effects.field_76421_d, 80, 0));
            target.func_195064_c(new EffectInstance(Effects.field_76437_t, 80, 0));
        } else {
            target.func_195064_c(new EffectInstance(GFRegistry.STUNNED_EFFECT, 80, 0));
        }
    }

    class ChargeAttackGoal
    extends Goal {
        private final int maxCooldown = 200;
        private final int maxCharging = 40;
        private final double minRange = 2.5;
        private final double speed;
        private int chargingTimer;
        private int cooldown = 200;
        private Vector3d targetPos;

        protected ChargeAttackGoal(double speedIn) {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
            this.speed = speedIn;
            this.targetPos = null;
        }

        public boolean func_75250_a() {
            if (this.cooldown > 0) {
                --this.cooldown;
            } else if (MinotaurEntity.this.isNoneState() && MinotaurEntity.this.func_70638_az() != null && !MinotaurEntity.this.func_70605_aq().func_75640_a() && this.hasDirectPath(MinotaurEntity.this.func_70638_az()) && MinotaurEntity.this.func_70068_e((Entity)MinotaurEntity.this.func_70638_az()) > 6.25) {
                return true;
            }
            return false;
        }

        public boolean func_75253_b() {
            return MinotaurEntity.this.isCharging() && MinotaurEntity.this.func_70638_az() != null && MinotaurEntity.this.func_70638_az().func_70089_S() && this.hasDirectPath(MinotaurEntity.this.func_70638_az());
        }

        public void func_75249_e() {
            MinotaurEntity.this.setCharging(true);
            this.chargingTimer = 1;
        }

        public void func_75246_d() {
            boolean isCharging;
            LivingEntity target = MinotaurEntity.this.func_70638_az();
            double disSqToTargetEntity = MinotaurEntity.this.func_70068_e((Entity)target);
            boolean hitTarget = disSqToTargetEntity < 1.1;
            boolean hasTarget = this.targetPos != null;
            boolean finished = hitTarget || hasTarget && MinotaurEntity.this.func_195048_a(this.targetPos) < 0.9;
            boolean bl = isCharging = this.chargingTimer > 0 && this.chargingTimer++ < 40;
            if (finished) {
                if (hitTarget) {
                    MinotaurEntity.this.applyChargeAttack(target);
                } else {
                    MinotaurEntity.this.setStunned(true);
                }
                this.func_75251_c();
            } else if (isCharging) {
                MinotaurEntity.this.func_70661_as().func_75499_g();
                MinotaurEntity.this.func_70671_ap().func_220674_a(target.func_174824_e(1.0f));
            } else if (hasTarget) {
                MinotaurEntity.this.func_70605_aq().func_75642_a(this.targetPos.field_72450_a, this.targetPos.field_72448_b, this.targetPos.field_72449_c, this.speed);
                MinotaurEntity.this.func_70671_ap().func_220674_a(this.targetPos.func_72441_c(0.0, (double)target.func_70047_e(), 0.0));
            } else {
                this.targetPos = this.getExtendedTarget(target, disSqToTargetEntity + 16.0);
            }
        }

        public void func_75251_c() {
            if (MinotaurEntity.this.isCharging()) {
                MinotaurEntity.this.setCharging(false);
            }
            this.chargingTimer = 0;
            this.cooldown = 200;
            this.targetPos = null;
        }

        private Vector3d getExtendedTarget(LivingEntity targetEntity, double maxDistanceSq) {
            Vector3d target;
            Vector3d start = MinotaurEntity.this.func_213303_ch().func_72441_c(0.0, 0.1, 0.0);
            Vector3d end = target = targetEntity.func_213303_ch().func_72441_c(0.0, 0.1, 0.0);
            Vector3d vecDiff = end.func_178788_d(start);
            double length = vecDiff.func_72433_c();
            vecDiff = vecDiff.func_72432_b();
            do {
                target = end;
                end = start.func_178787_e(vecDiff.func_186678_a(length += 1.0));
            } while (length * length < maxDistanceSq && this.hasDirectPath(end));
            return target;
        }

        private boolean hasDirectPath(LivingEntity target) {
            return this.hasDirectPath(target.func_213303_ch().func_72441_c(0.0, 0.1, 0.0));
        }

        private boolean hasDirectPath(Vector3d target) {
            Vector3d start = MinotaurEntity.this.func_213303_ch().func_72441_c(0.0, 0.1, 0.0);
            return MinotaurEntity.this.field_70170_p.func_217299_a(new RayTraceContext(start, target, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)MinotaurEntity.this)).func_216346_c() == RayTraceResult.Type.MISS;
        }
    }

    static class StunnedGoal
    extends Goal {
        private final MinotaurEntity entity;
        private final int MAX_STUN_TIME = 50;
        private int stunTime;

        protected StunnedGoal(MinotaurEntity entityIn) {
            this.func_220684_a(EnumSet.allOf(Goal.Flag.class));
            this.entity = entityIn;
        }

        public boolean func_75250_a() {
            return this.entity.isStunned();
        }

        public void func_75249_e() {
            this.stunTime = 1;
        }

        public void func_75246_d() {
            if (this.stunTime > 0 && this.stunTime < 50) {
                ++this.stunTime;
                this.entity.func_70661_as().func_75499_g();
                this.entity.func_70671_ap().func_75651_a((Entity)this.entity, 0.0f, 0.0f);
            } else {
                this.func_75251_c();
            }
        }

        public void func_75251_c() {
            this.entity.setStunned(false);
            this.stunTime = 0;
        }
    }
}

