/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.entity;

import greekfantasy.GFRegistry;
import greekfantasy.entity.SirenEntity;
import greekfantasy.entity.ai.GoToWaterGoal;
import greekfantasy.entity.ai.SwimUpGoal;
import greekfantasy.entity.ai.SwimmingMovementController;
import greekfantasy.entity.misc.ISwimmingMob;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IAngerable;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.RangedAttackGoal;
import net.minecraft.entity.ai.goal.ResetAngerGoal;
import net.minecraft.entity.monster.DrownedEntity;
import net.minecraft.entity.passive.WaterMobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.TridentEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.SwimmerPathNavigator;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.RangedInteger;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.TickRangeConverter;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class NaiadEntity
extends WaterMobEntity
implements ISwimmingMob,
IAngerable,
IRangedAttackMob {
    private static final DataParameter<String> DATA_VARIANT = EntityDataManager.func_187226_a(NaiadEntity.class, (IDataSerializer)DataSerializers.field_187194_d);
    private static final String KEY_VARIANT = "Variant";
    private static final String KEY_AGE = "Age";
    private static final RangedInteger ANGER_RANGE = TickRangeConverter.func_233037_a_((int)10, (int)26);
    private int angerTime;
    private UUID angerTarget;
    protected int age;
    protected boolean swimmingUp;
    protected boolean isVisuallySwimming;
    protected float visuallySwimmingPercent;
    protected final SwimmerPathNavigator waterNavigator;
    protected final GroundPathNavigator groundNavigator;

    public NaiadEntity(EntityType<? extends NaiadEntity> type, World worldIn) {
        super(type, worldIn);
        this.waterNavigator = new SwimmerPathNavigator((MobEntity)this, worldIn);
        this.groundNavigator = new GroundPathNavigator((MobEntity)this, worldIn);
        this.field_70765_h = new SwimmingMovementController<NaiadEntity>(this);
        this.func_184644_a(PathNodeType.WATER, 0.0f);
    }

    public static AttributeModifierMap.MutableAttribute getAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 24.0).func_233815_a_(Attributes.field_233821_d_, 0.25).func_233815_a_(Attributes.field_233823_f_, 3.0);
    }

    public static boolean canNaiadSpawnOn(EntityType<? extends WaterMobEntity> entity, IWorld world, SpawnReason reason, BlockPos pos, Random rand) {
        return SirenEntity.canSirenSpawnOn(entity, world, reason, pos, rand);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(1, (Goal)new GoToWaterGoal((CreatureEntity)this, 1.0, 24){

            @Override
            public boolean func_75250_a() {
                return this.entity.func_70638_az() == null && this.entity.func_70681_au().nextInt(100) == 0 && super.func_75250_a();
            }
        });
        this.field_70714_bg.func_75776_a(2, (Goal)new TridentAttackGoal(this, 1.0, 36, 12.0f));
        this.field_70714_bg.func_75776_a(3, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, false));
        this.field_70714_bg.func_75776_a(4, new SwimUpGoal<NaiadEntity>(this, 1.0, this.field_70170_p.func_181545_F()));
        this.field_70714_bg.func_75776_a(4, (Goal)new RandomSwimmingGoal((CreatureEntity)this, 0.8, 140){

            public boolean func_75250_a() {
                return NaiadEntity.this.func_70090_H() && super.func_75250_a();
            }
        });
        this.field_70714_bg.func_75776_a(4, (Goal)new RandomWalkingGoal((CreatureEntity)this, 0.8, 180){

            public boolean func_75250_a() {
                return !NaiadEntity.this.func_70090_H() && super.func_75250_a();
            }
        });
        this.field_70714_bg.func_75776_a(5, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, DrownedEntity.class, false));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, 10, true, false, arg_0 -> ((NaiadEntity)this).func_233680_b_(arg_0)));
        this.field_70715_bh.func_75776_a(4, (Goal)new ResetAngerGoal((MobEntity)this, true));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(DATA_VARIANT, (Object)Variant.RIVER.func_176610_l());
    }

    public void func_70636_d() {
        super.func_70636_d();
        ++this.age;
        if (this.field_70170_p.func_201670_d()) {
            if (this.field_70173_aa % 11 == 1) {
                BlockState blockBelow = this.field_70170_p.func_180495_p(this.func_226270_aj_());
                this.isVisuallySwimming = this.func_213322_ci().func_82617_b() > -0.01 && (this.swimmingUp || this.func_203007_ba() || this.func_70090_H()) && blockBelow.func_204520_s().func_206886_c().func_207185_a((ITag)FluidTags.field_206959_a);
            }
            this.visuallySwimmingPercent = this.isVisuallySwimming ? Math.min(this.visuallySwimmingPercent + 0.09f, 1.0f) : Math.max(this.visuallySwimmingPercent - 0.09f, 0.0f);
        }
    }

    public boolean func_180431_b(DamageSource source) {
        if (source.func_76346_g() != null && source.func_76346_g().func_200600_R() == GFRegistry.NAIAD_ENTITY) {
            return true;
        }
        return super.func_180431_b(source);
    }

    protected void func_70665_d(DamageSource source, float amountIn) {
        float amount = amountIn;
        if (!source.func_151517_h() && source.func_76346_g() instanceof MobEntity && ((MobEntity)source.func_76346_g()).func_70668_bt() == CreatureAttribute.field_223223_b_) {
            amount *= 0.6f;
        }
        super.func_70665_d(source, amount);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74778_a(KEY_VARIANT, (String)this.func_184212_Q().func_187225_a(DATA_VARIANT));
        compound.func_74768_a(KEY_AGE, this.age);
        this.func_233682_c_(compound);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setVariant(Variant.getByName(compound.func_74779_i(KEY_VARIANT)));
        this.age = compound.func_74762_e(KEY_AGE);
        this.func_241358_a_((ServerWorld)this.field_70170_p, compound);
    }

    public ResourceLocation func_184647_J() {
        return this.getVariant().getLootTable();
    }

    public void func_230258_H__() {
        this.func_230260_a__(ANGER_RANGE.func_233018_a_(this.field_70146_Z));
    }

    public void func_230260_a__(int time) {
        this.angerTime = time;
    }

    public int func_230256_F__() {
        return this.angerTime;
    }

    public void func_230259_a_(@Nullable UUID target) {
        this.angerTarget = target;
    }

    public UUID func_230257_G__() {
        return this.angerTarget;
    }

    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        float tridentChance;
        Variant variant = reason == SpawnReason.COMMAND || reason == SpawnReason.SPAWN_EGG || reason == SpawnReason.SPAWNER || reason == SpawnReason.DISPENSER ? Variant.getRandom(worldIn.func_201674_k()) : Variant.getForBiome(worldIn.func_242406_i(this.func_233580_cy_()));
        this.setVariant(variant);
        float f = tridentChance = variant == Variant.OCEAN ? 0.25f : 0.14f;
        if (this.field_70146_Z.nextFloat() < tridentChance) {
            ItemStack trident = new ItemStack((IItemProvider)Items.field_203184_eO);
            this.func_184611_a(Hand.MAIN_HAND, trident);
        }
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public boolean func_213397_c(double disToPlayer) {
        return this.age > 8400 && disToPlayer > 8.0;
    }

    public void func_82196_d(LivingEntity target, float distanceFactor) {
        TridentEntity trident = new TridentEntity(this.field_70170_p, (LivingEntity)this, new ItemStack((IItemProvider)Items.field_203184_eO));
        double dx = target.func_226277_ct_() - this.func_226277_ct_();
        double dy = target.func_226283_e_(0.33) - trident.func_226278_cu_();
        double dz = target.func_226281_cx_() - this.func_226281_cx_();
        double dis = MathHelper.func_76133_a((double)(dx * dx + dz * dz));
        trident.func_70186_c(dx, dy + dis * 0.2, dz, 1.6f, (float)(14 - this.field_70170_p.func_175659_aa().func_151525_a() * 4));
        this.func_184185_a(SoundEvents.field_204780_be, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_217376_c((Entity)trident);
    }

    protected void func_209207_l(int air) {
    }

    @Override
    public void setSwimmingUp(boolean swimmingUp) {
        this.swimmingUp = swimmingUp;
    }

    @Override
    public boolean isSwimmingUp() {
        return this.swimmingUp;
    }

    public void func_213352_e(Vector3d vec) {
        if (this.func_70613_aW() && this.func_70090_H() && this.isSwimmingUpCalculated()) {
            this.func_213309_a(0.01f, vec);
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.9));
        } else {
            super.func_213352_e(vec);
        }
    }

    public boolean func_96092_aw() {
        return false;
    }

    @Override
    public boolean isSwimmingUpCalculated() {
        if (this.swimmingUp) {
            return true;
        }
        LivingEntity e = this.func_70638_az();
        return e != null && e.func_70090_H();
    }

    public void func_205343_av() {
        if (!this.field_70170_p.field_72995_K) {
            if (this.func_70613_aW() && this.func_70090_H() && this.isSwimmingUp()) {
                this.field_70699_by = this.waterNavigator;
                this.func_204711_a(true);
            } else {
                this.field_70699_by = this.groundNavigator;
                this.func_204711_a(false);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public float animateSwimmingPercent() {
        return this.visuallySwimmingPercent;
    }

    public void setVariant(Variant variant) {
        this.func_184212_Q().func_187227_b(DATA_VARIANT, (Object)variant.func_176610_l());
    }

    public Variant getVariant() {
        return Variant.getByName((String)this.func_184212_Q().func_187225_a(DATA_VARIANT));
    }

    class TridentAttackGoal
    extends RangedAttackGoal {
        public TridentAttackGoal(NaiadEntity entityIn, double moveSpeed, int attackInterval, float attackDistance) {
            super((IRangedAttackMob)entityIn, moveSpeed, attackInterval, attackDistance);
        }

        public boolean func_75250_a() {
            return super.func_75250_a() && NaiadEntity.this.func_184614_ca().func_77973_b() == Items.field_203184_eO;
        }

        public void func_75249_e() {
            super.func_75249_e();
            NaiadEntity.this.func_213395_q(true);
            NaiadEntity.this.func_184598_c(Hand.MAIN_HAND);
        }

        public void func_75251_c() {
            super.func_75251_c();
            NaiadEntity.this.func_184602_cy();
            NaiadEntity.this.func_213395_q(false);
        }
    }

    public static enum Variant implements IStringSerializable
    {
        OCEAN("ocean"),
        RIVER("river");

        private final String name;
        private final ResourceLocation texture;
        private final ResourceLocation lootTable;

        private Variant(String nameIn) {
            this.name = nameIn;
            this.texture = new ResourceLocation("greekfantasy", "textures/entity/naiad/" + this.name + ".png");
            this.lootTable = new ResourceLocation("greekfantasy", "entities/naiad/" + this.name);
        }

        public static Variant getByName(String n) {
            if (n != null && !n.isEmpty()) {
                for (Variant t : Variant.values()) {
                    if (!t.func_176610_l().equals(n)) continue;
                    return t;
                }
            }
            return RIVER;
        }

        public static Variant getForBiome(Optional<RegistryKey<Biome>> biome) {
            return biome.isPresent() && Objects.equals(biome, Optional.of(Biomes.field_76781_i)) ? RIVER : OCEAN;
        }

        public static Variant getRandom(Random rand) {
            int len = Variant.values().length;
            return Variant.values()[rand.nextInt(len)];
        }

        public ResourceLocation getTexture() {
            return this.texture;
        }

        public ResourceLocation getLootTable() {
            return this.lootTable;
        }

        public byte getId() {
            return (byte)this.ordinal();
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

