/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.entity;

import greekfantasy.GreekFantasy;
import java.util.EnumSet;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.Hand;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.BossInfo;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerBossInfo;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class NemeanLionEntity
extends MonsterEntity {
    private static final DataParameter<Byte> STATE = EntityDataManager.func_187226_a(NemeanLionEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final String KEY_STATE = "NemeanState";
    private static final byte NONE = 0;
    private static final byte SPAWNING = 1;
    private static final byte ROARING = 2;
    private static final byte ATTACKING = 3;
    private static final byte SITTING = 4;
    private static final byte SITTING_START_CLIENT = 8;
    private static final byte SITTING_END_CLIENT = 9;
    private final ServerBossInfo bossInfo = new ServerBossInfo(this.func_145748_c_(), BossInfo.Color.YELLOW, BossInfo.Overlay.PROGRESS);

    public NemeanLionEntity(EntityType<? extends NemeanLionEntity> type, World worldIn) {
        super(type, worldIn);
        this.func_110163_bv();
        this.field_70138_W = 1.0f;
        this.field_70728_aV = 50;
        this.bossInfo.func_186758_d(GreekFantasy.CONFIG.showNemeanLionBossBar());
    }

    public static AttributeModifierMap.MutableAttribute getAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 100.0).func_233815_a_(Attributes.field_233821_d_, 0.28).func_233815_a_(Attributes.field_233820_c_, 0.92).func_233815_a_(Attributes.field_233819_b_, 24.0).func_233815_a_(Attributes.field_233823_f_, 9.0).func_233815_a_(Attributes.field_233826_i_, 5.0).func_233815_a_(Attributes.field_233827_j_, 2.0);
    }

    public void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(STATE, (Object)0);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new RunAroundLikeCrazyGoal(1.0));
        this.field_70714_bg.func_75776_a(2, (Goal)new SitGoal());
        this.field_70714_bg.func_75776_a(3, (Goal)new LeapAtTargetGoal((MobEntity)this, 0.54f));
        this.field_70714_bg.func_75776_a(4, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.15, true));
        this.field_70714_bg.func_75776_a(5, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.86){

            public boolean func_75250_a() {
                return !NemeanLionEntity.this.isSitting() && NemeanLionEntity.this.field_70146_Z.nextInt(400) == 0 && super.func_75250_a();
            }
        });
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, 10, false, false, e -> EntityPredicates.field_233583_f_.test(e) && !this.func_184207_aI()));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, AnimalEntity.class, 10, false, false, e -> EntityPredicates.field_233583_f_.test(e) && e.func_184222_aU() && !e.func_70090_H() && !this.func_184207_aI()));
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
        if (!this.field_70170_p.func_201670_d()) {
            if (this.func_70638_az() == null && this.func_184188_bt().isEmpty()) {
                if (this.field_70146_Z.nextFloat() < 0.0022f) {
                    this.setSitting(!this.isSitting());
                }
            } else if (this.isSitting()) {
                this.setSitting(false);
            }
        }
        if (this.func_184207_aI() && this.func_184188_bt().get(0) instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)this.func_184188_bt().get(0);
            this.field_70126_B = this.field_70177_z = player.field_70177_z;
            this.field_70125_A = player.field_70125_A * 0.5f;
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
            this.field_70759_as = this.field_70761_aq = this.field_70177_z;
            if (this.field_70737_aN == 0 && !this.field_70170_p.func_201670_d()) {
                this.func_70097_a(DamageSource.func_76365_a((PlayerEntity)player), 1.0f + this.field_70146_Z.nextFloat());
                if (this.func_70660_b(Effects.field_76428_l) != null) {
                    this.func_195063_d(Effects.field_76428_l);
                }
            }
        }
    }

    protected void func_70665_d(DamageSource source, float amountIn) {
        float damageAmount = amountIn;
        if (!(source.func_151517_h() || source.func_82725_o() || source.func_76363_c())) {
            damageAmount = Math.min(2.0f, amountIn);
        }
        if (!this.field_70170_p.func_201670_d() && this.isSitting()) {
            this.setSitting(false);
        }
        super.func_70665_d(source, damageAmount);
    }

    public boolean func_180431_b(DamageSource source) {
        return source == DamageSource.field_76368_d || source == DamageSource.field_82727_n || source == DamageSource.field_76367_g || source == DamageSource.field_220302_v || source.func_76352_a() || super.func_180431_b(source);
    }

    protected void func_82167_n(Entity entityIn) {
        if (entityIn instanceof LivingEntity && !this.field_70170_p.func_201670_d() && this.isSitting()) {
            this.setSitting(false);
        }
        super.func_82167_n(entityIn);
    }

    public boolean func_70617_f_() {
        return false;
    }

    public double func_70042_X() {
        return super.func_70042_X() + 0.805;
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        if (!this.func_184207_aI() && !player.func_226563_dT_()) {
            if (!this.field_70170_p.func_201670_d() && this.func_184219_q((Entity)player)) {
                player.func_184220_m((Entity)this);
                if (this.isSitting()) {
                    this.setSitting(false);
                }
            }
            return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
        }
        return ActionResultType.FAIL;
    }

    public void func_184226_ay() {
        if (this.func_184188_bt().size() > 0) {
            this.func_195064_c(new EffectInstance(Effects.field_76428_l, 84, 0));
        }
        super.func_184226_ay();
    }

    public boolean func_184222_aU() {
        return false;
    }

    protected boolean func_184228_n(Entity entityIn) {
        return false;
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return false;
    }

    public void func_184178_b(ServerPlayerEntity player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(ServerPlayerEntity player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    public byte getNemeanState() {
        return (Byte)this.func_184212_Q().func_187225_a(STATE);
    }

    public void setNemeanState(byte state) {
        this.func_184212_Q().func_187227_b(STATE, (Object)state);
    }

    public boolean isNoneState() {
        return this.getNemeanState() == 0;
    }

    public boolean isSitting() {
        return this.getNemeanState() == 4;
    }

    public void setSitting(boolean sitting) {
        this.setNemeanState(sitting ? (byte)4 : 0);
        if (!this.field_70170_p.func_201670_d()) {
            this.field_70170_p.func_72960_a((Entity)this, sitting ? (byte)8 : 9);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        switch (id) {
            case 8: {
                this.setSitting(true);
                break;
            }
            case 9: {
                this.setSitting(false);
                break;
            }
            default: {
                super.func_70103_a(id);
            }
        }
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74774_a(KEY_STATE, this.getNemeanState());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setNemeanState(compound.func_74771_c(KEY_STATE));
    }

    private class RunAroundLikeCrazyGoal
    extends Goal {
        private final NemeanLionEntity lion;
        private final double speed;
        private double targetX;
        private double targetY;
        private double targetZ;

        public RunAroundLikeCrazyGoal(double speedIn) {
            this.lion = NemeanLionEntity.this;
            this.speed = speedIn;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            if (this.lion.func_184207_aI()) {
                Vector3d vector3d = RandomPositionGenerator.func_75463_a((CreatureEntity)this.lion, (int)5, (int)4);
                if (vector3d == null) {
                    return false;
                }
                this.targetX = vector3d.field_72450_a;
                this.targetY = vector3d.field_72448_b;
                this.targetZ = vector3d.field_72449_c;
                return true;
            }
            return false;
        }

        public void func_75249_e() {
            this.lion.func_70661_as().func_75492_a(this.targetX, this.targetY, this.targetZ, this.speed);
        }

        public boolean func_75253_b() {
            return !this.lion.func_70661_as().func_75500_f() && this.lion.func_184207_aI();
        }

        public void func_75246_d() {
            if (this.lion.func_70681_au().nextInt(42) == 0) {
                Entity e = (Entity)this.lion.func_184188_bt().get(0);
                this.lion.func_184226_ay();
                if (e instanceof LivingEntity) {
                    LivingEntity passenger = (LivingEntity)e;
                    passenger.func_233627_a_(2.5f + NemeanLionEntity.this.field_70146_Z.nextFloat() * 2.0f, NemeanLionEntity.this.field_70146_Z.nextDouble() * 2.0 - 1.0, NemeanLionEntity.this.field_70146_Z.nextDouble() * 2.0 - 1.0);
                    passenger.field_70133_I = true;
                    this.lion.func_70652_k((Entity)passenger);
                }
            }
        }
    }

    private class SitGoal
    extends Goal {
        public SitGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.TARGET));
        }

        public boolean func_75250_a() {
            return NemeanLionEntity.this.isSitting();
        }

        public void func_75246_d() {
            NemeanLionEntity.this.func_70661_as().func_75499_g();
        }
    }
}

