/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.entity;

import greekfantasy.GFRegistry;
import greekfantasy.GreekFantasy;
import greekfantasy.entity.ai.ShootFireGoal;
import greekfantasy.entity.misc.IHasOwner;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IAngerable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.NonTamedTargetGoal;
import net.minecraft.entity.ai.goal.OwnerHurtByTargetGoal;
import net.minecraft.entity.ai.goal.OwnerHurtTargetGoal;
import net.minecraft.entity.ai.goal.ResetAngerGoal;
import net.minecraft.entity.ai.goal.SitGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.AbstractSkeletonEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.GhastEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.loot.LootTables;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.RangedInteger;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.TickRangeConverter;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.ForgeEventFactory;

public class OrthusEntity
extends TameableEntity
implements IMob,
IAngerable {
    protected static final Tags.IOptionalNamedTag<Item> FOOD = ItemTags.createOptional((ResourceLocation)new ResourceLocation("greekfantasy", "orthus_food"));
    protected static final DataParameter<Boolean> FIRE = EntityDataManager.func_187226_a(OrthusEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Optional<UUID>> OWNER = EntityDataManager.func_187226_a(OrthusEntity.class, (IDataSerializer)DataSerializers.field_187203_m);
    protected static final String KEY_FIRE = "Firing";
    protected static final String KEY_LIFE_TICKS = "LifeTicks";
    public static final Predicate<LivingEntity> TARGET_ENTITIES = e -> e.func_200600_R() == EntityType.field_233589_aE_;
    protected static final double FIRE_RANGE = 4.5;
    protected static final int MAX_FIRE_TIME = 52;
    protected static final int FIRE_COOLDOWN = 165;
    protected static final RangedInteger ANGER_RANGE = TickRangeConverter.func_233037_a_((int)20, (int)39);
    protected int angerTime;
    protected UUID angerTarget;
    protected boolean limitedLifespan;
    protected int limitedLifeTicks;

    public OrthusEntity(EntityType<? extends OrthusEntity> type, World worldIn) {
        super(type, worldIn);
        this.func_70903_f(false);
    }

    public static AttributeModifierMap.MutableAttribute getAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 24.0).func_233815_a_(Attributes.field_233821_d_, 0.29).func_233815_a_(Attributes.field_233823_f_, 4.5);
    }

    public void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(FIRE, (Object)false);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new SitGoal((TameableEntity)this));
        this.field_70714_bg.func_75776_a(3, (Goal)new BegGoal((CreatureEntity)this, 8.0));
        this.field_70714_bg.func_75776_a(4, (Goal)new LeapAtTargetGoal((MobEntity)this, 0.4f));
        this.field_70714_bg.func_75776_a(5, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, true));
        this.field_70714_bg.func_75776_a(6, (Goal)new FollowOwnerGoal((TameableEntity)this, 1.0, 10.0f, 4.0f, false));
        this.field_70714_bg.func_75776_a(7, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.8));
        this.field_70714_bg.func_75776_a(8, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new OwnerHurtByTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(2, (Goal)new OwnerHurtTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(3, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]).func_220794_a(new Class[0]));
        this.field_70715_bh.func_75776_a(4, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, 10, true, false, e -> this.func_233680_b_((LivingEntity)e) || this.canAttackPlayer((LivingEntity)e)));
        this.field_70715_bh.func_75776_a(5, (Goal)new NonTamedTargetGoal((TameableEntity)this, AnimalEntity.class, false, TARGET_ENTITIES));
        this.field_70715_bh.func_75776_a(6, (Goal)new NearestAttackableTargetGoal((MobEntity)this, AbstractSkeletonEntity.class, false));
        this.field_70715_bh.func_75776_a(7, (Goal)new ResetAngerGoal((MobEntity)this, true));
        if (((Boolean)GreekFantasy.CONFIG.ORTHUS_ATTACK.get()).booleanValue()) {
            this.field_70714_bg.func_75776_a(2, (Goal)new FireAttackGoal(52, 165, 4.5));
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70173_aa % 5 == 0 && this.func_70638_az() instanceof PlayerEntity && !this.canAttackPlayer(this.func_70638_az())) {
            this.setFireAttack(false);
            this.func_70624_b(null);
            this.func_70604_c(null);
            this.func_241355_J__();
        }
        if (this.limitedLifespan && --this.limitedLifeTicks <= 0) {
            this.limitedLifeTicks = 40;
            this.func_70097_a(DamageSource.field_76366_f, 1.0f);
        }
        if (this.func_70613_aW() && this.isFireAttack() && this.func_70638_az() == null) {
            this.setFireAttack(false);
        }
        if (this.field_70170_p.func_201670_d() && this.isFireAttack()) {
            this.spawnFireParticles();
        }
    }

    public boolean canAttackPlayer(LivingEntity e) {
        return e != null && !this.func_152114_e(e) && !e.func_184614_ca().func_77973_b().func_206844_a(FOOD) && !e.func_184592_cb().func_77973_b().func_206844_a(FOOD);
    }

    public boolean func_70687_e(EffectInstance potioneffectIn) {
        return potioneffectIn.func_188419_a() != Effects.field_82731_v && super.func_70687_e(potioneffectIn);
    }

    public boolean func_142018_a(LivingEntity target, LivingEntity owner) {
        if (!(target instanceof CreeperEntity) && !(target instanceof GhastEntity)) {
            if (target instanceof TameableEntity) {
                TameableEntity tameable = (TameableEntity)target;
                return !tameable.func_70909_n() || tameable.func_70902_q() != owner;
            }
            if (target instanceof IHasOwner) {
                IHasOwner tameable = (IHasOwner)target;
                return !tameable.hasOwner() || tameable.getOwner() != owner;
            }
            if (target instanceof PlayerEntity && owner instanceof PlayerEntity && !((PlayerEntity)owner).func_96122_a((PlayerEntity)target)) {
                return false;
            }
            if (target instanceof AbstractHorseEntity && ((AbstractHorseEntity)target).func_110248_bS()) {
                return false;
            }
            return !(target instanceof TameableEntity) || !((TameableEntity)target).func_70909_n();
        }
        return false;
    }

    public boolean func_184652_a(PlayerEntity player) {
        return !this.func_233678_J__() && super.func_184652_a(player);
    }

    public void func_230258_H__() {
        this.func_230260_a__(ANGER_RANGE.func_233018_a_(this.field_70146_Z));
    }

    public void func_230260_a__(int time) {
        this.angerTime = time;
    }

    public int func_230256_F__() {
        return this.angerTime;
    }

    public void func_230259_a_(@Nullable UUID target) {
        this.angerTarget = target;
    }

    public UUID func_230257_G__() {
        return this.angerTarget;
    }

    public void setLimitedLife(int life) {
        this.limitedLifespan = true;
        this.limitedLifeTicks = life;
    }

    protected SoundEvent func_184639_G() {
        if (this.field_70146_Z.nextInt(3) == 0) {
            return SoundEvents.field_187857_gE;
        }
        if (this.field_70146_Z.nextInt(3) == 0) {
            return SoundEvents.field_187865_gI;
        }
        return SoundEvents.field_187861_gG;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187863_gH;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187859_gF;
    }

    protected float func_70599_aP() {
        return 0.8f;
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(SoundEvents.field_187869_gK, 0.15f, 1.0f);
    }

    public ResourceLocation func_184647_J() {
        return this.limitedLifespan ? LootTables.field_186419_a : super.func_184647_J();
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a(KEY_FIRE, this.isFireAttack());
        if (this.limitedLifespan) {
            compound.func_74768_a(KEY_LIFE_TICKS, this.limitedLifeTicks);
        }
        this.func_233682_c_(compound);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setFireAttack(compound.func_74767_n(KEY_FIRE));
        if (compound.func_74764_b(KEY_LIFE_TICKS)) {
            this.setLimitedLife(compound.func_74762_e(KEY_LIFE_TICKS));
        }
        this.func_241358_a_((ServerWorld)this.field_70170_p, compound);
    }

    public void spawnFireParticles() {
        if (!this.field_70170_p.func_201670_d()) {
            return;
        }
        Vector3d lookVec = this.func_70040_Z();
        Vector3d pos = this.func_174824_e(1.0f);
        double motion = 0.06;
        double radius = 0.75;
        for (int i = 0; i < 5; ++i) {
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197631_x, pos.field_72450_a + (this.field_70170_p.field_73012_v.nextDouble() - 0.5) * 0.75, pos.field_72448_b + (this.field_70170_p.field_73012_v.nextDouble() - 0.5) * 0.75, pos.field_72449_c + (this.field_70170_p.field_73012_v.nextDouble() - 0.5) * 0.75, lookVec.field_72450_a * 0.06 * 4.5, lookVec.field_72448_b * 0.06 * 0.5, lookVec.field_72449_c * 0.06 * 4.5);
        }
    }

    public AgeableEntity func_241840_a(ServerWorld world, AgeableEntity parent) {
        OrthusEntity baby = (OrthusEntity)GFRegistry.ORTHUS_ENTITY.func_200721_a((World)world);
        UUID uuid = this.func_184753_b();
        if (uuid != null) {
            baby.func_184754_b(uuid);
            baby.func_70903_f(true);
        }
        return baby;
    }

    public void func_70903_f(boolean tamed) {
        super.func_70903_f(tamed);
        if (tamed) {
            this.func_110148_a(Attributes.field_233818_a_).func_111128_a(36.0);
            this.func_70606_j(36.0f);
        } else {
            this.func_110148_a(Attributes.field_233818_a_).func_111128_a(24.0);
        }
    }

    public boolean func_70877_b(ItemStack stack) {
        return stack.func_77973_b().func_206844_a(FOOD);
    }

    public boolean func_70878_b(AnimalEntity otherAnimal) {
        if (otherAnimal == this) {
            return false;
        }
        if (!this.func_70909_n()) {
            return false;
        }
        if (!(otherAnimal instanceof OrthusEntity)) {
            return false;
        }
        OrthusEntity orthus = (OrthusEntity)otherAnimal;
        if (!orthus.func_70909_n()) {
            return false;
        }
        if (orthus.func_233684_eK_()) {
            return false;
        }
        return this.func_70880_s() && orthus.func_70880_s();
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        Item item = itemstack.func_77973_b();
        if (this.field_70170_p.func_201670_d()) {
            boolean flag = this.func_152114_e((LivingEntity)player) || this.func_70909_n() || item.func_206844_a(FOOD) && !this.func_70909_n();
            return flag ? ActionResultType.CONSUME : ActionResultType.PASS;
        }
        if (this.func_70909_n()) {
            if ((this.func_70877_b(itemstack) || item == Items.field_151103_aS) && this.func_110143_aJ() < this.func_110138_aP()) {
                if (!player.field_71075_bZ.field_75098_d) {
                    itemstack.func_190918_g(1);
                }
                this.func_70691_i(item.func_219967_s().func_221466_a());
                return ActionResultType.SUCCESS;
            }
            ActionResultType actionresulttype = super.func_230254_b_(player, hand);
            if ((!actionresulttype.func_226246_a_() || this.func_70631_g_()) && this.func_152114_e((LivingEntity)player)) {
                this.func_233687_w_(!this.func_233685_eM_());
                this.field_70703_bu = false;
                this.field_70699_by.func_75499_g();
                this.setFireAttack(false);
                this.func_70624_b(null);
                this.func_70604_c(null);
                this.func_241355_J__();
                return ActionResultType.SUCCESS;
            }
            return actionresulttype;
        }
        if (item.func_206844_a(FOOD)) {
            if (this.func_233678_J__()) {
                this.func_230259_a_(null);
            }
            if (!player.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
            }
            if (this.field_70146_Z.nextInt(4) == 0 && !ForgeEventFactory.onAnimalTame((AnimalEntity)this, (PlayerEntity)player)) {
                this.func_193101_c(player);
                this.setFireAttack(false);
                this.func_70624_b(null);
                this.func_70604_c(null);
                this.func_241355_J__();
                this.field_70699_by.func_75499_g();
                this.func_70624_b(null);
                this.func_233687_w_(true);
                this.field_70170_p.func_72960_a((Entity)this, (byte)7);
            } else {
                this.field_70170_p.func_72960_a((Entity)this, (byte)6);
            }
            return ActionResultType.SUCCESS;
        }
        return super.func_230254_b_(player, hand);
    }

    public void setFireAttack(boolean shooting) {
        this.field_70180_af.func_187227_b(FIRE, (Object)shooting);
    }

    public boolean isFireAttack() {
        return (Boolean)this.func_184212_Q().func_187225_a(FIRE);
    }

    class FireAttackGoal
    extends ShootFireGoal {
        protected FireAttackGoal(int fireTimeIn, int maxCooldownIn, double fireRange) {
            super((MobEntity)OrthusEntity.this, fireTimeIn, maxCooldownIn, fireRange);
        }

        @Override
        public boolean func_75250_a() {
            return super.func_75250_a() && !OrthusEntity.this.isFireAttack() && !OrthusEntity.this.func_233685_eM_() && !OrthusEntity.this.func_233684_eK_();
        }

        @Override
        public boolean func_75253_b() {
            return super.func_75253_b() && OrthusEntity.this.isFireAttack();
        }

        @Override
        public void func_75249_e() {
            super.func_75249_e();
            OrthusEntity.this.setFireAttack(true);
        }

        @Override
        public void func_75246_d() {
            super.func_75246_d();
            OrthusEntity.this.func_70637_d(false);
        }

        @Override
        public void func_75251_c() {
            super.func_75251_c();
            OrthusEntity.this.setFireAttack(false);
        }
    }

    static class BegGoal
    extends Goal {
        protected static final Predicate<LivingEntity> CAUSE_BEG = e -> e.func_184614_ca().func_77973_b().func_206844_a(FOOD) || e.func_184592_cb().func_77973_b().func_206844_a(FOOD);
        protected final CreatureEntity creature;
        protected final double range;
        protected final int interval;
        @Nullable
        protected LivingEntity player;

        protected BegGoal(CreatureEntity entity, double rangeIn) {
            this(entity, rangeIn, 10);
        }

        protected BegGoal(CreatureEntity entity, double rangeIn, int intervalIn) {
            this.creature = entity;
            this.range = rangeIn;
            this.interval = intervalIn;
        }

        public boolean func_75250_a() {
            if (this.creature.field_70173_aa % this.interval == 0) {
                List list = this.creature.func_130014_f_().func_217357_a(PlayerEntity.class, this.creature.func_174813_aQ().func_186662_g(this.range));
                this.player = !list.isEmpty() ? (LivingEntity)list.get(0) : null;
            }
            return this.player != null;
        }

        public boolean func_75253_b() {
            return this.func_75250_a();
        }

        public void func_75246_d() {
            this.creature.func_70671_ap().func_75651_a((Entity)this.player, (float)this.creature.func_184649_cE(), (float)this.creature.func_70646_bf());
            this.creature.func_70661_as().func_75499_g();
        }
    }
}

