/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.entity;

import greekfantasy.GFRegistry;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.SoundType;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.IFlyingAnimal;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.passive.horse.CoatColors;
import net.minecraft.entity.passive.horse.CoatTypes;
import net.minecraft.entity.passive.horse.HorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeMod;

public class PegasusEntity
extends AbstractHorseEntity
implements IFlyingAnimal {
    private static final DataParameter<Integer> DATA_COLOR = EntityDataManager.func_187226_a(PegasusEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final String KEY_COLOR = "Color";
    private static final int FLYING_INTERVAL = 8;
    protected int flyingTime;
    protected int navigatorTimer;
    protected boolean isFlying;

    public PegasusEntity(EntityType<? extends PegasusEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public static AttributeModifierMap.MutableAttribute getAttributes() {
        return AbstractHorseEntity.func_234237_fg_().func_233815_a_(Attributes.field_233826_i_, 1.0).func_233815_a_((Attribute)ForgeMod.ENTITY_GRAVITY.get(), 0.04).func_233815_a_(Attributes.field_233822_e_, (double)1.32f);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(DATA_COLOR, (Object)0);
    }

    public void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(4, (Goal)new AvoidPlayersGoal(this));
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.flyingTime > 0) {
            --this.flyingTime;
        }
        if (!this.func_184207_aI()) {
            this.isFlying = false;
        }
        this.field_70122_E = true;
        if (this.func_184207_aI() && this.func_213322_ci().field_72448_b < -0.1) {
            this.func_213317_d(this.func_213322_ci().func_216372_d(1.0, 0.95, 1.0));
        }
        if (this.func_213303_ch().field_72448_b > 300.0) {
            this.func_70097_a(DamageSource.field_76380_i, 2.0f);
        }
    }

    protected void func_230273_eI_() {
        this.func_110148_a(Attributes.field_233818_a_).func_111128_a((double)this.func_110267_cL());
        this.func_110148_a(Attributes.field_233821_d_).func_111128_a(this.func_110203_cN());
        this.func_110148_a(Attributes.field_233830_m_).func_111128_a(this.func_110245_cM());
        this.func_110148_a(Attributes.field_233822_e_).func_111128_a(this.func_233637_b_(Attributes.field_233821_d_) + 1.15);
    }

    protected float func_110267_cL() {
        return super.func_110267_cL() + 10.0f;
    }

    protected double func_110245_cM() {
        return super.func_110245_cM() + (double)0.2f;
    }

    protected double func_110203_cN() {
        return super.func_110203_cN();
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        CoatColors color;
        if (spawnDataIn instanceof HorseEntity.HorseData) {
            color = ((HorseEntity.HorseData)spawnDataIn).field_190885_a;
        } else {
            color = (CoatColors)Util.func_240989_a_((Object[])CoatColors.values(), (Random)this.field_70146_Z);
            spawnDataIn = new HorseEntity.HorseData(color);
        }
        this.setCoatColor(color, (CoatTypes)Util.func_240989_a_((Object[])CoatTypes.values(), (Random)this.field_70146_Z));
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public boolean func_184776_b() {
        return super.func_184776_b() && this.flyingTime <= 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_110206_u(int jumpPowerIn) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void flyingJump() {
        if (this.flyingTime <= 0 && this.func_184776_b()) {
            float jumpMotion = (float)this.func_110215_cj() + 0.82f;
            this.func_70024_g(0.0, jumpMotion, 0.0);
            this.func_70018_K();
            this.field_70122_E = true;
            this.flyingTime = 8;
            this.isFlying = true;
        }
    }

    public void func_184775_b(int jumpPower) {
        if (!this.field_70122_E) {
            this.func_110219_q(false);
        }
    }

    public boolean func_110246_bZ() {
        return false;
    }

    protected int func_225508_e_(float distance, float damageMultiplier) {
        return 0;
    }

    public void func_213352_e(Vector3d vec) {
        super.func_213352_e(vec);
    }

    public double func_70042_X() {
        return super.func_70042_X() - 0.385;
    }

    protected void func_190680_a(SoundType sound) {
        super.func_190680_a(sound);
        if (this.field_70146_Z.nextInt(10) == 0) {
            this.func_184185_a(SoundEvents.field_187705_cn, sound.func_185843_a() * 0.6f, sound.func_185847_b());
        }
    }

    protected SoundEvent func_184639_G() {
        super.func_184639_G();
        return SoundEvents.field_187696_ck;
    }

    protected SoundEvent func_184615_bR() {
        super.func_184615_bR();
        return SoundEvents.field_187708_co;
    }

    protected SoundEvent func_230274_fe_() {
        return SoundEvents.field_187711_cp;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        super.func_184601_bQ(damageSourceIn);
        return SoundEvents.field_187717_cr;
    }

    protected SoundEvent func_184785_dv() {
        super.func_184785_dv();
        return SoundEvents.field_187699_cl;
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (!this.func_70631_g_()) {
            if (this.func_110248_bS() && player.func_226563_dT_()) {
                this.func_110199_f(player);
                return ActionResultType.func_233537_a_((boolean)this.field_70170_p.func_201670_d());
            }
            if (this.func_184207_aI()) {
                return super.func_230254_b_(player, hand);
            }
            if (itemstack.func_190926_b() && this.func_110248_bS() || itemstack.func_77973_b() == GFRegistry.GOLDEN_BRIDLE) {
                this.func_110237_h(player);
                return ActionResultType.func_233537_a_((boolean)this.field_70170_p.func_201670_d());
            }
        }
        if (!itemstack.func_190926_b()) {
            boolean flag;
            if (this.func_70877_b(itemstack)) {
                return this.func_241395_b_(player, itemstack);
            }
            ActionResultType actionresulttype = itemstack.func_111282_a_(player, (LivingEntity)this, hand);
            if (actionresulttype.func_226246_a_()) {
                return actionresulttype;
            }
            if (!this.func_110248_bS()) {
                this.func_190687_dF();
                return ActionResultType.func_233537_a_((boolean)this.field_70170_p.func_201670_d());
            }
            boolean bl = flag = !this.func_70631_g_() && !this.func_110257_ck() && itemstack.func_77973_b() == Items.field_151141_av;
            if (this.func_190682_f(itemstack) || flag) {
                this.func_110199_f(player);
                return ActionResultType.func_233537_a_((boolean)this.field_70170_p.func_201670_d());
            }
        }
        return super.func_230254_b_(player, hand);
    }

    public int func_190676_dC() {
        return 160;
    }

    public boolean func_70878_b(AnimalEntity otherAnimal) {
        if (otherAnimal == this) {
            return false;
        }
        return otherAnimal instanceof PegasusEntity && this.func_110200_cJ() && ((PegasusEntity)otherAnimal).func_110200_cJ();
    }

    public AgeableEntity func_241840_a(ServerWorld world, AgeableEntity mate) {
        PegasusEntity pegasusMate = (PegasusEntity)mate;
        PegasusEntity child = (PegasusEntity)GFRegistry.PEGASUS_ENTITY.func_200721_a((World)world);
        int i = this.field_70146_Z.nextInt(9);
        CoatColors coatcolors = i < 4 ? this.getCoatColor() : (i < 8 ? pegasusMate.getCoatColor() : (CoatColors)Util.func_240989_a_((Object[])CoatColors.values(), (Random)this.field_70146_Z));
        int j = this.field_70146_Z.nextInt(5);
        CoatTypes coattypes = j < 2 ? this.getCoatType() : (j < 4 ? pegasusMate.getCoatType() : (CoatTypes)Util.func_240989_a_((Object[])CoatTypes.values(), (Random)this.field_70146_Z));
        child.setCoatColor(coatcolors, coattypes);
        this.func_190681_a(mate, child);
        return child;
    }

    public void setPackedCoatColor(int packedColorsTypes) {
        this.field_70180_af.func_187227_b(DATA_COLOR, (Object)packedColorsTypes);
    }

    public int getPackedCoatColor() {
        return (Integer)this.field_70180_af.func_187225_a(DATA_COLOR);
    }

    public void setCoatColor(CoatColors color, CoatTypes type) {
        this.setPackedCoatColor(color.func_234253_a_() & 0xFF | type.func_234247_a_() << 8 & 0xFF00);
    }

    public CoatColors getCoatColor() {
        return CoatColors.func_234254_a_((int)(this.getPackedCoatColor() & 0xFF));
    }

    public CoatTypes getCoatType() {
        return CoatTypes.func_234248_a_((int)((this.getPackedCoatColor() & 0xFF00) >> 8));
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a(KEY_COLOR, this.getPackedCoatColor());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setPackedCoatColor(compound.func_74762_e(KEY_COLOR));
    }

    class AvoidPlayersGoal
    extends AvoidEntityGoal<PlayerEntity> {
        public AvoidPlayersGoal(PegasusEntity pegasus) {
            super((CreatureEntity)pegasus, PlayerEntity.class, 16.0f, 1.1, 0.95, entity -> !entity.func_226273_bm_() && EntityPredicates.field_188444_d.test(entity) && !pegasus.func_184207_aI() && (!pegasus.func_110248_bS() || pegasus.func_184780_dh() == null || !entity.func_110124_au().equals(pegasus.func_184780_dh())));
        }

        public boolean func_75250_a() {
            this.field_75375_g = this.field_75380_a.func_70661_as();
            return super.func_75250_a();
        }
    }
}

