/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.entity;

import greekfantasy.entity.ai.IntervalRangedAttackGoal;
import greekfantasy.entity.misc.PoisonSpitEntity;
import java.util.function.Predicate;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.BossInfo;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerBossInfo;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PythonEntity
extends MonsterEntity
implements IRangedAttackMob {
    private static final DataParameter<Byte> STATE = EntityDataManager.func_187226_a(PythonEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final String KEY_STATE = "PythonState";
    private static final byte NONE = 0;
    private static final byte SPAWNING = 1;
    private static final byte SPIT = 2;
    private static final byte SPIT_CLIENT = 9;
    private static final Predicate<LivingEntity> CAN_TARGET = e -> {
        if (e != null && e.func_184222_aU() && EntityPredicates.field_212545_b.test(e) && EntityPredicates.field_233583_f_.test(e)) {
            CreatureAttribute attr = e.func_70668_bt();
            return attr != CreatureAttribute.field_223224_c_ && attr != CreatureAttribute.field_223223_b_ && attr != CreatureAttribute.field_203100_e;
        }
        return false;
    };
    private static final int MAX_SPAWN_TIME = 110;
    private static final int MAX_SPIT_TIME = 66;
    private final ServerBossInfo bossInfo = new ServerBossInfo(this.func_145748_c_(), BossInfo.Color.GREEN, BossInfo.Overlay.PROGRESS);
    private int spawnTime;
    private int spitTime;

    public PythonEntity(EntityType<? extends PythonEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70138_W = 1.0f;
        this.field_70728_aV = 50;
    }

    public static AttributeModifierMap.MutableAttribute getAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 70.0).func_233815_a_(Attributes.field_233821_d_, 0.31).func_233815_a_(Attributes.field_233823_f_, 4.5).func_233815_a_(Attributes.field_233820_c_, 0.8).func_233815_a_(Attributes.field_233819_b_, 32.0).func_233815_a_(Attributes.field_233826_i_, 1.5);
    }

    public void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(STATE, (Object)0);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(3, (Goal)new PoisonSpitAttackGoal(this, 66, 3, 165));
        this.field_70714_bg.func_75776_a(4, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, true));
        this.field_70714_bg.func_75776_a(5, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.7));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, AnimalEntity.class, 10, false, false, CAN_TARGET));
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
        if (this.isSpawning() && --this.spawnTime <= 0) {
            this.setSpawning(false);
        }
        if (this.isSpitAttack()) {
            ++this.spitTime;
        } else if (this.spitTime > 0) {
            this.spitTime = 0;
        }
    }

    public boolean func_184222_aU() {
        return false;
    }

    public boolean func_213397_c(double disToPlayer) {
        return false;
    }

    protected boolean func_184228_n(Entity entityIn) {
        return false;
    }

    public boolean func_180431_b(DamageSource source) {
        return source == DamageSource.field_76368_d || source == DamageSource.field_82727_n || super.func_180431_b(source);
    }

    public boolean func_70617_f_() {
        return false;
    }

    public void func_184178_b(ServerPlayerEntity player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(ServerPlayerEntity player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187817_fK;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187821_fM;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187819_fL;
    }

    protected float func_70599_aP() {
        return 1.0f;
    }

    protected float func_70647_i() {
        return 0.6f + this.field_70146_Z.nextFloat() * 0.2f;
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74774_a(KEY_STATE, this.getPythonState());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setPythonState(compound.func_74771_c(KEY_STATE));
    }

    public byte getPythonState() {
        return (Byte)this.func_184212_Q().func_187225_a(STATE);
    }

    public void setPythonState(byte state) {
        this.func_184212_Q().func_187227_b(STATE, (Object)state);
    }

    public boolean isNoneState() {
        return this.getPythonState() == 0;
    }

    public boolean isSpitAttack() {
        return this.getPythonState() == 2;
    }

    public void setSpitAttack(boolean smash) {
        this.setPythonState(smash ? (byte)2 : 0);
    }

    public boolean isSpawning() {
        return this.spawnTime > 0 || this.getPythonState() == 1;
    }

    public void setSpawning(boolean spawning) {
        this.spawnTime = spawning ? 110 : 0;
        this.setPythonState(spawning ? (byte)1 : 0);
    }

    public void func_184206_a(DataParameter<?> key) {
        super.func_184206_a(key);
        if (key == STATE) {
            this.spawnTime = this.isSpawning() ? 110 : 0;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        switch (id) {
            case 9: {
                break;
            }
            default: {
                super.func_70103_a(id);
            }
        }
    }

    public void func_82196_d(LivingEntity target, float distanceFactor) {
        if (!this.field_70170_p.func_201670_d()) {
            PoisonSpitEntity healingSpell = PoisonSpitEntity.create(this.field_70170_p, (LivingEntity)this);
            this.field_70170_p.func_217376_c((Entity)healingSpell);
        }
        this.func_184185_a(SoundEvents.field_191255_dF, 1.2f, 1.0f);
    }

    class PoisonSpitAttackGoal
    extends IntervalRangedAttackGoal {
        protected PoisonSpitAttackGoal(IRangedAttackMob entityIn, int duration, int count, int maxCooldownIn) {
            super(entityIn, duration, count, maxCooldownIn);
        }

        @Override
        public boolean func_75250_a() {
            return super.func_75250_a() && PythonEntity.this.isNoneState();
        }

        @Override
        public void func_75249_e() {
            super.func_75249_e();
            PythonEntity.this.setSpitAttack(true);
            PythonEntity.this.func_130014_f_().func_72960_a((Entity)PythonEntity.this, (byte)9);
            PythonEntity.this.func_184185_a(SoundEvents.field_187572_ar, 1.0f, 1.2f);
        }

        @Override
        public void func_75251_c() {
            super.func_75251_c();
            PythonEntity.this.setSpitAttack(false);
        }
    }
}

