/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.entity;

import greekfantasy.GFRegistry;
import greekfantasy.GreekFantasy;
import greekfantasy.entity.ai.SummonMobGoal;
import greekfantasy.item.InstrumentItem;
import greekfantasy.util.SongManager;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.CampfireBlock;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IAngerable;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.ResetAngerGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.passive.WolfEntity;
import net.minecraft.entity.passive.horse.CoatColors;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.state.Property;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.RangedInteger;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.TickRangeConverter;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.GameRules;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;

public class SatyrEntity
extends CreatureEntity
implements IAngerable {
    private static final DataParameter<Byte> DATA_STATE = EntityDataManager.func_187226_a(SatyrEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Boolean> DATA_SHAMAN = EntityDataManager.func_187226_a(SatyrEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Byte> DATA_COLOR = EntityDataManager.func_187226_a(SatyrEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final String KEY_SHAMAN = "Shaman";
    private static final String KEY_COLOR = "Color";
    private static final Direction[] HORIZONTALS = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};
    private static final ResourceLocation SUMMONING_SONG = new ResourceLocation("greekfantasy", "sarias_song");
    protected static final byte NONE = 0;
    protected static final byte DANCING = 1;
    protected static final byte SUMMONING = 2;
    protected static final byte PLAY_SUMMON_SOUND = 12;
    protected static final int MAX_SUMMON_TIME = 160;
    protected static final int MAX_PANFLUTE_TIME = 10;
    public int holdingPanfluteTime;
    public int summonTime;
    public boolean hasShamanTexture;
    private static final RangedInteger ANGER_RANGE = TickRangeConverter.func_233037_a_((int)20, (int)39);
    private int angerTime;
    private UUID angerTarget;
    private Optional<BlockPos> campfirePos = Optional.empty();
    private final Goal meleeAttackGoal;
    private final Goal summonAnimalsGoal;

    public SatyrEntity(EntityType<? extends SatyrEntity> type, World worldIn) {
        super(type, worldIn);
        this.func_184644_a(PathNodeType.DANGER_FIRE, -1.0f);
        this.func_184644_a(PathNodeType.DAMAGE_FIRE, -1.0f);
        this.meleeAttackGoal = new MeleeAttackGoal((CreatureEntity)this, 1.0, false);
        this.summonAnimalsGoal = new SummonAnimalsGoal(160, 280);
    }

    public static AttributeModifierMap.MutableAttribute getAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 24.0).func_233815_a_(Attributes.field_233821_d_, 0.25).func_233815_a_(Attributes.field_233823_f_, 2.0);
    }

    public void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(DATA_STATE, (Object)0);
        this.func_184212_Q().func_187214_a(DATA_SHAMAN, (Object)false);
        this.func_184212_Q().func_187214_a(DATA_COLOR, (Object)0);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new DancingGoal(0.75, 880));
        this.field_70714_bg.func_75776_a(3, (Goal)new PanicGoal(this, 1.3));
        this.field_70714_bg.func_75776_a(4, (Goal)new StartDancingGoal(0.9, 22, 12, 420));
        this.field_70714_bg.func_75776_a(6, (Goal)new RandomWalkingGoal(this, 0.8, 160){

            public boolean func_75250_a() {
                return SatyrEntity.this.isIdleState() && SatyrEntity.this.func_70638_az() == null && super.func_75250_a();
            }
        });
        this.field_70714_bg.func_75776_a(7, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, 10, true, false, arg_0 -> ((SatyrEntity)this).func_233680_b_(arg_0)));
        this.field_70715_bh.func_75776_a(3, (Goal)new ResetAngerGoal((MobEntity)this, true));
        if (((Boolean)GreekFantasy.CONFIG.SATYR_LIGHTS_CAMPFIRES.get()).booleanValue()) {
            this.field_70714_bg.func_75776_a(5, (Goal)new LightCampfireGoal(0.9, 12, 10, 60, 500));
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70170_p.func_201670_d()) {
            if (this.isSummoning()) {
                SongManager.playMusic((LivingEntity)this, (InstrumentItem)GFRegistry.PANFLUTE, SUMMONING_SONG, this.summonTime, 0.92f, 0.34f);
            } else if (this.isDancing()) {
                SongManager.playMusic((LivingEntity)this, (InstrumentItem)GFRegistry.PANFLUTE, GreekFantasy.CONFIG.getSatyrSong(), this.field_70170_p.func_82737_E(), 0.84f, 0.28f);
            }
        } else {
            this.func_241359_a_((ServerWorld)this.field_70170_p, true);
            if (this.field_70173_aa % 60 == 1 && this.campfirePos.isPresent() && !SatyrEntity.isValidCampfire((IWorldReader)this.field_70170_p, this.campfirePos.get())) {
                this.campfirePos = Optional.empty();
                this.setDancing(false);
            }
        }
        this.holdingPanfluteTime = this.isDancing() || this.isSummoning() ? Math.min(this.holdingPanfluteTime + 1, 10) : Math.max(this.holdingPanfluteTime - 1, 0);
        if (this.summonTime > 0 && this.summonTime++ > 160) {
            this.summonTime = 0;
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        boolean attackEntityFrom = super.func_70097_a(source, amount);
        if (attackEntityFrom && source.func_76364_f() instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)source.func_76364_f();
            List shamans = this.func_130014_f_().func_175647_a(SatyrEntity.class, this.func_174813_aQ().func_186662_g(10.0), e -> e.isShaman());
            for (SatyrEntity shaman : shamans) {
                if (shaman.func_70638_az() != null) continue;
                shaman.func_70604_c(target);
                shaman.func_230259_a_(target.func_110124_au());
                shaman.func_230258_H__();
            }
        }
        return attackEntityFrom;
    }

    public boolean func_180431_b(DamageSource source) {
        if (super.func_180431_b(source)) {
            return true;
        }
        return source == DamageSource.field_76372_a;
    }

    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        CoatColors color;
        if (spawnDataIn instanceof GroupData) {
            color = ((GroupData)spawnDataIn).variant;
        } else {
            color = (CoatColors)Util.func_240989_a_((Object[])CoatColors.values(), (Random)this.field_70146_Z);
            spawnDataIn = new GroupData(color);
        }
        this.setCoatColor(color);
        if (worldIn.func_201674_k().nextInt(100) < GreekFantasy.CONFIG.getSatyrShamanChance()) {
            this.setShaman(true);
        }
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public void func_184206_a(DataParameter<?> key) {
        super.func_184206_a(key);
        if (key == DATA_SHAMAN) {
            this.updateCombatAI();
            this.hasShamanTexture = this.isShaman();
        } else if (key == DATA_STATE) {
            this.summonTime = this.isSummoning() ? 1 : 0;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 12) {
            this.func_130014_f_().func_184134_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_189111_gN, this.func_184176_by(), 1.1f, 0.9f + this.func_70681_au().nextFloat() * 0.2f, false);
            this.summonTime = 0;
        } else {
            super.func_70103_a(id);
        }
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a(KEY_SHAMAN, this.isShaman());
        compound.func_74774_a(KEY_COLOR, (byte)this.getCoatColor().func_234253_a_());
        this.func_233682_c_(compound);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setShaman(compound.func_74767_n(KEY_SHAMAN));
        this.setCoatColor(CoatColors.func_234254_a_((int)compound.func_74771_c(KEY_COLOR)));
        this.func_241358_a_((ServerWorld)this.field_70170_p, compound);
    }

    public void func_230258_H__() {
        this.func_230260_a__(ANGER_RANGE.func_233018_a_(this.field_70146_Z));
    }

    public void func_230260_a__(int time) {
        this.angerTime = time;
    }

    public int func_230256_F__() {
        return this.angerTime;
    }

    public void func_230259_a_(@Nullable UUID target) {
        this.angerTarget = target;
    }

    public UUID func_230257_G__() {
        return this.angerTarget;
    }

    public boolean isIdleState() {
        return (Byte)this.func_184212_Q().func_187225_a(DATA_STATE) == 0;
    }

    public void setIdleState() {
        this.func_184212_Q().func_187227_b(DATA_STATE, (Object)0);
    }

    public boolean isDancing() {
        return (Byte)this.func_184212_Q().func_187225_a(DATA_STATE) == 1;
    }

    public void setDancing(boolean dancing) {
        this.func_184212_Q().func_187227_b(DATA_STATE, (Object)(dancing ? (byte)1 : 0));
    }

    public boolean isSummoning() {
        return (Byte)this.func_184212_Q().func_187225_a(DATA_STATE) == 2;
    }

    public void setSummoning(boolean summoning) {
        this.func_184212_Q().func_187227_b(DATA_STATE, (Object)(summoning ? (byte)2 : 0));
    }

    public boolean isShaman() {
        return (Boolean)this.func_184212_Q().func_187225_a(DATA_SHAMAN);
    }

    public void setShaman(boolean shaman) {
        this.hasShamanTexture = shaman;
        this.func_184212_Q().func_187227_b(DATA_SHAMAN, (Object)shaman);
        if (this.func_70613_aW()) {
            this.updateCombatAI();
        }
    }

    public void setCoatColor(CoatColors color) {
        this.func_184212_Q().func_187227_b(DATA_COLOR, (Object)((byte)color.func_234253_a_()));
    }

    public CoatColors getCoatColor() {
        return CoatColors.func_234254_a_((int)((Byte)this.func_184212_Q().func_187225_a(DATA_COLOR)).intValue());
    }

    protected void updateCombatAI() {
        if (this.func_70613_aW()) {
            if (this.isShaman() && ((Boolean)GreekFantasy.CONFIG.SATYR_ATTACK.get()).booleanValue()) {
                this.field_70714_bg.func_75776_a(1, this.summonAnimalsGoal);
                this.field_70714_bg.func_85156_a(this.meleeAttackGoal);
            } else {
                this.field_70714_bg.func_75776_a(1, this.meleeAttackGoal);
                this.field_70714_bg.func_85156_a(this.summonAnimalsGoal);
            }
        }
    }

    public boolean hasShamanTexture() {
        return this.hasShamanTexture;
    }

    public float getArmMovementPercent(float ageInTicks) {
        float time = this.holdingPanfluteTime;
        return Math.min(1.0f, time / 10.0f);
    }

    protected static boolean isValidCampfire(IWorldReader world, BlockPos pos) {
        BlockState campfire = world.func_180495_p(pos);
        if (!campfire.func_235714_a_((ITag)BlockTags.field_232882_ax_) || !((Boolean)campfire.func_177229_b((Property)CampfireBlock.field_220101_b)).booleanValue() || ((Boolean)campfire.func_177229_b((Property)CampfireBlock.field_220103_d)).booleanValue()) {
            return false;
        }
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                BlockPos p;
                if (x == 0 && z == 0 || world.func_180495_p((p = pos.func_177982_a(x, 0, z)).func_177977_b()).func_185904_a().func_76220_a() && !world.func_180495_p(p).func_200132_m() && !world.func_180495_p(p).func_185904_a().func_76230_c()) continue;
                return false;
            }
        }
        return true;
    }

    protected static Optional<BlockPos> getCampfireNear(IWorldReader world, BlockPos pos, boolean lit) {
        for (int x = -2; x <= 2; ++x) {
            for (int z = -2; z <= 2; ++z) {
                BlockPos p = pos.func_177982_a(x, 0, z);
                BlockState state = world.func_180495_p(p);
                if (!state.func_235714_a_((ITag)BlockTags.field_232882_ax_) || (Boolean)state.func_177229_b((Property)CampfireBlock.field_220101_b) != lit || ((Boolean)state.func_177229_b((Property)CampfireBlock.field_220103_d)).booleanValue()) continue;
                return Optional.of(p);
            }
        }
        return Optional.empty();
    }

    public static class GroupData
    implements ILivingEntityData {
        public final CoatColors variant;

        public GroupData(CoatColors color) {
            this.variant = color;
        }
    }

    class LightCampfireGoal
    extends MoveToBlockGoal {
        protected final int maxLightCampfireTime;
        protected final int chance;
        protected int lightCampfireTimer;

        public LightCampfireGoal(double speed, int searchLength, int radius, int maxLightTime, int chanceIn) {
            super((CreatureEntity)SatyrEntity.this, speed, searchLength, radius);
            this.maxLightCampfireTime = maxLightTime;
            this.chance = chanceIn;
        }

        protected boolean func_179488_a(IWorldReader worldIn, BlockPos pos) {
            for (Direction d : HORIZONTALS) {
                BlockState blockstate = worldIn.func_180495_p(pos.func_177967_a(d, 1));
                if (!blockstate.func_235714_a_((ITag)BlockTags.field_232882_ax_) || ((Boolean)blockstate.func_177229_b((Property)CampfireBlock.field_220101_b)).booleanValue()) continue;
                return true;
            }
            return false;
        }

        public double func_203110_f() {
            return 2.0;
        }

        public boolean func_75250_a() {
            return SatyrEntity.this.isIdleState() && SatyrEntity.this.func_70638_az() == null && !SatyrEntity.this.func_130014_f_().func_72896_J() && SatyrEntity.this.func_130014_f_().func_82736_K().func_223586_b(GameRules.field_223599_b) && super.func_75250_a();
        }

        public void func_75249_e() {
            this.lightCampfireTimer = 0;
            super.func_75249_e();
        }

        public void func_75246_d() {
            Optional<BlockPos> campfire = SatyrEntity.getCampfireNear((IWorldReader)SatyrEntity.this.field_70170_p, SatyrEntity.this.func_233580_cy_(), false);
            if (this.func_179487_f() && campfire.isPresent()) {
                if (this.lightCampfireTimer >= this.maxLightCampfireTime) {
                    this.lightCampfire(campfire.get());
                } else {
                    ++this.lightCampfireTimer;
                    if (SatyrEntity.this.func_70681_au().nextInt(12) == 0) {
                        SatyrEntity.this.func_184185_a(SoundEvents.field_187649_bu, 1.0f, 1.0f);
                        SatyrEntity.this.func_184609_a(Hand.MAIN_HAND);
                    }
                    SatyrEntity.this.func_70671_ap().func_220674_a(Vector3d.func_237492_c_((Vector3i)((Vector3i)campfire.get())));
                }
            }
            super.func_75246_d();
        }

        protected int func_203109_a(CreatureEntity entity) {
            return 200 + entity.func_70681_au().nextInt(this.chance) + this.maxLightCampfireTime;
        }

        protected boolean lightCampfire(BlockPos pos) {
            BlockState state;
            if (ForgeEventFactory.getMobGriefingEvent((World)SatyrEntity.this.field_70170_p, (Entity)SatyrEntity.this) && (state = SatyrEntity.this.field_70170_p.func_180495_p(pos)).func_235714_a_((ITag)BlockTags.field_232882_ax_)) {
                if (SatyrEntity.this.func_70681_au().nextInt(20) == 0) {
                    SatyrEntity.this.func_184185_a(SoundEvents.field_187649_bu, 1.0f, 1.0f);
                }
                SatyrEntity.this.field_70170_p.func_180501_a(pos, (BlockState)state.func_206870_a((Property)CampfireBlock.field_220101_b, (Comparable)Boolean.valueOf(true)), 2);
                SatyrEntity.this.func_184609_a(Hand.MAIN_HAND);
                return true;
            }
            return false;
        }
    }

    class StartDancingGoal
    extends MoveToBlockGoal {
        protected final int chance;

        public StartDancingGoal(double speed, int searchLength, int radius, int chanceIn) {
            super((CreatureEntity)SatyrEntity.this, speed, searchLength, radius);
            this.chance = chanceIn;
        }

        public boolean func_75250_a() {
            return SatyrEntity.this.func_70638_az() == null && SatyrEntity.this.isIdleState() && super.func_75250_a();
        }

        protected boolean func_179488_a(IWorldReader worldIn, BlockPos pos) {
            for (Direction d : HORIZONTALS) {
                if (!SatyrEntity.isValidCampfire(worldIn, pos.func_177967_a(d, 1))) continue;
                return true;
            }
            return false;
        }

        public double func_203110_f() {
            return 2.0;
        }

        public void func_75246_d() {
            if (this.func_179487_f()) {
                Optional<BlockPos> campfire = SatyrEntity.getCampfireNear((IWorldReader)SatyrEntity.this.field_70170_p, SatyrEntity.this.func_233580_cy_(), true);
                if (campfire.isPresent() && SatyrEntity.isValidCampfire((IWorldReader)SatyrEntity.this.field_70170_p, campfire.get())) {
                    SatyrEntity.this.campfirePos = campfire;
                    SatyrEntity.this.setDancing(true);
                } else {
                    this.func_75251_c();
                }
            }
            super.func_75246_d();
        }

        protected int func_203109_a(CreatureEntity entity) {
            return 200 + entity.func_70681_au().nextInt(this.chance);
        }
    }

    class DancingGoal
    extends Goal {
        private final int maxTravelTime = 100;
        private final int maxDancingTime;
        private Optional<Vector3d> targetPos = Optional.empty();
        protected final double moveSpeed;
        private int dancingTime = 0;
        private int travelTime = 0;

        public DancingGoal(double speedIn, int dancingTimeIn) {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP));
            this.moveSpeed = speedIn;
            this.maxDancingTime = dancingTimeIn;
        }

        public boolean func_75250_a() {
            return SatyrEntity.this.isDancing() && this.updateTarget();
        }

        public void func_75249_e() {
            super.func_75249_e();
            if (this.targetPos.isPresent()) {
                SatyrEntity.this.func_70661_as().func_75492_a(this.targetPos.get().field_72450_a, this.targetPos.get().field_72448_b, this.targetPos.get().field_72449_c, this.moveSpeed);
                this.dancingTime = 1;
            }
        }

        public boolean func_75253_b() {
            boolean isCampfireValid = true;
            if (SatyrEntity.this.field_70173_aa % 15 == 1) {
                isCampfireValid = SatyrEntity.this.campfirePos.isPresent() && SatyrEntity.isValidCampfire((IWorldReader)SatyrEntity.this.func_130014_f_(), (BlockPos)SatyrEntity.this.campfirePos.get());
            }
            return SatyrEntity.this.func_70638_az() == null && SatyrEntity.this.field_70737_aN == 0 && this.targetPos.isPresent() && isCampfireValid;
        }

        public void func_75246_d() {
            super.func_75246_d();
            if (this.dancingTime++ < this.maxDancingTime && this.travelTime++ < 100) {
                if (this.isNearTarget(1.26)) {
                    this.updateTarget();
                    if (SatyrEntity.this.func_233570_aj_()) {
                        SatyrEntity.this.func_70664_aZ();
                    }
                    SatyrEntity.this.func_70661_as().func_75492_a(this.targetPos.get().field_72450_a, this.targetPos.get().field_72448_b, this.targetPos.get().field_72449_c, this.moveSpeed);
                    this.travelTime = 0;
                }
            } else {
                this.func_75251_c();
            }
        }

        public void func_75251_c() {
            if (SatyrEntity.this.campfirePos.isPresent() && ((BlockPos)SatyrEntity.this.campfirePos.get()).func_218141_a((Vector3i)SatyrEntity.this.func_233580_cy_(), 4.0)) {
                Vector3d vec = RandomPositionGenerator.func_75461_b((CreatureEntity)SatyrEntity.this, (int)4, (int)4, (Vector3d)Vector3d.func_237492_c_((Vector3i)((Vector3i)SatyrEntity.this.campfirePos.get())));
                if (vec != null) {
                    SatyrEntity.this.func_70661_as().func_75492_a(vec.func_82615_a(), vec.func_82617_b(), vec.func_82616_c(), this.moveSpeed);
                }
            } else {
                SatyrEntity.this.func_70661_as().func_75499_g();
            }
            SatyrEntity.this.campfirePos = Optional.empty();
            this.targetPos = Optional.empty();
            this.dancingTime = 0;
            this.travelTime = 0;
            SatyrEntity.this.setDancing(false);
        }

        private boolean updateTarget() {
            if (SatyrEntity.this.campfirePos.isPresent()) {
                Direction nextDir = this.getClosestDirection().func_176746_e();
                BlockPos target = ((BlockPos)SatyrEntity.this.campfirePos.get()).func_177972_a(nextDir);
                this.targetPos = Optional.of(new Vector3d((double)target.func_177958_n() + 0.5, (double)target.func_177956_o(), (double)target.func_177952_p() + 0.5));
                return true;
            }
            return false;
        }

        private Direction getClosestDirection() {
            Direction dClosest = Direction.NORTH;
            Vector3d curPos = SatyrEntity.this.func_213303_ch();
            double dMin = 100.0;
            if (SatyrEntity.this.campfirePos.isPresent()) {
                for (Direction dir : HORIZONTALS) {
                    BlockPos dPos = ((BlockPos)SatyrEntity.this.campfirePos.get()).func_177972_a(dir);
                    Vector3d dVec = new Vector3d((double)dPos.func_177958_n() + 0.5, (double)dPos.func_177956_o(), (double)dPos.func_177952_p() + 0.5);
                    double dSq = curPos.func_72436_e(dVec);
                    if (!(dSq < dMin)) continue;
                    dClosest = dir;
                    dMin = dSq;
                }
            }
            return dClosest;
        }

        private boolean isNearTarget(double distance) {
            return this.targetPos.isPresent() && this.targetPos.get().func_237488_a_((IPosition)SatyrEntity.this.func_213303_ch(), distance);
        }
    }

    class PanicGoal
    extends net.minecraft.entity.ai.goal.PanicGoal {
        public PanicGoal(CreatureEntity entity, double speed) {
            super(entity, speed);
        }

        public boolean func_75250_a() {
            return SatyrEntity.this.func_70638_az() == null && super.func_75250_a();
        }

        public void func_75246_d() {
            SatyrEntity.this.setIdleState();
            super.func_75246_d();
        }
    }

    class SummonAnimalsGoal
    extends SummonMobGoal<WolfEntity> {
        public SummonAnimalsGoal(int summonProgressIn, int summonCooldownIn) {
            super((MobEntity)SatyrEntity.this, summonProgressIn, summonCooldownIn, EntityType.field_200724_aC, 3);
        }

        @Override
        public void func_75249_e() {
            super.func_75249_e();
            SatyrEntity.this.setSummoning(true);
        }

        @Override
        public void func_75246_d() {
            super.func_75246_d();
        }

        @Override
        public void func_75251_c() {
            super.func_75251_c();
            SatyrEntity.this.setSummoning(false);
        }

        @Override
        protected void summonMob(WolfEntity mobEntity) {
            mobEntity.func_230260_a__(800);
            mobEntity.func_230259_a_(SatyrEntity.this.func_70638_az().func_110124_au());
            super.summonMob(mobEntity);
        }
    }
}

