/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.entity;

import greekfantasy.GreekFantasy;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;

public class ShadeEntity
extends MonsterEntity {
    protected static final DataParameter<Integer> DATA_XP = EntityDataManager.func_187226_a(ShadeEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Optional<UUID>> OWNER_UNIQUE_ID = EntityDataManager.func_187226_a(ShadeEntity.class, (IDataSerializer)DataSerializers.field_187203_m);
    protected static final String KEY_XP = "StoredXP";
    protected static final String KEY_OWNER = "Owner";
    protected static final String KEY_DESPAWN = "NoDespawn";

    public ShadeEntity(EntityType<? extends ShadeEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70138_W = 1.0f;
        this.field_70728_aV = 0;
    }

    public static AttributeModifierMap.MutableAttribute getAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 12.0).func_233815_a_(Attributes.field_233821_d_, 0.21).func_233815_a_(Attributes.field_233820_c_, 0.86).func_233815_a_(Attributes.field_233823_f_, 0.1);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(3, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, true));
        this.field_70714_bg.func_75776_a(4, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 12.0f));
        this.field_70714_bg.func_75776_a(5, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, 10, true, true, this::canTargetPlayerEntity));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(DATA_XP, (Object)0);
        this.func_184212_Q().func_187214_a(OWNER_UNIQUE_ID, Optional.empty());
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70170_p.func_201670_d()) {
            double motion = 0.08;
            double radius = 1.2;
            for (int i = 0; i < 5; ++i) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197601_L, this.func_226277_ct_() + (this.field_70170_p.field_73012_v.nextDouble() - 0.5) * 1.2, this.func_226278_cu_() + 0.75 + (this.field_70170_p.field_73012_v.nextDouble() - 0.5) * 1.2 * 0.75, this.func_226281_cx_() + (this.field_70170_p.field_73012_v.nextDouble() - 0.5) * 1.2, (this.field_70170_p.field_73012_v.nextDouble() - 0.5) * 0.08, (this.field_70170_p.field_73012_v.nextDouble() - 0.5) * 0.08 * 0.5, (this.field_70170_p.field_73012_v.nextDouble() - 0.5) * 0.08);
            }
        }
    }

    public boolean func_70652_k(Entity entity) {
        if (super.func_70652_k(entity)) {
            if (entity instanceof PlayerEntity) {
                PlayerEntity player = (PlayerEntity)entity;
                if (((Boolean)GreekFantasy.CONFIG.SHADE_ATTACK.get()).booleanValue() && player.field_71067_cb > 0) {
                    int xpSteal = Math.min(player.field_71067_cb, 10);
                    player.func_195068_e(-xpSteal);
                    this.setStoredXP(this.getStoredXP() + xpSteal);
                } else {
                    player.func_195064_c(new EffectInstance(Effects.field_82731_v, 80));
                }
            }
            return true;
        }
        return false;
    }

    public boolean func_180431_b(DamageSource source) {
        if (super.func_180431_b(source)) {
            return true;
        }
        return source.func_76346_g() instanceof PlayerEntity && this.isInvulnerableToPlayer((PlayerEntity)source.func_76346_g());
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187674_a;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187531_aU;
    }

    protected float func_70599_aP() {
        return 0.8f;
    }

    public boolean func_213358_a(EntityType<?> typeIn) {
        return typeIn == EntityType.field_200729_aH;
    }

    public boolean func_70104_M() {
        return false;
    }

    protected void func_85033_bc() {
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223223_b_;
    }

    protected boolean func_225511_J_() {
        return true;
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    protected void func_184231_a(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    @Nullable
    public UUID getOwnerUniqueId() {
        return ((Optional)this.field_70180_af.func_187225_a(OWNER_UNIQUE_ID)).orElse(null);
    }

    public void setOwnerUniqueId(@Nullable UUID uniqueId) {
        this.field_70180_af.func_187227_b(OWNER_UNIQUE_ID, Optional.ofNullable(uniqueId));
    }

    public int getStoredXP() {
        return (Integer)this.func_184212_Q().func_187225_a(DATA_XP);
    }

    public void setStoredXP(int xp) {
        this.func_184212_Q().func_187227_b(DATA_XP, (Object)xp);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a(KEY_XP, this.getStoredXP());
        if (this.getOwnerUniqueId() != null) {
            compound.func_186854_a(KEY_OWNER, this.getOwnerUniqueId());
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setStoredXP(compound.func_74762_e(KEY_XP));
        if (compound.func_186855_b(KEY_OWNER)) {
            this.setOwnerUniqueId(compound.func_186857_a(KEY_OWNER));
        }
    }

    protected int func_70693_a(PlayerEntity attackingPlayer) {
        return 0;
    }

    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        if (this.getStoredXP() == 0) {
            this.setStoredXP(5 + this.field_70146_Z.nextInt(10));
        }
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public void func_70645_a(DamageSource source) {
        if (source.func_76346_g() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)source.func_76346_g();
            player.func_195068_e(this.getStoredXP());
        }
        super.func_70645_a(source);
    }

    public boolean canTargetPlayerEntity(LivingEntity entity) {
        return entity instanceof PlayerEntity && !this.isInvulnerableToPlayer((PlayerEntity)entity);
    }

    public boolean isInvulnerableToPlayer(PlayerEntity player) {
        if (((Boolean)GreekFantasy.CONFIG.SHADE_PLAYER_ONLY.get()).booleanValue() && !player.func_184812_l_()) {
            UUID uuidPlayer = PlayerEntity.func_175147_b((String)player.func_145748_c_().func_150261_e());
            return this.getOwnerUniqueId() != null && !uuidPlayer.equals(this.getOwnerUniqueId());
        }
        return false;
    }
}

