/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.entity;

import greekfantasy.GFRegistry;
import greekfantasy.GreekFantasy;
import greekfantasy.entity.SpartiEntity;
import greekfantasy.entity.ai.SwimUpGoal;
import greekfantasy.entity.ai.SwimmingMovementController;
import greekfantasy.entity.misc.ISwimmingMob;
import java.util.EnumSet;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.passive.WaterMobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.SwimmerPathNavigator;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biomes;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.BiomeDictionary;

public class SirenEntity
extends WaterMobEntity
implements ISwimmingMob {
    private static final DataParameter<Boolean> CHARMING = EntityDataManager.func_187226_a(SirenEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private final AttributeModifier attackModifier = new AttributeModifier("Charm attack bonus", 2.0, AttributeModifier.Operation.MULTIPLY_TOTAL);
    private static final int STUN_DURATION = 80;
    private boolean swimmingUp;
    private float swimmingPercent;

    public SirenEntity(EntityType<? extends SirenEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70699_by = new SwimmerPathNavigator((MobEntity)this, worldIn);
        this.field_70765_h = new SwimmingMovementController<SirenEntity>(this);
    }

    public static AttributeModifierMap.MutableAttribute getAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 24.0).func_233815_a_(Attributes.field_233821_d_, 0.25).func_233815_a_(Attributes.field_233823_f_, 3.0);
    }

    public static boolean canSirenSpawnOn(EntityType<? extends WaterMobEntity> entity, IWorld world, SpawnReason reason, BlockPos pos, Random rand) {
        if (pos.func_177956_o() <= 45 || pos.func_177956_o() >= world.func_181545_F()) {
            return false;
        }
        RegistryKey biome = world.func_242406_i(pos).orElse(Biomes.field_76772_c);
        return BiomeDictionary.hasType((RegistryKey)biome, (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN) && world.func_204610_c(pos).func_206884_a((ITag)FluidTags.field_206959_a);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(3, new SwimUpGoal<SirenEntity>(this, 1.0, this.field_70170_p.func_181545_F() + 2));
        this.field_70714_bg.func_75776_a(4, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(5, (Goal)new LookRandomlyGoal((MobEntity)this));
        if (((Boolean)GreekFantasy.CONFIG.SIREN_ATTACK.get()).booleanValue()) {
            Predicate<LivingEntity> avoidPred = entity -> !this.isCharming() && EntityPredicates.field_188444_d.test(entity);
            this.field_70714_bg.func_75776_a(2, (Goal)new CharmAttackGoal(250, 100, 24));
            this.field_70714_bg.func_75776_a(3, (Goal)new AvoidEntityGoal((CreatureEntity)this, PlayerEntity.class, 10.0f, 1.2, 1.0, avoidPred));
            this.field_70714_bg.func_75776_a(3, (Goal)new AvoidEntityGoal((CreatureEntity)this, SpartiEntity.class, 10.0f, 1.2, 1.0, avoidPred));
            this.field_70714_bg.func_75776_a(3, (Goal)new AvoidEntityGoal((CreatureEntity)this, IronGolemEntity.class, 10.0f, 1.2, 1.0, avoidPred));
        } else {
            this.field_70714_bg.func_75776_a(2, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, true));
        }
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
    }

    public void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(CHARMING, (Object)false);
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.isCharming() && this.field_70146_Z.nextInt(7) == 0) {
            float color = 0.065f + this.field_70146_Z.nextFloat() * 0.025f;
            this.func_184185_a(SoundEvents.field_187559_bL, 1.8f, color * 15.0f);
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197597_H, this.func_226277_ct_(), this.func_226280_cw_() + 0.15, this.func_226281_cx_(), (double)color, 0.0, 0.0);
        }
        if (this.field_70170_p.func_201670_d()) {
            double motionY = this.func_213322_ci().func_82617_b();
            this.swimmingPercent = !this.func_203007_ba() && !this.func_70090_H() || this.field_82175_bq ? 0.0f : (motionY > -0.01 ? Math.min(this.swimmingPercent + 0.1f, 1.0f) : Math.max(this.swimmingPercent - 0.1f, 0.0f));
        }
    }

    @Override
    public void setSwimmingUp(boolean swimmingUp) {
        this.swimmingUp = swimmingUp;
    }

    @Override
    public boolean isSwimmingUp() {
        return this.swimmingUp;
    }

    public void func_213352_e(Vector3d vec) {
        if (this.func_70613_aW() && this.func_70090_H() && this.isSwimmingUpCalculated()) {
            this.func_213309_a(0.01f, vec);
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.9));
        } else {
            super.func_213352_e(vec);
        }
    }

    public boolean func_96092_aw() {
        return false;
    }

    @Override
    public boolean isSwimmingUpCalculated() {
        if (this.swimmingUp) {
            return true;
        }
        LivingEntity e = this.func_70638_az();
        return e != null && e.func_70090_H();
    }

    public void setCharming(boolean isCharming) {
        this.func_184212_Q().func_187227_b(CHARMING, (Object)isCharming);
    }

    public boolean isCharming() {
        return (Boolean)this.func_184212_Q().func_187225_a(CHARMING);
    }

    private void useCharmingAttack(LivingEntity target) {
        this.func_110148_a(Attributes.field_233823_f_).func_233767_b_(this.attackModifier);
        this.func_70652_k((Entity)target);
        this.func_110148_a(Attributes.field_233823_f_).func_111124_b(this.attackModifier);
        if (GreekFantasy.CONFIG.isStunningNerf()) {
            target.func_195064_c(new EffectInstance(Effects.field_76421_d, 80, 0));
            target.func_195064_c(new EffectInstance(Effects.field_76437_t, 80, 0));
        } else {
            target.func_195064_c(new EffectInstance(GFRegistry.STUNNED_EFFECT, 80, 0));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getSwimmingPercent(float partialTick) {
        return this.swimmingPercent + (partialTick < 1.0f ? partialTick * 0.1f : 0.0f);
    }

    class CharmAttackGoal
    extends Goal {
        protected final EffectInstance nausea;
        protected final int maxProgress;
        protected final int maxCooldown;
        protected final float range;
        protected int progress;
        protected int cooldown;

        public CharmAttackGoal(int progressIn, int cooldownIn, int rangeIn) {
            this.func_220684_a(EnumSet.noneOf(Goal.Flag.class));
            this.maxProgress = progressIn;
            this.maxCooldown = cooldownIn;
            this.cooldown = 60;
            this.range = rangeIn;
            this.nausea = new EffectInstance(Effects.field_76431_k, this.maxProgress, 0, false, false);
        }

        public boolean func_75250_a() {
            if (this.cooldown > 0) {
                --this.cooldown;
            } else {
                return SirenEntity.this.func_70638_az() != null && SirenEntity.this.func_233562_a_((Entity)SirenEntity.this.func_70638_az(), this.range);
            }
            return false;
        }

        public void func_75249_e() {
            SirenEntity.this.setCharming(true);
            this.progress = 1;
        }

        public boolean func_75253_b() {
            return this.progress > 0 && SirenEntity.this.func_70638_az() != null && SirenEntity.this.func_233562_a_((Entity)SirenEntity.this.func_70638_az(), this.range);
        }

        public void func_75246_d() {
            super.func_75246_d();
            LivingEntity target = SirenEntity.this.func_70638_az();
            double disSq = SirenEntity.this.func_174824_e(1.0f).func_72438_d(target.func_213303_ch());
            SirenEntity.this.func_70661_as().func_75499_g();
            SirenEntity.this.func_70671_ap().func_75651_a((Entity)target, 100.0f, 100.0f);
            target.func_195064_c(this.nausea);
            if (disSq > 3.5) {
                LivingEntity attract = target;
                this.attractEntity((Entity)attract, disSq);
            } else {
                SirenEntity.this.useCharmingAttack(target);
                this.func_75251_c();
            }
        }

        public void func_75251_c() {
            this.progress = 0;
            this.cooldown = this.maxCooldown;
            SirenEntity.this.setCharming(false);
        }

        private void attractEntity(Entity entity, double disSq) {
            double motion = 0.06 + 0.009 * (1.0 - disSq / (double)(this.range * this.range));
            Vector3d vec = SirenEntity.this.func_213303_ch().func_178788_d(entity.func_213303_ch()).func_72432_b().func_186678_a(motion);
            entity.func_213317_d(entity.func_213322_ci().func_178787_e(vec).func_216372_d(0.5, 1.0, 0.5));
            entity.func_70024_g(0.0, 0.001, 0.0);
            entity.field_70133_I = true;
        }
    }
}

