/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.entity;

import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.OwnerHurtByTargetGoal;
import net.minecraft.entity.ai.goal.OwnerHurtTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.GhastEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SpartiEntity
extends TameableEntity {
    protected static final DataParameter<Boolean> SPAWNING = EntityDataManager.func_187226_a(SpartiEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    protected static final String KEY_SPAWN_TIME = "Spawning";
    protected static final String KEY_LIFE_TICKS = "LifeTicks";
    private static final byte SPAWN_CLIENT = 11;
    protected final int maxSpawnTime = 60;
    protected int spawnTime;
    protected boolean limitedLifespan;
    protected int limitedLifeTicks;
    private final EntitySize spawningSize = EntitySize.func_220314_b((float)0.8f, (float)0.2f);

    public SpartiEntity(EntityType<? extends SpartiEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public static AttributeModifierMap.MutableAttribute getAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 54.0).func_233815_a_(Attributes.field_233821_d_, 0.28).func_233815_a_(Attributes.field_233823_f_, 2.0).func_233815_a_(Attributes.field_233826_i_, 2.0);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new SpawningGoal());
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, true));
        this.field_70714_bg.func_75776_a(3, (Goal)new FollowOwnerGoal((TameableEntity)this, 1.0, 16.0f, 5.0f, false));
        this.field_70714_bg.func_75776_a(4, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.78));
        this.field_70714_bg.func_75776_a(5, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new OwnerHurtByTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(2, (Goal)new OwnerHurtTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, MobEntity.class, 5, false, false, e -> e instanceof IMob && !(e instanceof CreeperEntity)));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(SPAWNING, (Object)false);
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.limitedLifespan && --this.limitedLifeTicks <= 0) {
            this.limitedLifeTicks = 20;
            this.func_70097_a(DamageSource.field_76366_f, 2.0f);
        }
        if (this.isSpawning() && this.spawnTime > 0 && --this.spawnTime <= 0) {
            this.setSpawning(false);
        }
        if (this.isSpawning() && this.field_70170_p.func_201670_d()) {
            int i = MathHelper.func_76128_c((double)this.func_226277_ct_());
            int j = MathHelper.func_76128_c((double)(this.func_226278_cu_() - (double)0.2f));
            int k = MathHelper.func_76128_c((double)this.func_226281_cx_());
            BlockPos pos = new BlockPos(i, j, k);
            BlockState blockstate = this.field_70170_p.func_180495_p(pos);
            if (!this.field_70170_p.func_175623_d(pos)) {
                for (int count = 0; count < 10; ++count) {
                    this.field_70170_p.func_195594_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, blockstate).setPos(pos), this.func_226277_ct_() + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.func_213311_cf(), this.func_226278_cu_() + 0.1, this.func_226281_cx_() + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.func_213311_cf(), 4.0 * ((double)this.field_70146_Z.nextFloat() - 0.5), 0.6, ((double)this.field_70146_Z.nextFloat() - 0.5) * 4.0);
                }
            }
        }
    }

    public void setEquipmentOnSpawn() {
        this.func_184611_a(Hand.MAIN_HAND, new ItemStack((IItemProvider)Items.field_151040_l));
        this.func_184642_a(EquipmentSlotType.MAINHAND, 0.0f);
    }

    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        ILivingEntityData data = super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.setEquipmentOnSpawn();
        this.setSpawning(true);
        this.func_82227_f(false);
        return data;
    }

    public void setSpawning(boolean spawning) {
        this.spawnTime = spawning ? 60 : 0;
        this.func_184212_Q().func_187227_b(SPAWNING, (Object)spawning);
        this.func_213323_x_();
        if (spawning && !this.field_70170_p.func_201670_d()) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)11);
        }
    }

    public boolean isSpawning() {
        return this.spawnTime > 0 || (Boolean)this.func_184212_Q().func_187225_a(SPAWNING) != false;
    }

    public float getSpawnPercent() {
        return this.spawnTime > 0 ? 1.0f - (float)this.spawnTime / 60.0f : 1.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        switch (id) {
            case 11: {
                this.setSpawning(true);
                break;
            }
            default: {
                super.func_70103_a(id);
            }
        }
    }

    public void setLimitedLife(int life) {
        this.limitedLifespan = true;
        this.limitedLifeTicks = life;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187854_fc;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundEvents.field_187864_fh;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187856_fd;
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(SoundEvents.field_187868_fj, 0.15f, 1.0f);
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return this.isSpawning() ? this.spawningSize : super.func_213305_a(poseIn);
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223223_b_;
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return !this.func_70909_n();
    }

    protected float func_213348_b(Pose pose, EntitySize size) {
        return this.isSpawning() ? 0.05f : 1.74f;
    }

    public double func_70033_W() {
        return -0.6;
    }

    public boolean func_184652_a(PlayerEntity player) {
        return false;
    }

    public boolean func_70878_b(AnimalEntity otherAnimal) {
        return false;
    }

    public AgeableEntity func_241840_a(ServerWorld world, AgeableEntity mate) {
        return null;
    }

    public void func_233687_w_(boolean sitting) {
    }

    public void func_70645_a(DamageSource cause) {
        this.func_184754_b(null);
        super.func_70645_a(cause);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a(KEY_SPAWN_TIME, this.isSpawning());
        if (this.limitedLifespan) {
            compound.func_74768_a(KEY_LIFE_TICKS, this.limitedLifeTicks);
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setSpawning(compound.func_74767_n(KEY_SPAWN_TIME));
        if (compound.func_74764_b(KEY_LIFE_TICKS)) {
            this.setLimitedLife(compound.func_74762_e(KEY_LIFE_TICKS));
        }
    }

    public boolean func_213336_c(LivingEntity entity) {
        if (this.func_152114_e(entity)) {
            return false;
        }
        return super.func_213336_c(entity);
    }

    public boolean func_142018_a(LivingEntity target, LivingEntity owner) {
        if (!(target instanceof CreeperEntity) && !(target instanceof GhastEntity)) {
            if (target instanceof TameableEntity) {
                TameableEntity tameable = (TameableEntity)target;
                return !tameable.func_70909_n() || tameable.func_70902_q() != owner;
            }
            if (target instanceof PlayerEntity && owner instanceof PlayerEntity && !((PlayerEntity)owner).func_96122_a((PlayerEntity)target)) {
                return false;
            }
            if (target instanceof AbstractHorseEntity && ((AbstractHorseEntity)target).func_110248_bS()) {
                return false;
            }
            return !(target instanceof TameableEntity) || !((TameableEntity)target).func_70909_n();
        }
        return false;
    }

    class SpawningGoal
    extends Goal {
        public SpawningGoal() {
            this.func_220684_a(EnumSet.allOf(Goal.Flag.class));
        }

        public boolean func_75250_a() {
            return SpartiEntity.this.isSpawning();
        }

        public void func_75246_d() {
            SpartiEntity.this.func_70661_as().func_75499_g();
        }
    }
}

