/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.entity;

import greekfantasy.GFRegistry;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.BossInfo;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerBossInfo;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TalosEntity
extends MonsterEntity
implements IRangedAttackMob {
    private static final DataParameter<Byte> STATE = EntityDataManager.func_187226_a(TalosEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final String KEY_STATE = "TalosState";
    private static final String KEY_SPAWN = "SpawnTime";
    private static final String KEY_SHOOT = "ShootTime";
    private static final String KEY_COOLDOWN = "AttackCooldown";
    private static final byte NONE = 0;
    private static final byte SPAWNING = 1;
    private static final byte SHOOT = 2;
    private static final byte SPAWN_CLIENT = 8;
    private static final byte SHOOT_CLIENT = 9;
    private static final int MAX_SPAWN_TIME = 94;
    private static final int MAX_SHOOT_TIME = 80;
    private static final int SHOOT_COOLDOWN = 188;
    private static final int MELEE_COOLDOWN = 40;
    private final ServerBossInfo bossInfo = (ServerBossInfo)new ServerBossInfo(this.func_145748_c_(), BossInfo.Color.RED, BossInfo.Overlay.PROGRESS).func_186741_a(true);
    private int spawnTime;
    private int shootTime;
    private int attackCooldown;

    public TalosEntity(EntityType<? extends TalosEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70138_W = 1.0f;
        this.field_70728_aV = 50;
    }

    public static AttributeModifierMap.MutableAttribute getAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 150.0).func_233815_a_(Attributes.field_233821_d_, 0.21).func_233815_a_(Attributes.field_233820_c_, 1.0).func_233815_a_(Attributes.field_233819_b_, 48.0).func_233815_a_(Attributes.field_233823_f_, 9.0).func_233815_a_(Attributes.field_233824_g_, 1.35).func_233815_a_(Attributes.field_233826_i_, 8.0);
    }

    public static TalosEntity spawnTalos(World world, BlockPos pos, float yaw) {
        TalosEntity entity = (TalosEntity)GFRegistry.TALOS_ENTITY.func_200721_a(world);
        entity.func_70012_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.1, (double)pos.func_177952_p() + 0.5, yaw, 0.0f);
        entity.field_70761_aq = yaw;
        world.func_217376_c((Entity)entity);
        entity.setSpawning(true);
        for (ServerPlayerEntity player : world.func_217357_a(ServerPlayerEntity.class, entity.func_174813_aQ().func_186662_g(25.0))) {
            CriteriaTriggers.field_192133_m.func_192229_a(player, (Entity)entity);
        }
        world.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187855_gD, entity.func_184176_by(), 1.2f, 1.0f, false);
        return entity;
    }

    public void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(STATE, (Object)0);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new SpawningGoal());
        this.field_70714_bg.func_75776_a(1, (Goal)new RangedAttackGoal(4, 25.0f));
        this.field_70714_bg.func_75776_a(3, (Goal)new MeleeAttackGoal(1.0, false));
        this.field_70714_bg.func_75776_a(5, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 10.0f));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, false));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, IronGolemEntity.class, false));
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
        this.attackCooldown = Math.max(this.attackCooldown - 1, 0);
        if ((this.isSpawning() || this.spawnTime > 0) && --this.spawnTime <= 0) {
            this.setSpawning(false);
        }
        if ((this.isShooting() || this.shootTime > 0) && this.shootTime++ >= 80) {
            this.setShooting(false);
            this.shootTime = 0;
        }
        if (TalosEntity.func_213296_b((Vector3d)this.func_213322_ci()) > 2.500000277905201E-7 && this.field_70146_Z.nextInt(3) == 0) {
            int i = MathHelper.func_76128_c((double)this.func_226277_ct_());
            int j = MathHelper.func_76128_c((double)(this.func_226278_cu_() - (double)0.2f));
            int k = MathHelper.func_76128_c((double)this.func_226281_cx_());
            BlockPos pos = new BlockPos(i, j, k);
            BlockState blockstate = this.field_70170_p.func_180495_p(pos);
            if (!this.field_70170_p.func_175623_d(pos)) {
                BlockParticleData data = new BlockParticleData(ParticleTypes.field_197611_d, blockstate).setPos(pos);
                double radius = this.func_213311_cf();
                double motion = 4.0;
                this.field_70170_p.func_195594_a((IParticleData)data, this.func_226277_ct_() + (this.field_70146_Z.nextDouble() - 0.5) * radius * 2.0, this.func_226278_cu_() + 0.1, this.func_226281_cx_() + (this.field_70146_Z.nextDouble() - 0.5) * radius * 2.0, 4.0 * (this.field_70146_Z.nextDouble() - 0.5), 0.45, (this.field_70146_Z.nextDouble() - 0.5) * 4.0);
            }
        }
    }

    public boolean func_70652_k(Entity entityIn) {
        if (super.func_70652_k(entityIn)) {
            double knockbackFactor = 0.92;
            Vector3d myPos = this.func_213303_ch();
            Vector3d ePos = entityIn.func_213303_ch();
            double dX = Math.signum(ePos.field_72450_a - myPos.field_72450_a) * 0.92;
            double dZ = Math.signum(ePos.field_72449_c - myPos.field_72449_c) * 0.92;
            entityIn.func_70024_g(dX, 0.46, dZ);
            entityIn.field_70133_I = true;
            this.func_184185_a(SoundEvents.field_187596_cD, 1.0f, 0.6f + this.field_70146_Z.nextFloat() * 0.2f);
            return true;
        }
        return false;
    }

    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        ILivingEntityData data = super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.setSpawning(true);
        return data;
    }

    protected float func_175134_bD() {
        return 0.42f * this.func_226269_ah_();
    }

    public boolean func_70104_M() {
        return false;
    }

    public void func_85033_bc() {
    }

    public boolean func_184222_aU() {
        return false;
    }

    public boolean func_213397_c(double disToPlayer) {
        return false;
    }

    protected boolean func_184228_n(Entity entityIn) {
        return false;
    }

    public boolean func_180431_b(DamageSource source) {
        return this.isSpawning() || source.func_82725_o() || source == DamageSource.field_76369_e || source == DamageSource.field_76368_d || source == DamageSource.field_82727_n || source.func_76364_f() instanceof AbstractArrowEntity || super.func_180431_b(source);
    }

    public int func_70627_aG() {
        return 280;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187594_A;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187602_cF;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187599_cE;
    }

    protected float func_70599_aP() {
        return 1.8f;
    }

    protected float func_70647_i() {
        return 0.6f + this.field_70146_Z.nextFloat() * 0.25f;
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74774_a(KEY_STATE, this.getState());
        compound.func_74768_a(KEY_SPAWN, this.spawnTime);
        compound.func_74768_a(KEY_SHOOT, this.shootTime);
        compound.func_74768_a(KEY_COOLDOWN, this.attackCooldown);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setState(compound.func_74771_c(KEY_STATE));
        this.spawnTime = compound.func_74762_e(KEY_SPAWN);
        this.shootTime = compound.func_74762_e(KEY_SHOOT);
        this.attackCooldown = compound.func_74762_e(KEY_COOLDOWN);
    }

    public byte getState() {
        return (Byte)this.func_184212_Q().func_187225_a(STATE);
    }

    public void setState(byte state) {
        this.func_184212_Q().func_187227_b(STATE, (Object)state);
    }

    public boolean isNoneState() {
        return this.getState() == 0;
    }

    public boolean isSpawning() {
        return this.spawnTime > 0 || this.getState() == 1;
    }

    public void setShooting(boolean shoot) {
        this.setState(shoot ? (byte)2 : 0);
    }

    public boolean isShooting() {
        return this.getState() == 2;
    }

    public void setSpawning(boolean spawning) {
        this.spawnTime = spawning ? 94 : 0;
        this.setState(spawning ? (byte)1 : 0);
        if (spawning && !this.field_70170_p.func_201670_d()) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)8);
        }
    }

    public void setAttackCooldown(int cooldown) {
        this.attackCooldown = cooldown;
    }

    public boolean hasNoCooldown() {
        return this.attackCooldown <= 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        switch (id) {
            case 8: {
                this.setSpawning(true);
                break;
            }
            case 9: {
                this.shootTime = 1;
                this.func_184185_a(SoundEvents.field_187901_ga, 1.1f, 1.0f);
                break;
            }
            default: {
                super.func_70103_a(id);
            }
        }
    }

    public float getSpawnPercent(float partialTick) {
        if (this.spawnTime <= 0) {
            return 1.0f;
        }
        float prevSpawnPercent = Math.max((float)this.spawnTime - partialTick, 0.0f) / 94.0f;
        float spawnPercent = (float)this.spawnTime / 94.0f;
        return 1.0f - MathHelper.func_219799_g((float)(partialTick / 6.0f), (float)prevSpawnPercent, (float)spawnPercent);
    }

    public void func_82196_d(LivingEntity target, float distanceFactor) {
        if (this.field_70170_p.func_201670_d() || !this.isShooting() || this.shootTime < 20) {
            return;
        }
        ItemStack itemstack = new ItemStack((IItemProvider)Items.field_151032_g);
        AbstractArrowEntity arrow = ProjectileHelper.func_221272_a((LivingEntity)this, (ItemStack)itemstack, (float)distanceFactor);
        arrow.func_70107_b(this.func_226277_ct_() - (double)this.func_213311_cf() * 0.85 * (double)MathHelper.func_76126_a((float)(this.field_70761_aq * ((float)Math.PI / 180) + 1.0f)), this.func_226280_cw_() - 0.74, this.func_226281_cx_() + (double)this.func_213311_cf() * 0.85 * (double)MathHelper.func_76134_b((float)(this.field_70761_aq * ((float)Math.PI / 180) + 1.0f)));
        double dx = target.func_226277_ct_() - arrow.func_226277_ct_();
        double dy = target.func_226283_e_(0.67) - arrow.func_226278_cu_();
        double dz = target.func_226281_cx_() - arrow.func_226281_cx_();
        double dis = MathHelper.func_76133_a((double)(dx * dx + dz * dz));
        arrow.func_70186_c(dx, dy + dis * (double)0.2f, dz, 1.6f, (float)(14 - this.field_70170_p.func_175659_aa().func_151525_a() * 4));
        arrow.func_70239_b(1.0 + (double)this.field_70170_p.func_175659_aa().func_151525_a() * 0.25);
        arrow.func_212361_a((Entity)this);
        this.func_184185_a(SoundEvents.field_187737_v, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_217376_c((Entity)arrow);
    }

    public void func_184178_b(ServerPlayerEntity player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(ServerPlayerEntity player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    class MeleeAttackGoal
    extends net.minecraft.entity.ai.goal.MeleeAttackGoal {
        public MeleeAttackGoal(double speedIn, boolean useLongMemory) {
            super((CreatureEntity)TalosEntity.this, speedIn, useLongMemory);
        }

        protected void func_190102_a(LivingEntity enemy, double distToEnemySqr) {
            if (TalosEntity.this.hasNoCooldown()) {
                super.func_190102_a(enemy, distToEnemySqr);
            }
        }

        protected void func_234039_g_() {
            super.func_234039_g_();
            TalosEntity.this.setAttackCooldown(40);
        }
    }

    class RangedAttackGoal
    extends net.minecraft.entity.ai.goal.RangedAttackGoal {
        public RangedAttackGoal(int interval, float attackDistance) {
            super((IRangedAttackMob)TalosEntity.this, 1.0, interval, attackDistance);
        }

        public boolean func_75250_a() {
            LivingEntity target = TalosEntity.this.func_70638_az();
            double disSq = target != null ? TalosEntity.this.func_70068_e((Entity)target) : 0.0;
            return TalosEntity.this.isNoneState() && TalosEntity.this.hasNoCooldown() && disSq > 9.0 && super.func_75250_a();
        }

        public void func_75249_e() {
            super.func_75249_e();
            TalosEntity.this.setAttackCooldown(188);
            TalosEntity.this.setShooting(true);
            TalosEntity.this.field_70170_p.func_72960_a((Entity)TalosEntity.this, (byte)9);
            TalosEntity.this.shootTime = 1;
        }

        public boolean func_75253_b() {
            return TalosEntity.this.shootTime > 0 && TalosEntity.this.isShooting();
        }

        public void func_75246_d() {
            super.func_75246_d();
        }

        public void func_75251_c() {
            TalosEntity.this.setState((byte)0);
            TalosEntity.this.shootTime = 0;
            super.func_75251_c();
        }
    }

    class SpawningGoal
    extends Goal {
        public SpawningGoal() {
            this.func_220684_a(EnumSet.allOf(Goal.Flag.class));
        }

        public boolean func_75250_a() {
            return TalosEntity.this.isSpawning();
        }

        public void func_75246_d() {
            TalosEntity.this.func_70661_as().func_75499_g();
            TalosEntity.this.func_70671_ap().func_220679_a(TalosEntity.this.func_226277_ct_(), TalosEntity.this.func_226278_cu_(), TalosEntity.this.func_226281_cx_());
            TalosEntity.this.func_70101_b(0.0f, 0.0f);
        }
    }
}

