/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.entity;

import greekfantasy.GFRegistry;
import greekfantasy.GreekFantasy;
import greekfantasy.entity.CharybdisEntity;
import greekfantasy.entity.misc.ISwimmingMob;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.passive.WaterMobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.loot.LootTables;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.DamageSource;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.Tags;

public class WhirlEntity
extends WaterMobEntity
implements ISwimmingMob {
    protected static final Tags.IOptionalNamedTag<Item> TRIGGER = ItemTags.createOptional((ResourceLocation)new ResourceLocation("greekfantasy", "charybdis_trigger"));
    protected static final DataParameter<Boolean> ATTRACT_MOBS = EntityDataManager.func_187226_a(WhirlEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    protected static final String KEY_AFFECTS_MOBS = "AttractMobs";
    protected static final String KEY_LIFE_TICKS = "LifeTicks";
    private static final double RANGE = 9.0;
    private boolean swimmingUp;
    protected boolean limitedLifespan;
    protected int limitedLifeTicks;

    public WhirlEntity(EntityType<? extends WhirlEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70728_aV = 5;
    }

    public static boolean canWhirlSpawnOn(EntityType<? extends WaterMobEntity> entity, IWorld world, SpawnReason reason, BlockPos pos, Random rand) {
        if (pos.func_177956_o() <= 25 || pos.func_177956_o() >= world.func_181545_F()) {
            return false;
        }
        RegistryKey biome = world.func_242406_i(pos).orElse(Biomes.field_76772_c);
        return BiomeDictionary.hasType((RegistryKey)biome, (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN) && world.func_204610_c(pos).func_206884_a((ITag)FluidTags.field_206959_a);
    }

    public static AttributeModifierMap.MutableAttribute getAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 10.0).func_233815_a_(Attributes.field_233821_d_, 0.15).func_233815_a_(Attributes.field_233823_f_, 0.25).func_233815_a_(Attributes.field_233820_c_, 1.0).func_233815_a_(Attributes.field_233819_b_, 32.0);
    }

    public void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(ATTRACT_MOBS, (Object)false);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimToSurfaceGoal());
        this.field_70714_bg.func_75776_a(2, (Goal)new SwirlGoal(this, 1000, 0, 9.0));
    }

    public void func_70636_d() {
        super.func_70636_d();
        List waterMobList = this.field_70170_p.func_175647_a(WaterMobEntity.class, this.func_174813_aQ().func_186662_g(1.0), e -> e != this && e.func_70089_S() && (e.func_200600_R() == GFRegistry.CHARYBDIS_ENTITY || e.func_200600_R() == GFRegistry.WHIRL_ENTITY));
        if (!waterMobList.isEmpty() && this.func_70089_S()) {
            this.func_70097_a(DamageSource.field_76366_f, this.func_110138_aP() * 2.0f);
            return;
        }
        if (this.limitedLifespan && --this.limitedLifeTicks <= 0) {
            this.limitedLifeTicks = 20;
            this.func_70606_j(this.func_110143_aJ() - 1.0f);
        }
        List itemEntityList = this.field_70170_p.func_217394_a(EntityType.field_200765_E, this.func_174813_aQ().func_186662_g(1.0), e -> e.func_203005_aq() && this.func_226278_cu_() + (double)this.func_213302_cg() > e.func_226278_cu_());
        for (ItemEntity e2 : itemEntityList) {
            if (this.func_130014_f_() instanceof ServerWorld && !e2.func_92059_d().func_190926_b() && e2.func_92059_d().func_77973_b().func_206844_a(TRIGGER)) {
                CharybdisEntity.spawnCharybdis((ServerWorld)this.func_130014_f_(), this);
                e2.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), 1.0f);
            }
            if (!e2.func_174874_s()) {
                e2.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), 1.0f);
            }
            if (e2.func_70089_S()) continue;
            this.func_184185_a(SoundEvents.field_187664_bz, 0.6f, 0.8f + this.func_70681_au().nextFloat() * 0.4f);
        }
        if (this.field_70170_p.func_201670_d() && this.field_70173_aa % 3 == 0 && this.func_203005_aq()) {
            float maxY = this.func_213302_cg() * 1.65f;
            float y = 0.0f;
            float nY = 90.0f;
            float dY = maxY / nY;
            double posX = this.func_226277_ct_();
            double posY = this.func_226278_cu_();
            double posZ = this.func_226281_cx_();
            float a = 0.0f;
            float nA = 28 + this.field_70146_Z.nextInt(4);
            float dA = (float)Math.PI * 2 / nA;
            while (y < maxY) {
                float radius = y * 0.35f;
                float cosA = MathHelper.func_76134_b((float)a) * radius;
                float sinA = MathHelper.func_76126_a((float)a) * radius;
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197612_e, posX + (double)cosA, posY + (double)y - (double)maxY * 0.4, posZ + (double)sinA, 0.0, 0.085, 0.0);
                y += dY;
                a += dA;
            }
        }
    }

    protected void func_82167_n(Entity entityIn) {
        super.func_82167_n(entityIn);
    }

    protected boolean func_225511_J_() {
        return true;
    }

    protected boolean func_184228_n(Entity entityIn) {
        return false;
    }

    public boolean func_180431_b(DamageSource source) {
        return GreekFantasy.CONFIG.isWhirlInvulnerable() || !source.func_180136_u() && !source.func_151517_h() && this.limitedLifespan || super.func_180431_b(source);
    }

    protected void func_70665_d(DamageSource source, float amountIn) {
        float amount = amountIn;
        if (!source.func_151517_h() && this.getAttractMobs()) {
            amount *= 0.25f;
        }
        super.func_70665_d(source, amount);
    }

    public boolean func_70104_M() {
        return false;
    }

    protected void func_85033_bc() {
    }

    public void setAttractMobs(boolean attractsMobs) {
        this.func_184212_Q().func_187227_b(ATTRACT_MOBS, (Object)attractsMobs);
    }

    public boolean getAttractMobs() {
        return (Boolean)this.func_184212_Q().func_187225_a(ATTRACT_MOBS);
    }

    public void setLimitedLife(int life) {
        this.limitedLifespan = true;
        this.limitedLifeTicks = life;
    }

    public ResourceLocation func_184647_J() {
        return this.limitedLifespan ? LootTables.field_186419_a : super.func_184647_J();
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a(KEY_AFFECTS_MOBS, this.getAttractMobs());
        if (this.limitedLifespan) {
            compound.func_74768_a(KEY_LIFE_TICKS, this.limitedLifeTicks);
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setAttractMobs(compound.func_74767_n(KEY_AFFECTS_MOBS));
        if (compound.func_74764_b(KEY_LIFE_TICKS)) {
            this.setLimitedLife(compound.func_74762_e(KEY_LIFE_TICKS));
        }
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187591_cB;
    }

    protected float func_70599_aP() {
        return 0.8f;
    }

    protected float func_70647_i() {
        return 0.8f + this.field_70146_Z.nextFloat() * 0.2f;
    }

    @Override
    public void setSwimmingUp(boolean swimmingUp) {
        this.swimmingUp = swimmingUp;
    }

    @Override
    public boolean isSwimmingUp() {
        return this.swimmingUp;
    }

    public void func_213352_e(Vector3d vec) {
        if (this.func_70613_aW() && this.func_70090_H() && this.isSwimmingUpCalculated()) {
            this.func_213309_a(0.01f, vec);
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.9));
        } else {
            super.func_213352_e(vec);
        }
    }

    public boolean func_96092_aw() {
        return false;
    }

    @Override
    public boolean isSwimmingUpCalculated() {
        if (this.swimmingUp) {
            return true;
        }
        LivingEntity e = this.func_70638_az();
        return e != null && e.func_70090_H();
    }

    private static class SwirlGoal
    extends greekfantasy.entity.ai.SwirlGoal<WhirlEntity> {
        public SwirlGoal(WhirlEntity entity, int lDuration, int lCooldown, double lRange) {
            super(entity, lDuration, lCooldown, lRange, false);
        }

        @Override
        protected void onCollideWith(Entity e) {
            if (((WhirlEntity)this.entity).getAttractMobs() && e instanceof LivingEntity) {
                e.func_70097_a(DamageSource.func_76358_a((LivingEntity)this.entity), 1.0f);
            }
        }

        @Override
        protected boolean canSwirl(Entity e) {
            return target.test(e) && (e instanceof LivingEntity && ((WhirlEntity)this.entity).getAttractMobs() || e instanceof ItemEntity) && (!(e instanceof PlayerEntity) || !GreekFantasy.PROXY.getFavorConfiguration().getEnchantmentRange("lord_of_the_sea_enchantment").isInFavorRange((PlayerEntity)e));
        }
    }

    class SwimToSurfaceGoal
    extends SwimGoal {
        public SwimToSurfaceGoal() {
            super((MobEntity)WhirlEntity.this);
        }

        public boolean func_75250_a() {
            BlockPos pos = WhirlEntity.this.func_233580_cy_().func_177981_b((int)Math.ceil(WhirlEntity.this.func_213302_cg()));
            BlockState state = WhirlEntity.this.field_70170_p.func_180495_p(pos);
            return state.func_177230_c() == Blocks.field_150355_j && super.func_75250_a();
        }
    }
}

