/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.entity.ai;

import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;

public class EffectGoal<T extends LivingEntity>
extends Goal {
    protected final T entity;
    protected final Supplier<Effect> effect;
    protected final int minLength;
    protected final int maxLength;
    protected final int minAmplifier;
    protected final int maxAmplifier;
    protected final Predicate<T> shouldApply;

    public EffectGoal(T entityIn, Supplier<Effect> supplierIn, int minLen, int maxLen, int minAmp, int maxAmp, Predicate<T> applyWhen) {
        this.entity = entityIn;
        this.effect = supplierIn;
        this.minLength = Math.min(minLen, maxLen);
        this.maxLength = Math.max(minLen, maxLen);
        this.minAmplifier = Math.min(minAmp, maxAmp);
        this.maxAmplifier = Math.max(minAmp, maxAmp);
        this.shouldApply = applyWhen;
    }

    public boolean func_75250_a() {
        return this.shouldApply.test(this.entity);
    }

    public void func_75249_e() {
        int len = this.minLength != this.maxLength ? this.minLength + this.entity.func_70681_au().nextInt(this.maxLength - this.minLength + 1) : this.minLength;
        int amp = this.minAmplifier != this.maxAmplifier ? this.minAmplifier + this.entity.func_70681_au().nextInt(this.maxAmplifier - this.minAmplifier + 1) : this.minAmplifier;
        this.entity.func_195064_c(new EffectInstance(this.effect.get(), len, amp));
    }

    public static <E extends LivingEntity> Predicate<E> randomPredicate(int chance) {
        int c = Math.max(1, chance);
        return e -> e.func_70681_au().nextInt(c) == 0;
    }

    public static <E extends LivingEntity> Predicate<E> hasNoEffectPredicate(Effect effect) {
        return e -> e.func_70660_b(effect) == null;
    }
}

