/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.entity.ai;

import java.util.EnumSet;
import java.util.Optional;
import java.util.Random;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IWorldReader;

public abstract class FindBlockGoal
extends Goal {
    protected final CreatureEntity creature;
    protected final int searchRadiusXZ;
    protected final int searchRadiusY;
    protected final int maxCooldown;
    protected int cooldown;
    protected Optional<BlockPos> targetPos = Optional.empty();

    public FindBlockGoal(CreatureEntity entity, int radius, int cooldown) {
        this(entity, radius, Math.max(1, radius / 2), cooldown);
    }

    public FindBlockGoal(CreatureEntity entity, int radiusXZ, int radiusY, int cooldownIn) {
        this.func_220684_a(EnumSet.noneOf(Goal.Flag.class));
        this.creature = entity;
        this.searchRadiusXZ = radiusXZ;
        this.searchRadiusY = radiusY;
        this.maxCooldown = cooldownIn;
        this.cooldown = 10;
    }

    public boolean func_75250_a() {
        if (this.cooldown > 0) {
            --this.cooldown;
        } else {
            if (this.isOnBlock() || this.isNearTarget(1.2)) {
                return false;
            }
            this.targetPos = this.findNearbyBlock();
            return this.targetPos.isPresent();
        }
        return false;
    }

    public boolean func_75253_b() {
        return false;
    }

    public void func_75249_e() {
        this.cooldown = this.maxCooldown;
        this.onFoundBlock((IWorldReader)this.creature.func_130014_f_(), this.targetPos.get());
    }

    public abstract boolean isTargetBlock(IWorldReader var1, BlockPos var2);

    public abstract void onFoundBlock(IWorldReader var1, BlockPos var2);

    protected boolean isOnBlock() {
        return this.isTargetBlock((IWorldReader)this.creature.func_130014_f_(), this.creature.func_233580_cy_());
    }

    protected boolean isNearTarget(double distance) {
        return this.targetPos.isPresent() && Vector3d.func_237492_c_((Vector3i)((Vector3i)this.targetPos.get())).func_237488_a_((IPosition)this.creature.func_213303_ch(), distance);
    }

    protected Optional<BlockPos> findNearbyBlock() {
        Random rand = this.creature.func_70681_au();
        BlockPos pos1 = this.creature.func_233580_cy_().func_177977_b();
        for (int i = 0; i < 20; ++i) {
            BlockPos pos2 = pos1.func_177982_a(rand.nextInt(this.searchRadiusXZ * 2) - this.searchRadiusXZ, rand.nextInt(this.searchRadiusY * 2) - this.searchRadiusY, rand.nextInt(this.searchRadiusXZ * 2) - this.searchRadiusXZ);
            if (!this.isTargetBlock((IWorldReader)this.creature.func_130014_f_(), pos2)) continue;
            return Optional.of(new BlockPos(pos2.func_177958_n(), pos2.func_177956_o(), pos2.func_177952_p()));
        }
        return Optional.empty();
    }
}

