/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.entity.ai;

import greekfantasy.entity.misc.IHasOwner;
import java.util.EnumSet;
import net.minecraft.block.BlockState;
import net.minecraft.block.LeavesBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.WalkNodeProcessor;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;

public class HasOwnerFollowGoal<T extends MobEntity>
extends Goal {
    private final T entity;
    private LivingEntity owner;
    private final IWorldReader world;
    private final double followSpeed;
    private final PathNavigator navigator;
    private int timeToRecalcPath;
    private final float closeDist;
    private final float farDist;
    private float oldWaterCost;
    private final boolean teleportToLeaves;

    public HasOwnerFollowGoal(T entityIn, double followSpeedIn, float farDistance, float closeDistance, boolean teleportToLeavesIn) {
        this.entity = entityIn;
        this.world = ((MobEntity)entityIn).field_70170_p;
        this.followSpeed = followSpeedIn;
        this.navigator = entityIn.func_70661_as();
        this.farDist = farDistance;
        this.closeDist = closeDistance;
        this.teleportToLeaves = teleportToLeavesIn;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean func_75250_a() {
        LivingEntity owner = ((IHasOwner)this.entity).getOwner();
        if (owner == null) {
            return false;
        }
        if (owner.func_175149_v() || this.entity.func_70068_e((Entity)owner) < (double)(this.farDist * this.farDist)) {
            return false;
        }
        this.owner = owner;
        return true;
    }

    public boolean func_75253_b() {
        if (this.navigator.func_75500_f()) {
            return false;
        }
        return !(this.entity.func_70068_e((Entity)this.owner) <= (double)(this.closeDist * this.closeDist));
    }

    public void func_75249_e() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.entity.func_184643_a(PathNodeType.WATER);
        this.entity.func_184644_a(PathNodeType.WATER, 0.0f);
    }

    public void func_75251_c() {
        this.owner = null;
        this.navigator.func_75499_g();
        this.entity.func_184644_a(PathNodeType.WATER, this.oldWaterCost);
    }

    public void func_75246_d() {
        this.entity.func_70671_ap().func_75651_a((Entity)this.owner, 10.0f, (float)this.entity.func_70646_bf());
        if (--this.timeToRecalcPath > 0) {
            return;
        }
        this.timeToRecalcPath = 10;
        if (this.entity.func_110167_bD() || this.entity.func_184218_aH()) {
            return;
        }
        if (this.entity.func_70068_e((Entity)this.owner) >= (double)(4.0f * (this.farDist * this.farDist))) {
            this.tryToTeleportNearEntity();
        } else {
            this.navigator.func_75497_a((Entity)this.owner, this.followSpeed);
        }
    }

    private void tryToTeleportNearEntity() {
        BlockPos ownerPos = this.owner.func_233580_cy_();
        for (int attempts = 0; attempts < 10; ++attempts) {
            int x = this.getRandomNumber(-3, 3);
            int y = this.getRandomNumber(-1, 1);
            int z = this.getRandomNumber(-3, 3);
            boolean teleportSuccess = this.tryToTeleportToLocation(ownerPos.func_177958_n() + x, ownerPos.func_177956_o() + y, ownerPos.func_177952_p() + z);
            if (!teleportSuccess) continue;
            return;
        }
    }

    private boolean tryToTeleportToLocation(int x, int y, int z) {
        if (Math.abs((double)x - this.owner.func_226277_ct_()) < 2.0 && Math.abs((double)z - this.owner.func_226281_cx_()) < 2.0) {
            return false;
        }
        if (!this.isTeleportFriendlyBlock(new BlockPos(x, y, z))) {
            return false;
        }
        this.entity.func_70012_b((double)x + 0.5, (double)y, (double)z + 0.5, ((MobEntity)this.entity).field_70177_z, ((MobEntity)this.entity).field_70125_A);
        this.navigator.func_75499_g();
        return true;
    }

    private boolean isTeleportFriendlyBlock(BlockPos pos) {
        PathNodeType pathType = WalkNodeProcessor.func_237231_a_((IBlockReader)this.world, (BlockPos.Mutable)pos.func_239590_i_());
        if (pathType != PathNodeType.WALKABLE) {
            return false;
        }
        BlockState posDown = this.world.func_180495_p(pos.func_177977_b());
        if (!this.teleportToLeaves && posDown.func_177230_c() instanceof LeavesBlock) {
            return false;
        }
        BlockPos distance = pos.func_177973_b((Vector3i)this.entity.func_233580_cy_());
        return this.world.func_226665_a__(this.entity, this.entity.func_174813_aQ().func_186670_a(distance));
    }

    private int getRandomNumber(int min, int max) {
        return this.entity.func_70681_au().nextInt(max - min + 1) + min;
    }
}

