/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.entity.ai;

import java.util.EnumSet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;

public class IntervalRangedAttackGoal
extends Goal {
    protected IRangedAttackMob rangedEntity;
    protected MobEntity entity;
    protected int goalTime;
    protected int maxTime;
    protected int maxCooldown;
    protected int interval;
    protected int cooldown;

    public IntervalRangedAttackGoal(IRangedAttackMob entityIn, int duration, int count, int maxCooldownIn) {
        if (!(entityIn instanceof MobEntity)) {
            throw new IllegalArgumentException("IntervalRangedAttackGoal requires MobEntity that implements IRangedAttackMob");
        }
        this.func_220684_a(EnumSet.allOf(Goal.Flag.class));
        this.rangedEntity = entityIn;
        this.entity = (MobEntity)entityIn;
        this.maxTime = duration;
        this.maxCooldown = maxCooldownIn;
        this.cooldown = 30;
        this.interval = Math.floorDiv(Math.max(count, duration - 20), count);
    }

    public boolean func_75250_a() {
        if (this.cooldown > 0) {
            --this.cooldown;
        } else if (this.entity.func_70638_az() != null && this.entity.func_70685_l((Entity)this.entity.func_70638_az()) && this.isWithinRange(this.entity.func_70638_az())) {
            return true;
        }
        return false;
    }

    public boolean func_75253_b() {
        return this.goalTime > 0 && this.entity.func_70638_az() != null && this.entity.func_70685_l((Entity)this.entity.func_70638_az()) && this.isWithinRange(this.entity.func_70638_az());
    }

    public void func_75249_e() {
        this.goalTime = 1;
        this.entity.func_213395_q(true);
    }

    public void func_75246_d() {
        LivingEntity target = this.entity.func_70638_az();
        this.entity.func_70661_as().func_75499_g();
        this.entity.func_70625_a((Entity)target, 100.0f, 100.0f);
        this.entity.func_70671_ap().func_75651_a((Entity)target, 100.0f, 100.0f);
        if (this.goalTime % this.interval == 0) {
            this.rangedEntity.func_82196_d(target, 0.1f);
        }
        if (this.goalTime++ >= this.maxTime) {
            this.func_75251_c();
        }
    }

    public void func_75251_c() {
        this.entity.func_213395_q(false);
        this.goalTime = 0;
        this.cooldown = this.maxCooldown;
    }

    protected boolean isWithinRange(LivingEntity target) {
        if (target != null) {
            double disSq = this.entity.func_70068_e((Entity)target);
            double maxRange = this.entity.func_233637_b_(Attributes.field_233819_b_) * 0.75;
            return disSq > 9.0 && disSq < maxRange * maxRange;
        }
        return false;
    }
}

