/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.entity.ai;

import java.util.EnumSet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.vector.Vector3d;

public class ShootFireGoal
extends Goal {
    private final MobEntity entity;
    private final int maxCooldown;
    private final int maxShootFireTime;
    private final double fireRange;
    private int fireBreathingTime;
    private int cooldown;

    protected ShootFireGoal(MobEntity entityIn, int fireTimeIn, int maxCooldownIn, double fireRangeIn) {
        this.func_220684_a(EnumSet.allOf(Goal.Flag.class));
        this.entity = entityIn;
        this.maxShootFireTime = fireTimeIn;
        this.fireRange = fireRangeIn;
        this.maxCooldown = maxCooldownIn;
        this.cooldown = 30;
    }

    public boolean func_75250_a() {
        if (this.cooldown > 0) {
            --this.cooldown;
        } else if (this.entity.func_70638_az() != null && this.entity.func_70068_e((Entity)this.entity.func_70638_az()) < this.fireRange * this.fireRange && this.entity.func_70685_l((Entity)this.entity.func_70638_az())) {
            return true;
        }
        return false;
    }

    public boolean func_75253_b() {
        return this.entity.func_70638_az() != null && this.entity.func_70685_l((Entity)this.entity.func_70638_az()) && this.entity.func_70068_e((Entity)this.entity.func_70638_az()) < this.fireRange * this.fireRange;
    }

    public void func_75249_e() {
        this.fireBreathingTime = 1;
        this.entity.func_184185_a(SoundEvents.field_187572_ar, 1.0f, 1.2f);
    }

    public void func_75246_d() {
        if (this.fireBreathingTime > 0 && this.fireBreathingTime < this.maxShootFireTime) {
            ++this.fireBreathingTime;
            this.entity.func_70661_as().func_75499_g();
            this.entity.func_70625_a((Entity)this.entity.func_70638_az(), 100.0f, 100.0f);
            this.entity.func_70671_ap().func_75651_a((Entity)this.entity.func_70638_az(), 100.0f, 100.0f);
            if (this.fireBreathingTime > 18 && this.fireBreathingTime % 7 == 0) {
                Vector3d entityPos = new Vector3d(this.entity.func_226277_ct_(), this.entity.func_226280_cw_(), this.entity.func_226281_cx_());
                this.igniteInRange(entityPos, this.entity.func_70638_az().func_213303_ch(), 0.65, 5);
                this.entity.func_184185_a(SoundEvents.field_187616_bj, 1.0f, 1.0f);
            }
        } else {
            this.func_75251_c();
        }
    }

    public void func_75251_c() {
        this.fireBreathingTime = 0;
        this.cooldown = this.maxCooldown;
    }

    private void igniteInRange(Vector3d startPos, Vector3d endPos, double radius, int fireTime) {
        Vector3d vecDifference = endPos.func_178788_d(startPos);
        double l = vecDifference.func_72433_c();
        double stepSize = radius * 0.75;
        for (double i = 0.1; i < l; i += stepSize) {
            Vector3d scaled = startPos.func_178787_e(vecDifference.func_186678_a(i));
            AxisAlignedBB aabb = new AxisAlignedBB(scaled.field_72450_a - radius, scaled.field_72448_b - radius, scaled.field_72449_c - radius, scaled.field_72450_a + radius, scaled.field_72448_b + radius, scaled.field_72449_c + radius);
            for (Entity e : this.entity.func_130014_f_().func_72839_b((Entity)this.entity, aabb)) {
                e.func_70015_d(fireTime + this.entity.func_70681_au().nextInt(5) - 2);
            }
        }
    }
}

