/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.entity.ai;

import greekfantasy.GFRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.passive.WaterMobEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.math.vector.Vector3d;

public abstract class SwirlGoal<T extends WaterMobEntity>
extends Goal {
    protected final T entity;
    protected final int duration;
    protected final int cooldown;
    protected final double range;
    protected final boolean breakBoats;
    protected static final Predicate<Entity> target = EntityPredicates.field_188444_d.or(e -> e instanceof BoatEntity || e instanceof ItemEntity).and(e -> e.func_200600_R() != GFRegistry.WHIRL_ENTITY && e.func_184222_aU() && e.func_203005_aq());
    protected List<Entity> trackedEntities = new ArrayList<Entity>();
    protected int progressTime;
    protected int cooldownTime;

    public SwirlGoal(T lEntity, int lDuration, int lCooldown, double lRange, boolean lBreakBoats) {
        this.entity = lEntity;
        this.duration = lDuration;
        this.cooldown = lCooldown;
        this.range = lRange;
        this.cooldownTime = 60;
        this.breakBoats = lBreakBoats;
    }

    public boolean func_75250_a() {
        if (this.cooldownTime > 0) {
            --this.cooldownTime;
        } else if (((WaterMobEntity)this.entity).field_70173_aa % 10 == 0) {
            this.trackedEntities = SwirlGoal.getEntitiesInRange(this.entity, this.range, e -> this.canSwirl((Entity)e));
            return this.trackedEntities.size() > 0;
        }
        return false;
    }

    public void func_75249_e() {
        this.progressTime = 1;
    }

    public boolean func_75253_b() {
        if (((WaterMobEntity)this.entity).field_70173_aa % 11 == 0) {
            this.trackedEntities = SwirlGoal.getEntitiesInRange(this.entity, this.range, e -> this.canSwirl((Entity)e));
        }
        return this.progressTime > 0 && this.trackedEntities.size() > 0;
    }

    public void func_75246_d() {
        if (this.progressTime++ >= this.duration) {
            this.func_75251_c();
            return;
        }
        for (Entity e : this.trackedEntities) {
            if (e instanceof BoatEntity) {
                if (!this.breakBoats || this.entity.func_70681_au().nextInt(8) != 0) continue;
                e.func_70097_a(DamageSource.func_76358_a(this.entity), 3.0f);
                continue;
            }
            double dx = this.entity.func_226277_ct_() - e.func_213303_ch().field_72450_a;
            double dz = this.entity.func_226281_cx_() - e.func_213303_ch().field_72449_c;
            double horizDisSq = dx * dx + dz * dz;
            if (this.entity.func_174813_aQ().func_186662_g(1.0).func_72326_a(e.func_174813_aQ())) {
                this.onCollideWith(e);
                continue;
            }
            SwirlGoal.swirlEntity(this.entity, this.range, e, horizDisSq);
        }
    }

    public void func_75251_c() {
        this.progressTime = 0;
        this.cooldownTime = this.cooldown;
        this.trackedEntities.clear();
    }

    protected abstract void onCollideWith(Entity var1);

    protected abstract boolean canSwirl(Entity var1);

    protected static List<Entity> getEntitiesInRange(WaterMobEntity entity, double range, Predicate<Entity> predicate) {
        return entity.func_130014_f_().func_175674_a((Entity)entity, entity.func_174813_aQ().func_72314_b(range, range / 2.0, range), predicate);
    }

    protected static void swirlEntity(Entity entity, double range, Entity target, double disSq) {
        double motion = 0.062 + 0.11 * (1.0 - disSq / (range * range));
        Vector3d normalVec = entity.func_213303_ch().func_216372_d(1.0, 0.0, 1.0).func_178788_d(target.func_213303_ch().func_216372_d(1.0, 0.0, 1.0)).func_72432_b();
        Vector3d rotatedVec = normalVec.func_178785_b(1.5707964f).func_186678_a(motion);
        Vector3d motionVec = target.func_213322_ci().func_178787_e(normalVec.func_186678_a(0.028)).func_178787_e(rotatedVec).func_216372_d(0.65, 1.0, 0.65);
        target.func_213317_d(motionVec);
        target.func_70024_g(0.0, 0.0068, 0.0);
        target.field_70133_I = true;
    }
}

