/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.entity.misc;

import com.google.common.collect.ImmutableList;
import greekfantasy.GFRegistry;
import greekfantasy.entity.misc.EffectProjectileEntity;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.network.IPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class CurseEntity
extends EffectProjectileEntity {
    private static final Effect[] CURSES = new Effect[]{Effects.field_76440_q, Effects.field_76421_d, Effects.field_76436_u, Effects.field_76433_i, Effects.field_76437_t, Effects.field_82731_v, Effects.field_188424_y, Effects.field_188423_x, Effects.field_76419_f, Effects.field_76438_s, Effects.field_76431_k, Effects.field_189112_A};

    public CurseEntity(EntityType<? extends ProjectileEntity> entityType, World world) {
        super(entityType, world);
    }

    protected CurseEntity(World worldIn, LivingEntity thrower) {
        this(GFRegistry.CURSE_ENTITY, worldIn);
        this.lifespan = 90;
        super.func_212361_a((Entity)thrower);
        this.func_70107_b(thrower.func_226277_ct_(), thrower.func_226280_cw_() - 0.1, thrower.func_226281_cx_());
        this.func_234612_a_((Entity)thrower, thrower.field_70125_A, thrower.field_70177_z, 0.0f, 0.78f, 0.4f);
        this.func_70018_K();
    }

    public static CurseEntity create(World worldIn, LivingEntity thrower) {
        return new CurseEntity(worldIn, thrower);
    }

    @Override
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @Override
    protected List<EffectInstance> getPotionEffects(LivingEntity entity) {
        return ImmutableList.of((Object)new EffectInstance(CURSES[entity.func_70681_au().nextInt(CURSES.length)], 200, entity.func_70681_au().nextInt(2)));
    }

    @Override
    protected IParticleData getImpactParticle(LivingEntity entity) {
        return ParticleTypes.field_197615_h;
    }

    @Override
    protected IParticleData getTrailParticle() {
        return ParticleTypes.field_197601_L;
    }

    @Override
    protected float getImpactDamage(LivingEntity entity) {
        return 0.5f;
    }
}

