/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.entity.misc;

import greekfantasy.GFRegistry;
import greekfantasy.GreekFantasy;
import greekfantasy.entity.SpartiEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileItemEntity;
import net.minecraft.item.Item;
import net.minecraft.network.IPacket;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.fml.network.NetworkHooks;

public class DragonToothEntity
extends ProjectileItemEntity {
    public DragonToothEntity(EntityType<? extends DragonToothEntity> entityType, World world) {
        super(entityType, world);
    }

    private DragonToothEntity(World worldIn, LivingEntity thrower) {
        super(GFRegistry.DRAGON_TOOTH_ENTITY, thrower, worldIn);
    }

    private DragonToothEntity(World worldIn, double x, double y, double z) {
        super(GFRegistry.DRAGON_TOOTH_ENTITY, x, y, z, worldIn);
    }

    public static DragonToothEntity create(World worldIn, double x, double y, double z) {
        return new DragonToothEntity(worldIn, x, y, z);
    }

    public static DragonToothEntity create(World worldIn, LivingEntity thrower) {
        return new DragonToothEntity(worldIn, thrower);
    }

    protected Item func_213885_i() {
        return GFRegistry.DRAGON_TOOTH;
    }

    protected void func_213868_a(EntityRayTraceResult raytrace) {
        super.func_213868_a(raytrace);
        float damage = GreekFantasy.CONFIG.doesDragonToothSpawnSparti() ? 0.0f : 1.5f;
        raytrace.func_216348_a().func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)this.func_234616_v_()), damage);
    }

    protected void func_70227_a(RayTraceResult raytrace) {
        super.func_70227_a(raytrace);
        if (!this.field_70170_p.func_201670_d() && this.field_70170_p instanceof IServerWorld && this.func_70089_S() && GreekFantasy.CONFIG.doesDragonToothSpawnSparti()) {
            Entity thrower = this.func_234616_v_();
            int n = GreekFantasy.CONFIG.getNumSpartiSpawned();
            int life = 20 * GreekFantasy.CONFIG.getSpartiLifespan();
            for (int i = 0; i < n; ++i) {
                SpartiEntity sparti = (SpartiEntity)GFRegistry.SPARTI_ENTITY.func_200721_a(this.field_70170_p);
                sparti.func_70012_b(raytrace.func_216347_e().field_72450_a, raytrace.func_216347_e().field_72448_b, raytrace.func_216347_e().field_72449_c, 0.0f, 0.0f);
                this.field_70170_p.func_217376_c((Entity)sparti);
                if (thrower instanceof PlayerEntity) {
                    sparti.field_70125_A = MathHelper.func_76142_g((float)(thrower.field_70177_z + 180.0f));
                    sparti.func_70903_f(true);
                    sparti.func_184754_b(thrower.func_110124_au());
                }
                sparti.setLimitedLife(life);
                sparti.func_213386_a((IServerWorld)this.field_70170_p, this.field_70170_p.func_175649_E(new BlockPos(raytrace.func_216347_e())), SpawnReason.MOB_SUMMONED, null, null);
            }
            this.func_70106_y();
        }
    }

    public void func_70071_h_() {
        Entity entity = this.func_234616_v_();
        if (entity instanceof PlayerEntity && !entity.func_70089_S()) {
            this.func_70106_y();
        } else {
            super.func_70071_h_();
        }
    }

    public Entity changeDimension(ServerWorld serverWorld, ITeleporter iTeleporter) {
        Entity entity = this.func_234616_v_();
        if (entity != null && entity.field_70170_p.func_234923_W_() != serverWorld.func_234923_W_()) {
            this.func_212361_a(null);
        }
        return super.changeDimension(serverWorld, iTeleporter);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected float func_70185_h() {
        return 0.11f;
    }
}

