/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.entity.misc;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.network.IPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.network.NetworkHooks;

public abstract class EffectProjectileEntity
extends ProjectileEntity {
    protected int lifespan = 300;

    public EffectProjectileEntity(EntityType<? extends ProjectileEntity> entityType, World world) {
        super(entityType, world);
    }

    protected void func_213868_a(EntityRayTraceResult raytrace) {
        super.func_213868_a(raytrace);
        Entity thrower = this.func_234616_v_();
        if (raytrace.func_216348_a() != thrower && raytrace.func_216348_a() instanceof LivingEntity) {
            LivingEntity entity = (LivingEntity)raytrace.func_216348_a();
            for (EffectInstance effect : this.getPotionEffects(entity)) {
                entity.func_195064_c(effect);
            }
            float damage = this.getImpactDamage(entity);
            if (damage > 0.0f && thrower instanceof LivingEntity) {
                entity.func_70097_a(DamageSource.func_188403_a((Entity)this, (LivingEntity)((LivingEntity)thrower)), damage);
            }
            this.addParticles(this.getImpactParticle(entity), 6 + this.field_70146_Z.nextInt(6));
        }
    }

    protected void func_70227_a(RayTraceResult raytrace) {
        super.func_70227_a(raytrace);
        if (this.func_70089_S()) {
            this.func_70106_y();
        }
    }

    public void func_70071_h_() {
        RayTraceResult raytraceresult;
        Entity thrower = this.func_234616_v_();
        if (thrower instanceof PlayerEntity && !thrower.func_70089_S()) {
            this.func_70106_y();
            return;
        }
        if (this.field_70173_aa > this.lifespan) {
            this.func_70106_y();
            return;
        }
        if (!this.func_130014_f_().func_201670_d() && (raytraceresult = ProjectileHelper.func_234618_a_((Entity)this, arg_0 -> ((EffectProjectileEntity)this).func_230298_a_(arg_0))) != null && raytraceresult.func_216346_c() != RayTraceResult.Type.MISS && !ForgeEventFactory.onProjectileImpact((Entity)this, (RayTraceResult)raytraceresult)) {
            this.func_70227_a(raytraceresult);
        }
        if (this.field_70173_aa > 2) {
            this.addParticles(this.getTrailParticle(), 2);
        }
        Vector3d motion = this.func_213322_ci();
        double d0 = this.func_226277_ct_() + motion.field_72450_a;
        double d1 = this.func_226278_cu_() + motion.field_72448_b;
        double d2 = this.func_226281_cx_() + motion.field_72449_c;
        this.func_234617_x_();
        this.func_70107_b(d0, d1, d2);
        super.func_70071_h_();
    }

    public Entity changeDimension(ServerWorld serverWorld, ITeleporter iTeleporter) {
        Entity entity = this.func_234616_v_();
        if (entity != null && entity.field_70170_p.func_234923_W_() != serverWorld.func_234923_W_()) {
            this.func_212361_a(null);
        }
        return super.changeDimension(serverWorld, iTeleporter);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void func_70088_a() {
    }

    abstract List<EffectInstance> getPotionEffects(LivingEntity var1);

    abstract IParticleData getImpactParticle(LivingEntity var1);

    abstract IParticleData getTrailParticle();

    abstract float getImpactDamage(LivingEntity var1);

    protected void addParticles(IParticleData type, int count) {
        if (this.func_130014_f_().func_201670_d()) {
            double x = this.func_226277_ct_();
            double y = this.func_226278_cu_() + 0.1;
            double z = this.func_226281_cx_();
            double motion = 0.08;
            double width = this.func_213311_cf() / 2.0f;
            double height = this.func_213302_cg() / 2.0f;
            for (int i = 0; i < count; ++i) {
                this.field_70170_p.func_195594_a(type, x + (this.field_70170_p.field_73012_v.nextDouble() - 0.5) * width, y + height, z + (this.field_70170_p.field_73012_v.nextDouble() - 0.5) * width, (this.field_70170_p.field_73012_v.nextDouble() - 0.5) * 0.08, (this.field_70170_p.field_73012_v.nextDouble() - 0.5) * 0.08, (this.field_70170_p.field_73012_v.nextDouble() - 0.5) * 0.08);
            }
        }
    }
}

