/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.entity.misc;

import greekfantasy.GFRegistry;
import greekfantasy.block.OilBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.ProjectileItemEntity;
import net.minecraft.item.Item;
import net.minecraft.network.IPacket;
import net.minecraft.state.Property;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.fml.network.NetworkHooks;

public class GreekFireEntity
extends ProjectileItemEntity {
    public GreekFireEntity(EntityType<? extends GreekFireEntity> entityType, World world) {
        super(entityType, world);
    }

    private GreekFireEntity(World worldIn, LivingEntity thrower) {
        super(GFRegistry.GREEK_FIRE_ENTITY, thrower, worldIn);
    }

    private GreekFireEntity(World worldIn, double x, double y, double z) {
        super(GFRegistry.GREEK_FIRE_ENTITY, x, y, z, worldIn);
    }

    public static GreekFireEntity create(World worldIn, double x, double y, double z) {
        return new GreekFireEntity(worldIn, x, y, z);
    }

    public static GreekFireEntity create(World worldIn, LivingEntity thrower) {
        return new GreekFireEntity(worldIn, thrower);
    }

    protected Item func_213885_i() {
        return GFRegistry.GREEK_FIRE;
    }

    protected void func_213868_a(EntityRayTraceResult raytrace) {
        super.func_213868_a(raytrace);
        this.causeExplosion(raytrace.func_216347_e());
    }

    protected void func_70227_a(RayTraceResult raytrace) {
        super.func_70227_a(raytrace);
        if (!this.field_70170_p.func_201670_d() && this.field_70170_p instanceof IServerWorld && this.func_70089_S()) {
            this.causeExplosion(raytrace.func_216347_e());
            this.func_70106_y();
        }
    }

    protected Explosion causeExplosion(Vector3d vec) {
        float size = 1.25f;
        float size2 = 1.875f;
        Explosion exp = this.field_70170_p.func_230546_a_(this.func_234616_v_(), DamageSource.field_76370_b, null, vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, 1.25f, false, Explosion.Mode.NONE);
        BlockPos.Mutable pos = new BlockPos.Mutable(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
        for (double x = vec.field_72450_a - 1.875; x < vec.field_72450_a + 1.875; x += 1.0) {
            for (double y = vec.field_72448_b - 1.875; y < vec.field_72448_b + 1.875; y += 1.0) {
                for (double z = vec.field_72449_c - 1.875; z < vec.field_72449_c + 1.875; z += 1.0) {
                    pos.func_189532_c(x, y, z);
                    BlockState state = this.field_70170_p.func_180495_p((BlockPos)pos);
                    if (this.field_70170_p.field_73012_v.nextInt(3) <= 0) continue;
                    if (state.func_185904_a().func_76222_j() && this.field_70170_p.func_180495_p(pos.func_177977_b()).func_200015_d((IBlockReader)this.field_70170_p, pos.func_177977_b())) {
                        this.field_70170_p.func_175656_a((BlockPos)pos, (BlockState)GFRegistry.OIL.func_176223_P().func_206870_a((Property)OilBlock.LIT, (Comparable)Boolean.valueOf(true)));
                        continue;
                    }
                    if (this.field_70170_p.func_180495_p((BlockPos)pos).func_177230_c() != Blocks.field_150355_j || !this.field_70170_p.func_175623_d(pos.func_177984_a())) continue;
                    this.field_70170_p.func_175656_a((BlockPos)pos, (BlockState)((BlockState)GFRegistry.OIL.func_176223_P().func_206870_a((Property)OilBlock.WATERLOGGED, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)OilBlock.LIT, (Comparable)Boolean.valueOf(true)));
                    this.field_70170_p.func_180501_a(pos.func_177984_a(), Blocks.field_235335_bO_.func_176223_P(), 2);
                }
            }
        }
        return exp;
    }

    public void func_70071_h_() {
        BlockRayTraceResult raytraceresult = this.field_70170_p.func_217299_a(new RayTraceContext(this.func_213303_ch().func_72441_c(-0.1, -0.1, -0.1), this.func_213303_ch().func_72441_c(0.1, 0.1, 0.1), RayTraceContext.BlockMode.OUTLINE, RayTraceContext.FluidMode.ANY, (Entity)this));
        if (raytraceresult.func_216346_c() == RayTraceResult.Type.BLOCK) {
            this.func_70227_a((RayTraceResult)raytraceresult);
        } else {
            super.func_70071_h_();
        }
    }

    protected float func_70185_h() {
        return 0.09f;
    }

    public Entity changeDimension(ServerWorld serverWorld, ITeleporter iTeleporter) {
        Entity entity = this.func_234616_v_();
        if (entity != null && entity.field_70170_p.func_234923_W_() != serverWorld.func_234923_W_()) {
            this.func_212361_a(null);
        }
        return super.changeDimension(serverWorld, iTeleporter);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

