/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.entity.misc;

import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.GhastEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.Hand;

public interface IHasOwner<E extends LivingEntity> {
    public static final String KEY_OWNER = "Owner";

    public Optional<UUID> getOwnerID();

    public void setOwner(@Nullable UUID var1);

    @Nullable
    public LivingEntity getOwner();

    public boolean isTamingItem(ItemStack var1);

    default public boolean hasOwner() {
        return this.getOwnerID().isPresent();
    }

    default public void setOwner(PlayerEntity entity) {
        this.setOwner(entity.func_110124_au());
    }

    default public boolean isOwner(LivingEntity entity) {
        return this.hasOwner() && entity == this.getOwner();
    }

    default public boolean shouldAttackEntity(LivingEntity target, LivingEntity owner) {
        if (target instanceof CreeperEntity || target instanceof GhastEntity) {
            return false;
        }
        if (owner != null && owner == target) {
            return false;
        }
        if (target instanceof IHasOwner) {
            IHasOwner ihasowner = (IHasOwner)target;
            return !ihasowner.hasOwner() || ihasowner.getOwner() != owner;
        }
        if (target instanceof PlayerEntity && owner instanceof PlayerEntity && !((PlayerEntity)owner).func_96122_a((PlayerEntity)target)) {
            return false;
        }
        if (target instanceof AbstractHorseEntity && ((AbstractHorseEntity)target).func_110248_bS()) {
            return false;
        }
        return !(target instanceof TameableEntity) || !((TameableEntity)target).func_70909_n();
    }

    default public Team getOwnerTeam(Team fallback) {
        LivingEntity owner;
        if (this.hasOwner() && (owner = this.getOwner()) != null) {
            return owner.func_96124_cp();
        }
        return fallback;
    }

    default public boolean isOnSameTeamAs(Entity entity) {
        if (this.hasOwner()) {
            LivingEntity owner = this.getOwner();
            if (entity == owner) {
                return true;
            }
            if (owner != null) {
                return owner.func_184191_r(entity);
            }
        }
        return false;
    }

    default public void writeOwner(CompoundNBT compound) {
        if (this.hasOwner()) {
            compound.func_186854_a(KEY_OWNER, this.getOwnerID().get());
        }
    }

    default public void readOwner(CompoundNBT compound) {
        if (compound.func_186855_b(KEY_OWNER)) {
            this.setOwner(compound.func_186857_a(KEY_OWNER));
        }
    }

    default public boolean tryTameOrHeal(E self, PlayerEntity player, Hand hand) {
        int i;
        ItemStack itemstack = player.func_184586_b(hand);
        boolean hasOwner = this.hasOwner();
        float healAmount = this.getHealAmount(itemstack);
        int tameChance = this.isTamingItem(itemstack) ? this.getTameChance(player.func_70681_au()) : 0;
        boolean success = false;
        if (!hasOwner && tameChance > 0) {
            if (player.func_70681_au().nextInt(tameChance) == 0) {
                this.setOwner(player);
            }
            if (((LivingEntity)self).field_70170_p.func_201670_d()) {
                for (i = 0; i < 3; ++i) {
                    ((LivingEntity)self).field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197633_z, self.func_226277_ct_(), self.func_226280_cw_(), self.func_226281_cx_(), 0.0, 0.0, 0.0);
                }
            }
            success = true;
        } else if (hasOwner && healAmount > 0.0f && self.func_110143_aJ() < self.func_110138_aP()) {
            self.func_70691_i(this.getHealAmount(itemstack));
            if (((LivingEntity)self).field_70170_p.func_201670_d()) {
                ((LivingEntity)self).field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197633_z, self.func_226277_ct_(), self.func_226280_cw_(), self.func_226281_cx_(), 0.0, 0.0, 0.0);
            }
            success = true;
        }
        if (success) {
            if (!player.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
            }
            if (((LivingEntity)self).field_70170_p.func_201670_d()) {
                for (i = 0; i < 3; ++i) {
                    ((LivingEntity)self).field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197633_z, self.func_226277_ct_(), self.func_226280_cw_(), self.func_226281_cx_(), 0.0, 0.0, 0.0);
                }
            }
        }
        return success;
    }

    default public int getTameChance(Random rand) {
        return 4;
    }

    default public float getHealAmount(ItemStack stack) {
        return this.isTamingItem(stack) ? 2.0f : 0.0f;
    }

    default public boolean hasTamingItemInHand(PlayerEntity player) {
        for (Hand hand : Hand.values()) {
            ItemStack itemstack = player.func_184586_b(hand);
            if (!this.isTamingItem(itemstack)) continue;
            return true;
        }
        return false;
    }
}

