/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.entity.misc;

import greekfantasy.entity.CerberusEntity;
import java.util.function.Predicate;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public class OrthusHeadItemEntity
extends ItemEntity {
    private static final ResourceLocation FRAME_BLOCK_TAG = new ResourceLocation("greekfantasy", "valid_cerberus_frame");
    private static final Predicate<BlockState> IS_FRAME = b -> b.func_235714_a_(BlockTags.func_199896_a().func_199910_a(FRAME_BLOCK_TAG));
    private static final Predicate<BlockState> IS_LAVA = b -> b.func_203425_a(Blocks.field_150353_l);
    private static final Predicate<BlockState> IS_AIR = b -> b.func_185904_a() == Material.field_151579_a;

    public OrthusHeadItemEntity(EntityType<? extends ItemEntity> type, World world) {
        super(type, world);
    }

    private OrthusHeadItemEntity(World world, double posX, double posY, double posZ, ItemStack itemstack) {
        super(world, posX, posY, posZ, itemstack);
    }

    public static OrthusHeadItemEntity create(World world, double posX, double posY, double posZ, ItemStack itemstack) {
        return new OrthusHeadItemEntity(world, posX, posY, posZ, itemstack);
    }

    public void func_70106_y() {
        if (!this.field_70170_p.func_201670_d() && this.func_70027_ad() && !this.trySpawnCerberus(this.func_233580_cy_())) {
            this.trySpawnCerberus(this.func_233580_cy_().func_177984_a());
        }
        super.func_70106_y();
    }

    protected boolean trySpawnCerberus(BlockPos lavaPos) {
        BlockPos framePos;
        Direction dir = this.hasSquare(lavaPos);
        if (dir != null && this.hasFrame(IS_FRAME, framePos = lavaPos.func_177972_a(dir.func_176734_d()).func_177972_a(dir.func_176735_f()), dir) && this.hasSquare(IS_AIR, lavaPos.func_177984_a(), dir) && this.hasFrame(IS_AIR, lavaPos.func_177984_a(), dir)) {
            this.fillSquare(Blocks.field_196814_hQ.func_176223_P(), lavaPos, dir);
            Vector3d center = this.func_213303_ch().func_72441_c(0.0, 1.0, 0.0);
            CerberusEntity.spawnCerberus(this.field_70170_p, center);
            return true;
        }
        return false;
    }

    private Direction hasSquare(BlockPos startPos) {
        for (int i = 0; i < 4; ++i) {
            Direction d = Direction.func_176731_b((int)i);
            if (!this.hasSquare(IS_LAVA, startPos, d)) continue;
            return d;
        }
        return null;
    }

    private boolean hasSquare(Predicate<BlockState> test, BlockPos startPos, Direction d) {
        Direction c = d.func_176746_e();
        return test.test(this.field_70170_p.func_180495_p(startPos)) && test.test(this.field_70170_p.func_180495_p(startPos.func_177967_a(d, 1))) && test.test(this.field_70170_p.func_180495_p(startPos.func_177967_a(c, 1))) && test.test(this.field_70170_p.func_180495_p(startPos.func_177967_a(d, 1).func_177967_a(c, 1)));
    }

    private void fillSquare(BlockState state, BlockPos startPos, Direction d) {
        Direction c = d.func_176746_e();
        this.field_70170_p.func_180501_a(startPos, state, 2);
        this.field_70170_p.func_180501_a(startPos.func_177967_a(d, 1), state, 2);
        this.field_70170_p.func_180501_a(startPos.func_177967_a(c, 1), state, 2);
        this.field_70170_p.func_180501_a(startPos.func_177967_a(d, 1).func_177967_a(c, 1), state, 2);
    }

    private boolean hasFrame(Predicate<BlockState> test, BlockPos startPos, Direction d) {
        Direction c = d.func_176746_e();
        return test.test(this.field_70170_p.func_180495_p(startPos.func_177967_a(d, 1))) && test.test(this.field_70170_p.func_180495_p(startPos.func_177967_a(d, 2))) && test.test(this.field_70170_p.func_180495_p(startPos.func_177967_a(d, 3).func_177967_a(c, 1))) && test.test(this.field_70170_p.func_180495_p(startPos.func_177967_a(d, 3).func_177967_a(c, 2))) && test.test(this.field_70170_p.func_180495_p(startPos.func_177967_a(d, 2).func_177967_a(c, 3))) && test.test(this.field_70170_p.func_180495_p(startPos.func_177967_a(d, 1).func_177967_a(c, 3))) && test.test(this.field_70170_p.func_180495_p(startPos.func_177967_a(c, 1))) && test.test(this.field_70170_p.func_180495_p(startPos.func_177967_a(c, 2)));
    }
}

