/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.entity.misc;

import greekfantasy.GFRegistry;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;

public class SpearEntity
extends AbstractArrowEntity {
    protected static final DataParameter<ItemStack> ITEM = EntityDataManager.func_187226_a(SpearEntity.class, (IDataSerializer)DataSerializers.field_187196_f);
    protected static final String KEY_ITEM = "Item";
    protected static final String KEY_DAMAGE = "DealtDamage";
    protected boolean dealtDamage;
    protected boolean enchanted;
    protected int loyaltyLevel;
    protected int returningTicks;
    protected ResourceLocation texture = new ResourceLocation("greekfantasy", "textures/entity/spear/wooden_spear.png");
    protected Consumer<Entity> onHitEntity;

    public SpearEntity(EntityType<? extends SpearEntity> type, World world) {
        super(type, world);
        this.onHitEntity = e -> {};
    }

    public SpearEntity(World world, LivingEntity thrower, ItemStack item, Consumer<Entity> hitEntity) {
        super(GFRegistry.SPEAR_ENTITY, thrower, world);
        this.onHitEntity = e -> {};
        this.setArrowStack(item);
        this.onHitEntity = hitEntity;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ITEM, (Object)ItemStack.field_190927_a);
    }

    public void func_70071_h_() {
        if (this.field_184552_b > 4) {
            this.dealtDamage = true;
        }
        Entity entity = this.func_234616_v_();
        if ((this.dealtDamage || this.func_203047_q()) && entity != null) {
            if (this.loyaltyLevel > 0 && !this.shouldReturnToThrower()) {
                if (!this.field_70170_p.field_72995_K && this.field_70251_a == AbstractArrowEntity.PickupStatus.ALLOWED) {
                    this.func_70099_a(this.func_184550_j(), 0.1f);
                }
                this.func_70106_y();
            } else if (this.loyaltyLevel > 0) {
                this.func_203045_n(true);
                Vector3d vector3d = new Vector3d(entity.func_226277_ct_() - this.func_226277_ct_(), entity.func_226280_cw_() - this.func_226278_cu_(), entity.func_226281_cx_() - this.func_226281_cx_());
                this.func_226288_n_(this.func_226277_ct_(), this.func_226278_cu_() + vector3d.field_72448_b * 0.015 * (double)this.loyaltyLevel, this.func_226281_cx_());
                if (this.field_70170_p.func_201670_d()) {
                    this.field_70137_T = this.func_226278_cu_();
                }
                double d0 = 0.05 * (double)this.loyaltyLevel;
                this.func_213317_d(this.func_213322_ci().func_186678_a(0.95).func_178787_e(vector3d.func_72432_b().func_186678_a(d0)));
                if (this.returningTicks == 0) {
                    this.func_184185_a(SoundEvents.field_203270_il, 10.0f, 1.0f);
                }
                ++this.returningTicks;
            }
        }
        super.func_70071_h_();
    }

    protected boolean shouldReturnToThrower() {
        Entity entity = this.func_234616_v_();
        return entity != null && entity.func_70089_S() && (!(entity instanceof ServerPlayerEntity) || !entity.func_175149_v());
    }

    protected ItemStack func_184550_j() {
        return ((ItemStack)this.func_184212_Q().func_187225_a(ITEM)).func_77946_l();
    }

    protected void setArrowStack(ItemStack stack) {
        this.func_184212_Q().func_187227_b(ITEM, (Object)stack.func_77946_l());
        ResourceLocation name = stack.func_77973_b().getRegistryName();
        this.texture = new ResourceLocation(name.func_110624_b(), "textures/entity/spear/" + name.func_110623_a() + ".png");
        this.loyaltyLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_203193_C, (ItemStack)stack);
        this.enchanted = stack.func_77962_s();
    }

    public void func_184206_a(DataParameter<?> key) {
        super.func_184206_a(key);
        if (key.equals(ITEM)) {
            ItemStack stack = this.func_184550_j();
            ResourceLocation name = stack.func_77973_b().getRegistryName();
            this.texture = new ResourceLocation(name.func_110624_b(), "textures/entity/spear/" + name.func_110623_a() + ".png");
            this.loyaltyLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_203193_C, (ItemStack)stack);
            this.enchanted = stack.func_77962_s();
        }
    }

    protected void func_213868_a(EntityRayTraceResult raytrace) {
        Entity thrower;
        Entity entity = raytrace.func_216348_a();
        this.dealtDamage = true;
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            this.func_70239_b(this.func_70242_d() + (double)EnchantmentHelper.func_152377_a((ItemStack)this.func_184550_j(), (CreatureAttribute)living.func_70668_bt()));
        }
        DamageSource source = DamageSource.func_76356_a((Entity)this, (Entity)((thrower = this.func_234616_v_()) == null ? this : thrower));
        this.onHitEntity.accept(entity);
        SoundEvent sound = SoundEvents.field_203268_ij;
        if (entity.func_70097_a(source, (float)this.func_70242_d())) {
            if (entity.func_200600_R() == EntityType.field_200803_q) {
                return;
            }
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                if (thrower instanceof LivingEntity) {
                    EnchantmentHelper.func_151384_a((LivingEntity)living, (Entity)thrower);
                    EnchantmentHelper.func_151385_b((LivingEntity)((LivingEntity)thrower), (Entity)living);
                }
                this.func_184548_a(living);
            }
        }
        this.func_213317_d(this.func_213322_ci().func_216372_d(-0.01, -0.1, -0.01));
        this.func_184185_a(sound, 1.0f, 1.0f);
    }

    protected void func_184548_a(LivingEntity living) {
        super.func_184548_a(living);
        CompoundNBT nbt = this.func_184550_j().func_190925_c("Potion").func_74737_b();
        if (nbt.func_74764_b("Potion")) {
            nbt.func_74774_a("Id", (byte)Effect.func_188409_a((Effect)((Effect)ForgeRegistries.POTIONS.getValue(new ResourceLocation(nbt.func_74779_i("Potion"))))));
            living.func_195064_c(EffectInstance.func_82722_b((CompoundNBT)nbt));
        }
    }

    @Nullable
    protected EntityRayTraceResult func_213866_a(Vector3d startVec, Vector3d endVec) {
        return this.dealtDamage ? null : super.func_213866_a(startVec, endVec);
    }

    public void func_70100_b_(PlayerEntity player) {
        Entity thrower = this.func_234616_v_();
        if (thrower != null && thrower.func_110124_au() != player.func_110124_au()) {
            return;
        }
        super.func_70100_b_(player);
    }

    public void func_70037_a(CompoundNBT tag) {
        super.func_70037_a(tag);
        if (tag.func_150297_b(KEY_ITEM, 10)) {
            this.setArrowStack(ItemStack.func_199557_a((CompoundNBT)tag.func_74775_l(KEY_ITEM)));
        }
        this.dealtDamage = tag.func_74767_n(KEY_DAMAGE);
    }

    public void func_213281_b(CompoundNBT tag) {
        super.func_213281_b(tag);
        tag.func_218657_a(KEY_ITEM, (INBT)this.func_184550_j().func_77955_b(new CompoundNBT()));
        tag.func_74757_a(KEY_DAMAGE, this.dealtDamage);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected SoundEvent func_213867_k() {
        return SoundEvents.field_203269_ik;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_145770_h(double dX, double dY, double dZ) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ResourceLocation getTexture() {
        return this.texture;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isEnchanted() {
        return this.enchanted;
    }
}

