/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.entity.misc;

import com.google.common.collect.ImmutableList;
import greekfantasy.GFRegistry;
import greekfantasy.GreekFantasy;
import greekfantasy.entity.misc.EffectProjectileEntity;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.network.IPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class SwineSpellEntity
extends EffectProjectileEntity {
    public SwineSpellEntity(EntityType<? extends ProjectileEntity> entityType, World world) {
        super(entityType, world);
    }

    protected SwineSpellEntity(World worldIn, LivingEntity thrower) {
        this(GFRegistry.SWINE_SPELL_ENTITY, worldIn);
        super.func_212361_a((Entity)thrower);
        this.func_70107_b(thrower.func_226277_ct_(), thrower.func_226280_cw_() - 0.1, thrower.func_226281_cx_());
        this.func_234612_a_((Entity)thrower, thrower.field_70125_A, thrower.field_70177_z, 0.0f, 0.75f, 0.5f);
        this.func_70018_K();
    }

    public static SwineSpellEntity create(World worldIn, LivingEntity thrower) {
        return new SwineSpellEntity(worldIn, thrower);
    }

    @Override
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @Override
    protected List<EffectInstance> getPotionEffects(LivingEntity entity) {
        Effect effect = Effects.field_76421_d;
        int amp = 1;
        if (GreekFantasy.CONFIG.isSwineEnabled() && GreekFantasy.CONFIG.canSwineApply(entity.func_200600_R().getRegistryName().toString())) {
            effect = GFRegistry.SWINE_EFFECT;
            amp = 0;
        }
        int duration = GreekFantasy.CONFIG.getSwineWandDuration();
        int slowness = entity instanceof PlayerEntity ? 1 : duration;
        return ImmutableList.of((Object)new EffectInstance(effect, duration, amp, false, true), (Object)new EffectInstance(Effects.field_76421_d, slowness, amp + 1, false, false, false), (Object)new EffectInstance(Effects.field_76419_f, duration - 1, amp + 1, false, false, false), (Object)new EffectInstance(Effects.field_76437_t, duration - 1, amp + 1, false, false, false));
    }

    @Override
    protected IParticleData getImpactParticle(LivingEntity entity) {
        return ParticleTypes.field_197623_p;
    }

    @Override
    protected IParticleData getTrailParticle() {
        return ParticleTypes.field_197622_o;
    }

    @Override
    protected float getImpactDamage(LivingEntity entity) {
        return 0.0f;
    }
}

