/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.entity.misc;

import greekfantasy.GFRegistry;
import greekfantasy.entity.BabySpiderEntity;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileItemEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.LootTable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.fml.network.NetworkHooks;

public class WebBallEntity
extends ProjectileItemEntity {
    protected static final DataParameter<Byte> TYPE = EntityDataManager.func_187226_a(WebBallEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    protected static final String KEY_TYPE = "WebType";
    public static final byte WEB = 1;
    public static final byte SPIDER = 2;
    public static final byte ITEM = 4;

    public WebBallEntity(EntityType<? extends WebBallEntity> entityType, World world) {
        super(entityType, world);
    }

    private WebBallEntity(World worldIn, LivingEntity thrower) {
        super(GFRegistry.WEB_BALL_ENTITY, thrower, worldIn);
    }

    private WebBallEntity(World worldIn, double x, double y, double z) {
        super(GFRegistry.WEB_BALL_ENTITY, x, y, z, worldIn);
    }

    public static WebBallEntity create(World worldIn, double x, double y, double z) {
        return new WebBallEntity(worldIn, x, y, z);
    }

    public static WebBallEntity create(World worldIn, LivingEntity thrower) {
        return new WebBallEntity(worldIn, thrower);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(TYPE, (Object)1);
    }

    protected Item func_213885_i() {
        return GFRegistry.WEB_BALL;
    }

    protected void func_213868_a(EntityRayTraceResult raytrace) {
        super.func_213868_a(raytrace);
        if (!this.field_70170_p.func_201670_d() && this.field_70170_p instanceof IServerWorld && this.func_70089_S() && raytrace.func_216348_a() != null) {
            this.onWebImpact((RayTraceResult)raytrace, raytrace.func_216348_a().func_233580_cy_());
            this.func_70106_y();
        }
    }

    protected void func_70227_a(RayTraceResult raytrace) {
        super.func_70227_a(raytrace);
        if (!this.field_70170_p.func_201670_d() && this.field_70170_p instanceof IServerWorld && this.func_70089_S()) {
            this.onWebImpact(raytrace, this.func_233580_cy_());
            this.func_70106_y();
        }
    }

    public void func_70071_h_() {
        Entity entity = this.func_234616_v_();
        if (entity instanceof PlayerEntity && !entity.func_70089_S()) {
            this.func_70106_y();
        } else {
            super.func_70071_h_();
        }
    }

    public Entity changeDimension(ServerWorld serverWorld, ITeleporter iTeleporter) {
        Entity entity = this.func_234616_v_();
        if (entity != null && entity.field_70170_p.func_234923_W_() != serverWorld.func_234923_W_()) {
            this.func_212361_a(null);
        }
        return super.changeDimension(serverWorld, iTeleporter);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected float func_70185_h() {
        return 0.08f;
    }

    public void func_70037_a(CompoundNBT tag) {
        super.func_70037_a(tag);
        this.setWebType(tag.func_74771_c(KEY_TYPE));
    }

    public void func_213281_b(CompoundNBT tag) {
        super.func_213281_b(tag);
        tag.func_74774_a(KEY_TYPE, this.getWebType());
    }

    private void onWebImpact(RayTraceResult raytrace, BlockPos webPos) {
        byte type = this.getWebType();
        if (type == 0) {
            this.func_199701_a_(new ItemStack((IItemProvider)Items.field_151007_F));
            return;
        }
        if (this.hasWeb(type) && this.field_70170_p.func_175623_d(webPos)) {
            this.field_70170_p.func_175656_a(webPos, Blocks.field_196553_aF.func_176223_P());
        }
        if (this.hasSpider(type)) {
            BabySpiderEntity spider = (BabySpiderEntity)GFRegistry.BABY_SPIDER_ENTITY.func_200721_a(this.field_70170_p);
            spider.func_82149_j((Entity)this);
            spider.func_213390_a(webPos, 12);
            this.field_70170_p.func_217376_c((Entity)spider);
        }
        if (this.hasItem(type)) {
            ResourceLocation resourcelocation = this.func_200600_R().func_220348_g();
            LootTable loottable = this.field_70170_p.func_73046_m().func_200249_aQ().func_186521_a(resourcelocation);
            LootContext.Builder lootcontext$builder = new LootContext.Builder((ServerWorld)this.field_70170_p).func_216023_a(this.field_70146_Z).func_216015_a(LootParameters.field_216281_a, (Object)this).func_216015_a(LootParameters.field_237457_g_, (Object)this.func_213303_ch()).func_216015_a(LootParameters.field_216283_c, (Object)DamageSource.field_76379_h).func_216021_b(LootParameters.field_216284_d, (Object)this.func_234616_v_()).func_216021_b(LootParameters.field_216285_e, null);
            LootContext ctx = lootcontext$builder.func_216022_a(LootParameterSets.field_216263_d);
            loottable.func_216113_a(ctx).forEach(arg_0 -> ((WebBallEntity)this).func_199701_a_(arg_0));
        }
    }

    public void setWebType(byte b) {
        this.func_184212_Q().func_187227_b(TYPE, (Object)b);
    }

    public byte getWebType() {
        return (Byte)this.func_184212_Q().func_187225_a(TYPE);
    }

    public byte setWebType(boolean web, boolean spider, boolean item) {
        byte type = 0;
        if (web) {
            type = (byte)(type + 1);
        }
        if (spider) {
            type = (byte)(type + 2);
        }
        if (item) {
            type = (byte)(type + 4);
        }
        this.setWebType(type);
        return type;
    }

    public boolean hasWeb(byte webType) {
        return (webType & 1) != 0;
    }

    public boolean hasSpider(byte webType) {
        return (webType & 2) != 0;
    }

    public boolean hasItem(byte webType) {
        return (webType & 4) != 0;
    }
}

