/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.event;

import greekfantasy.GFRegistry;
import greekfantasy.GreekFantasy;
import greekfantasy.client.render.SwineRenderer;
import greekfantasy.entity.PegasusEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;

public class ClientForgeEventHandler {
    private static SwineRenderer<LivingEntity> pigRenderer;
    private static boolean wasJumping;

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void renderLiving(RenderLivingEvent.Pre<LivingEntity, ?> event) {
        if (ClientForgeEventHandler.isSwine(event.getEntity())) {
            event.setCanceled(true);
            if (null == pigRenderer) {
                Minecraft mc = Minecraft.func_71410_x();
                pigRenderer = new SwineRenderer(mc.func_175598_ae());
            }
            pigRenderer.func_225623_a_(event.getEntity(), event.getEntity().field_70177_z, event.getPartialRenderTick(), event.getMatrixStack(), event.getBuffers(), pigRenderer.func_229100_c_((Entity)event.getEntity(), event.getPartialRenderTick()));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void renderPlayer(RenderPlayerEvent.Pre event) {
        if (GreekFantasy.CONFIG.doesHelmHideArmor() && ClientForgeEventHandler.hasHelmOfDarkness(event.getPlayer())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void renderPlayerHand(RenderHandEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (GreekFantasy.CONFIG.doesHelmHideArmor() && ClientForgeEventHandler.hasHelmOfDarkness((PlayerEntity)mc.field_71439_g) || ClientForgeEventHandler.isSwine((LivingEntity)mc.field_71439_g) && mc.field_71439_g.func_184614_ca().func_190926_b()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START && event.side == LogicalSide.CLIENT && GreekFantasy.CONFIG.isOverstepEnabled() && event.player instanceof ClientPlayerEntity) {
            ClientPlayerEntity player = (ClientPlayerEntity)event.player;
            Minecraft mc = Minecraft.func_71410_x();
            boolean hasOverstep = ClientForgeEventHandler.hasOverstep((PlayerEntity)player);
            if (hasOverstep && !player.func_225608_bj_() && (player.field_70138_W < 1.0f || player.func_189809_N())) {
                player.field_70138_W = 1.25f;
                player.field_189811_cr = false;
            } else if (player.field_70138_W > 1.2f) {
                player.field_70138_W = 0.6f;
                player.field_189811_cr = mc.field_71474_y.field_189989_R;
            }
        }
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            Minecraft mc = Minecraft.func_71410_x();
            if (mc.field_71439_g != null && mc.field_71439_g.func_110317_t() && mc.field_71439_g.func_184187_bx() instanceof PegasusEntity) {
                mc.field_71439_g.field_110320_a = -10;
                if (mc.field_71439_g.field_71158_b.field_78901_c && !wasJumping) {
                    wasJumping = true;
                } else if (!mc.field_71439_g.field_71158_b.field_78901_c && wasJumping) {
                    wasJumping = false;
                    ((PegasusEntity)mc.field_71439_g.func_184187_bx()).flyingJump();
                }
            }
        }
    }

    @SubscribeEvent
    public static void modifyFOV(EntityViewRenderEvent.FOVModifier event) {
        ClientPlayerEntity player;
        Minecraft mc = Minecraft.func_71410_x();
        if (mc != null && GreekFantasy.CONFIG.isForceFOVReset() && (player = mc.field_71439_g).func_70089_S() && (ClientForgeEventHandler.isStunned((LivingEntity)player) || player.func_184582_a(EquipmentSlotType.FEET).func_77973_b() == GFRegistry.WINGED_SANDALS)) {
            event.setFOV(mc.field_71474_y.field_74334_X);
        }
    }

    private static boolean hasHelmOfDarkness(PlayerEntity player) {
        return player.func_184582_a(EquipmentSlotType.HEAD).func_77973_b() == GFRegistry.HELM_OF_DARKNESS;
    }

    private static boolean hasOverstep(PlayerEntity player) {
        return EnchantmentHelper.func_77506_a((Enchantment)GFRegistry.OVERSTEP_ENCHANTMENT, (ItemStack)player.func_184582_a(EquipmentSlotType.FEET)) > 0;
    }

    private static boolean hasSilkstep(PlayerEntity player) {
        return EnchantmentHelper.func_77506_a((Enchantment)GFRegistry.SILKSTEP_ENCHANTMENT, (ItemStack)player.func_184582_a(EquipmentSlotType.FEET)) > 0;
    }

    private static boolean isStunned(LivingEntity livingEntity) {
        return livingEntity.func_70644_a(GFRegistry.PETRIFIED_EFFECT) || livingEntity.func_70644_a(GFRegistry.STUNNED_EFFECT);
    }

    private static boolean isSwine(LivingEntity livingEntity) {
        return livingEntity.func_70644_a(GFRegistry.SWINE_EFFECT);
    }
}

