/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.event;

import greekfantasy.GFRegistry;
import greekfantasy.GFWorldSavedData;
import greekfantasy.GreekFantasy;
import greekfantasy.deity.favor.Favor;
import greekfantasy.deity.favor.FavorManager;
import greekfantasy.deity.favor.IFavor;
import greekfantasy.deity.favor_effect.ConfiguredSpecialFavorEffect;
import greekfantasy.deity.favor_effect.SpecialFavorEffect;
import greekfantasy.entity.ai.FleeFromFavorablePlayerGoal;
import greekfantasy.entity.ai.NearestAttackableFavorablePlayerGoal;
import greekfantasy.entity.ai.NearestAttackableFavorablePlayerResetGoal;
import greekfantasy.network.CUseEnchantmentPacket;
import greekfantasy.network.SSimpleParticlesPacket;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ArrowEntity;
import net.minecraft.entity.projectile.SpectralArrowEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.BabyEntitySpawnEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerXpEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.network.PacketDistributor;

public class CommonFavorEventHandler {
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onPlayerDeath(LivingDeathEvent event) {
        if (!event.isCanceled() && event.getEntityLiving() instanceof PlayerEntity && !event.getEntityLiving().func_130014_f_().func_201670_d()) {
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            Entity source = event.getSource().func_76346_g();
            if (source instanceof LivingEntity && !player.func_175149_v() && !player.func_184812_l_()) {
                player.getCapability(GreekFantasy.FAVOR).ifPresent(f -> FavorManager.onPlayerKilled(player, (Entity)((LivingEntity)source), f));
            }
        }
    }

    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        if (!event.isCanceled() && event.getSource().func_76346_g() instanceof PlayerEntity && !event.getEntityLiving().func_130014_f_().func_201670_d()) {
            event.getSource().func_76346_g().getCapability(GreekFantasy.FAVOR).ifPresent(f -> FavorManager.onKillEntity(event.getEntityLiving(), (PlayerEntity)event.getSource().func_76346_g(), f));
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        boolean tick;
        boolean bl = tick = event.phase == TickEvent.Phase.START && event.player.func_70089_S();
        if (tick && event.player.func_70613_aW() && !event.player.func_130014_f_().func_201670_d()) {
            event.player.getCapability(GreekFantasy.FAVOR).ifPresent(f -> FavorManager.onPlayerTick(event.player, f));
        }
    }

    @SubscribeEvent
    public static void onPlayerXP(PlayerXpEvent.PickupXp event) {
        if (!event.getPlayer().func_130014_f_().func_201670_d() && event.getPlayer().func_70613_aW()) {
            event.getPlayer().getCapability(GreekFantasy.FAVOR).ifPresent(f -> {
                event.getOrb().field_70530_e = FavorManager.onPlayerXP(event.getPlayer(), f, event.getOrb().field_70530_e);
            });
        }
    }

    @SubscribeEvent
    public static void onAddPotion(PotionEvent.PotionAddedEvent event) {
        if (!event.getEntityLiving().func_130014_f_().func_201670_d() && event.getEntityLiving() instanceof PlayerEntity) {
            event.getEntityLiving().getCapability(GreekFantasy.FAVOR).ifPresent(f -> FavorManager.onAddPotion((PlayerEntity)event.getEntityLiving(), event.getPotionEffect(), f));
        }
    }

    @SubscribeEvent
    public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof PlayerEntity) {
            event.addCapability(IFavor.REGISTRY_NAME, (ICapabilityProvider)new Favor.Provider());
        }
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        LazyOptional original = event.getOriginal().getCapability(GreekFantasy.FAVOR);
        LazyOptional copy = event.getPlayer().getCapability(GreekFantasy.FAVOR);
        if (original.isPresent() && copy.isPresent()) {
            copy.ifPresent(f -> f.deserializeNBT(((IFavor)original.orElseGet(() -> (IFavor)GreekFantasy.FAVOR.getDefaultInstance())).serializeNBT()));
        }
    }

    @SubscribeEvent
    public static void onPlayerAttack(AttackEntityEvent event) {
        if (!(event.isCanceled() || event.getEntityLiving().func_130014_f_().func_201670_d() || !event.getPlayer().func_70089_S() || event.getPlayer().func_175149_v() || event.getPlayer().func_184812_l_())) {
            event.getPlayer().getCapability(GreekFantasy.FAVOR).ifPresent(f -> FavorManager.onAttackEntity(event.getEntityLiving(), event.getPlayer(), f));
        }
    }

    @SubscribeEvent
    public static void onPlayerAttacked(LivingAttackEvent event) {
        if (!event.isCanceled() && event.getEntityLiving().func_70613_aW() && event.getEntityLiving() instanceof PlayerEntity && event.getSource().func_76364_f() != null && !event.getEntityLiving().func_175149_v() && !((PlayerEntity)event.getEntityLiving()).func_184812_l_()) {
            ((PlayerEntity)event.getEntityLiving()).getCapability(GreekFantasy.FAVOR).ifPresent(f -> FavorManager.onPlayerHurt((PlayerEntity)event.getEntityLiving(), event.getSource().func_76364_f(), f));
        }
    }

    @SubscribeEvent
    public static void onChangeEquipment(LivingEquipmentChangeEvent event) {
        if (GreekFantasy.CONFIG.isFlyingEnabled() && event.getEntityLiving() instanceof PlayerEntity && event.getEntityLiving().func_130014_f_() instanceof ServerWorld && event.getSlot() == EquipmentSlotType.FEET && event.getTo().func_77973_b() == GFRegistry.WINGED_SANDALS && EnchantmentHelper.func_77506_a((Enchantment)GFRegistry.FLYING_ENCHANTMENT, (ItemStack)event.getTo()) > 0) {
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            GFWorldSavedData data = GFWorldSavedData.getOrCreate((ServerWorld)player.func_130014_f_());
            if (GreekFantasy.PROXY.getFavorConfiguration().getEnchantmentRange("flying_enchantment").isInFavorRange(player)) {
                data.addFlyingPlayer(player);
            }
        }
    }

    @SubscribeEvent
    public static void onBreakBlock(BlockEvent.BreakEvent event) {
        if (event.getPlayer() != null && event.getPlayer().func_70613_aW() && !event.getPlayer().func_184812_l_()) {
            event.getPlayer().getCapability(GreekFantasy.FAVOR).ifPresent(f -> FavorManager.onBreakBlock(event.getPlayer(), event.getState().func_177230_c(), f));
        }
    }

    @SubscribeEvent
    public static void onStopUsingTrident(LivingEntityUseItemEvent.Stop event) {
        ItemStack item = event.getEntityLiving().func_184614_ca();
        if (!event.isCanceled() && event.getEntityLiving() instanceof PlayerEntity && GreekFantasy.CONFIG.isLordOfTheSeaEnabled() && item.func_77973_b() == Items.field_203184_eO && EnchantmentHelper.func_77506_a((Enchantment)GFRegistry.LORD_OF_THE_SEA_ENCHANTMENT, (ItemStack)item) > 0 && !((PlayerEntity)event.getEntityLiving()).func_184811_cZ().func_185141_a(Items.field_203184_eO)) {
            GreekFantasy.CHANNEL.sendToServer((Object)new CUseEnchantmentPacket(GFRegistry.LORD_OF_THE_SEA_ENCHANTMENT.getRegistryName()));
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onUseClock(PlayerInteractEvent.RightClickEmpty event) {
        ItemStack item = event.getPlayer().func_184614_ca();
        if (!event.isCanceled() && GreekFantasy.CONFIG.isDaybreakEnabled() && item.func_77973_b() == Items.field_151113_aN && EnchantmentHelper.func_77506_a((Enchantment)GFRegistry.DAYBREAK_ENCHANTMENT, (ItemStack)item) > 0 && event.getPlayer().func_130014_f_().func_82736_K().func_223586_b(GameRules.field_223607_j) && event.getPlayer().func_130014_f_().func_72820_D() % 24000L > 13000L) {
            GreekFantasy.CHANNEL.sendToServer((Object)new CUseEnchantmentPacket(GFRegistry.DAYBREAK_ENCHANTMENT.getRegistryName()));
        }
    }

    @SubscribeEvent
    public static void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        if (!event.getPlayer().func_130014_f_().func_201670_d() && event.getTarget() instanceof AbstractVillagerEntity) {
            AbstractVillagerEntity villager = (AbstractVillagerEntity)event.getTarget();
            event.getPlayer().getCapability(GreekFantasy.FAVOR).ifPresent(f -> {
                for (ConfiguredSpecialFavorEffect effect : GreekFantasy.PROXY.getFavorConfiguration().getSpecials(SpecialFavorEffect.Type.TRADING_CANCEL)) {
                    if (!effect.canApply(event.getPlayer(), (IFavor)f)) continue;
                    event.setCanceled(true);
                    villager.func_213720_r(40);
                    villager.func_184185_a(SoundEvents.field_187913_gm, 0.5f, 1.0f);
                    GreekFantasy.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new SSimpleParticlesPacket(false, event.getTarget().func_233580_cy_().func_177981_b(1), 4));
                    return;
                }
            });
        }
    }

    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof MobEntity && !event.getEntity().func_130014_f_().func_201670_d() && GreekFantasy.PROXY.getFavorConfiguration().hasEntity(event.getEntity().func_200600_R()) && GreekFantasy.PROXY.getFavorConfiguration().getEntity(event.getEntity().func_200600_R()).hasHostileRange()) {
            MobEntity mob = (MobEntity)event.getEntity();
            mob.field_70715_bh.func_75776_a(0, (Goal)new NearestAttackableFavorablePlayerGoal(mob));
            mob.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableFavorablePlayerResetGoal(mob));
        }
        if (event.getEntity() instanceof CreatureEntity && !event.getEntity().func_130014_f_().func_201670_d() && GreekFantasy.PROXY.getFavorConfiguration().hasEntity(event.getEntity().func_200600_R()) && GreekFantasy.PROXY.getFavorConfiguration().getEntity(event.getEntity().func_200600_R()).hasFleeRange()) {
            CreatureEntity creature = (CreatureEntity)event.getEntity();
            creature.field_70714_bg.func_75776_a(1, (Goal)new FleeFromFavorablePlayerGoal(creature));
        }
    }

    @SubscribeEvent
    public static void onArrowJoinWorld(EntityJoinWorldEvent event) {
        AbstractArrowEntity arrow;
        Entity thrower;
        if ((event.getEntity() instanceof ArrowEntity || event.getEntity() instanceof SpectralArrowEntity) && !event.getEntity().func_130014_f_().func_201670_d() && (thrower = (arrow = (AbstractArrowEntity)event.getEntity()).func_234616_v_()) instanceof PlayerEntity) {
            thrower.getCapability(GreekFantasy.FAVOR).ifPresent(f -> FavorManager.onShootArrow((PlayerEntity)thrower, f, arrow));
        }
    }

    @SubscribeEvent
    public static void onBabySpawn(BabyEntitySpawnEvent event) {
        World world = event.getParentA().func_130014_f_();
        if (!event.isCanceled() && world instanceof ServerWorld && event.getCausedByPlayer() != null && !event.getCausedByPlayer().func_184812_l_() && !event.getCausedByPlayer().func_175149_v() && event.getParentA() instanceof AnimalEntity && event.getParentB() instanceof AnimalEntity) {
            event.getCausedByPlayer().getCapability(GreekFantasy.FAVOR).ifPresent(f -> {
                int numBabies = FavorManager.onBabySpawn(event.getCausedByPlayer(), f);
                if (numBabies < 1) {
                    event.setCanceled(true);
                } else if (numBabies > 1) {
                    for (int i = 1; i < numBabies; ++i) {
                        AgeableEntity bonusChild = (AgeableEntity)event.getParentA().func_200600_R().func_200721_a(event.getParentA().func_130014_f_());
                        if (bonusChild == null) continue;
                        bonusChild.func_82149_j((Entity)event.getParentA());
                        bonusChild.func_82227_f(true);
                        world.func_217376_c((Entity)bonusChild);
                    }
                }
            });
        }
    }

    @SubscribeEvent
    public static void onLivingTarget(LivingSetAttackTargetEvent event) {
        if (!event.getEntityLiving().func_130014_f_().func_201670_d() && event.getEntityLiving() instanceof MobEntity && event.getTarget() instanceof PlayerEntity && ((IFavor)event.getTarget().getCapability(GreekFantasy.FAVOR).orElse(GreekFantasy.FAVOR.getDefaultInstance())).isEnabled() && GreekFantasy.PROXY.getFavorConfiguration().hasEntity(event.getEntityLiving().func_200600_R()) && !GreekFantasy.PROXY.getFavorConfiguration().getEntity(event.getEntityLiving().func_200600_R()).getHostileRange().isInFavorRange((PlayerEntity)event.getTarget()) && event.getTarget() != event.getEntityLiving().func_70643_av()) {
            ((MobEntity)event.getEntityLiving()).func_70624_b(null);
        }
    }
}

