/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.event;

import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.CommandDispatcher;
import greekfantasy.GFRegistry;
import greekfantasy.GFWorldGen;
import greekfantasy.GFWorldSavedData;
import greekfantasy.GreekFantasy;
import greekfantasy.deity.Deity;
import greekfantasy.deity.favor.FavorCommand;
import greekfantasy.deity.favor.FavorConfiguration;
import greekfantasy.entity.ArionEntity;
import greekfantasy.entity.CerastesEntity;
import greekfantasy.entity.CirceEntity;
import greekfantasy.entity.DryadEntity;
import greekfantasy.entity.GeryonEntity;
import greekfantasy.entity.GiantBoarEntity;
import greekfantasy.entity.GoldenRamEntity;
import greekfantasy.entity.NemeanLionEntity;
import greekfantasy.entity.ShadeEntity;
import greekfantasy.item.AchillesArmorItem;
import greekfantasy.item.NemeanLionHideItem;
import greekfantasy.network.SDeityPacket;
import greekfantasy.network.SFavorConfigurationPacket;
import greekfantasy.network.SPanfluteSongPacket;
import greekfantasy.network.SSwineEffectPacket;
import greekfantasy.util.Song;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.command.CommandSource;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.HoglinEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.CowEntity;
import net.minecraft.entity.passive.RabbitEntity;
import net.minecraft.entity.passive.SheepEntity;
import net.minecraft.entity.passive.horse.HorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effects;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Difficulty;
import net.minecraft.world.GameRules;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.EntityStruckByLightningEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.network.PacketDistributor;

public class CommonForgeEventHandler {
    protected static final Tags.IOptionalNamedTag<Item> GIANT_BOAR_TRIGGER = ItemTags.createOptional((ResourceLocation)new ResourceLocation("greekfantasy", "giant_boar_trigger"));
    protected static final Tags.IOptionalNamedTag<Item> ARION_TRIGGER = ItemTags.createOptional((ResourceLocation)new ResourceLocation("greekfantasy", "arion_trigger"));

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onPlayerDeath(LivingDeathEvent event) {
        if (!event.isCanceled() && event.getEntityLiving().func_70613_aW() && event.getEntityLiving() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            if (GreekFantasy.CONFIG.doesShadeSpawnOnDeath() && !player.func_130014_f_().func_82736_K().func_223586_b(GameRules.field_223600_c) && !player.func_175149_v() && player.field_71068_ca > 3) {
                int xp = player.field_71067_cb;
                player.func_82242_a(-(player.field_71068_ca + 1));
                ShadeEntity shade = (ShadeEntity)GFRegistry.SHADE_ENTITY.func_200721_a(player.func_130014_f_());
                shade.func_70012_b(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), player.field_70177_z, player.field_70125_A);
                shade.setStoredXP((int)((float)xp * (0.4f + player.func_70681_au().nextFloat() * 0.2f)));
                shade.setOwnerUniqueId(PlayerEntity.func_175147_b((String)player.func_145748_c_().func_150261_e()));
                shade.func_110163_bv();
                player.func_130014_f_().func_217376_c((Entity)shade);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        if (!event.isCanceled() && event.getEntityLiving().func_70613_aW() && event.getSource().func_76346_g() instanceof PlayerEntity) {
            BlockPos deathPos = event.getEntityLiving().func_233580_cy_();
            if (event.getEntityLiving() instanceof CowEntity && GeryonEntity.canGeryonSpawnOn((IWorld)event.getEntityLiving().func_130014_f_(), deathPos)) {
                ArrayList<BlockPos> heads = new ArrayList<BlockPos>();
                int r = 3;
                block0: for (int x = -3; x <= 3; ++x) {
                    for (int y = -2; y <= 2; ++y) {
                        for (int z = -3; z <= 3; ++z) {
                            BlockPos pos = deathPos.func_177982_a(x, y, z);
                            if (event.getEntityLiving().func_130014_f_().func_180495_p(pos).func_203425_a(GFRegistry.GIGANTE_HEAD)) {
                                heads.add(pos);
                            }
                            if (heads.size() >= 3) break block0;
                        }
                    }
                }
                if (heads.size() >= 3) {
                    heads.subList(0, 3).forEach(p -> event.getEntityLiving().func_130014_f_().func_175655_b(p, false));
                    float yaw = MathHelper.func_76142_g((float)(event.getSource().func_76346_g().field_70177_z + 180.0f));
                    GeryonEntity.spawnGeryon(event.getEntityLiving().func_130014_f_(), deathPos, yaw);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START && event.player.func_70089_S()) {
            boolean isRidingLion = event.player.func_184187_bx() instanceof NemeanLionEntity;
            Pose currentPose = event.player.getForcedPose();
            if (isRidingLion && currentPose != Pose.FALL_FLYING) {
                event.player.setForcedPose(Pose.FALL_FLYING);
                event.player.func_213301_b(Pose.FALL_FLYING);
            } else if (!isRidingLion && Pose.FALL_FLYING == currentPose) {
                event.player.setForcedPose(null);
            }
            if (GreekFantasy.CONFIG.isSwineEnabled()) {
                boolean isSwine = CommonForgeEventHandler.isSwine((LivingEntity)event.player);
                Pose forcedPose = event.player.getForcedPose();
                if (isSwine && GreekFantasy.CONFIG.doesSwineDropArmor() && event.player.func_70681_au().nextInt(20) == 0) {
                    ImmutableList armor = ImmutableList.copyOf((Iterable)event.player.func_184193_aE());
                    event.player.func_184201_a(EquipmentSlotType.HEAD, ItemStack.field_190927_a);
                    event.player.func_184201_a(EquipmentSlotType.CHEST, ItemStack.field_190927_a);
                    event.player.func_184201_a(EquipmentSlotType.LEGS, ItemStack.field_190927_a);
                    event.player.func_184201_a(EquipmentSlotType.FEET, ItemStack.field_190927_a);
                    for (ItemStack i : armor) {
                        ItemEntity item = event.player.func_199701_a_(i);
                        if (item == null) continue;
                        item.func_174868_q();
                    }
                }
                if (isSwine && forcedPose != Pose.FALL_FLYING) {
                    event.player.setForcedPose(Pose.FALL_FLYING);
                    event.player.func_213301_b(Pose.FALL_FLYING);
                } else if (!isSwine && Pose.FALL_FLYING == forcedPose) {
                    event.player.setForcedPose(null);
                }
            }
            if (GreekFantasy.CONFIG.isSilkwalkerEnabled() && CommonForgeEventHandler.hasSilkstep(event.player) && !event.player.field_71075_bZ.field_75100_b && event.player.field_213328_B != Vector3d.field_186680_a) {
                boolean cobweb = false;
                AxisAlignedBB axisalignedbb = event.player.func_174813_aQ();
                BlockPos blockpos = new BlockPos(axisalignedbb.field_72340_a + 0.001, axisalignedbb.field_72338_b + 0.001, axisalignedbb.field_72339_c + 0.001);
                BlockPos blockpos1 = new BlockPos(axisalignedbb.field_72336_d - 0.001, axisalignedbb.field_72337_e - 0.001, axisalignedbb.field_72334_f - 0.001);
                BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
                if (event.player.field_70170_p.func_175707_a(blockpos, blockpos1)) {
                    block1: for (int i = blockpos.func_177958_n(); i <= blockpos1.func_177958_n(); ++i) {
                        for (int j = blockpos.func_177956_o(); j <= blockpos1.func_177956_o(); ++j) {
                            for (int k = blockpos.func_177952_p(); k <= blockpos1.func_177952_p(); ++k) {
                                blockpos$mutable.func_181079_c(i, j, k);
                                if (!event.player.field_70170_p.func_180495_p((BlockPos)blockpos$mutable).func_203425_a(Blocks.field_196553_aF)) continue;
                                cobweb = true;
                                break block1;
                            }
                        }
                    }
                    if (cobweb) {
                        event.player.field_213328_B = Vector3d.field_186680_a;
                    }
                }
            }
            if (event.player.field_70173_aa % 4 == 0 && (event.player.func_184614_ca().func_77973_b() == GFRegistry.GOLDEN_BALL || event.player.func_184592_cb().func_77973_b() == GFRegistry.GOLDEN_BALL)) {
                boolean replaceable;
                BlockPos pos = event.player.func_233580_cy_();
                BlockState current = event.player.func_130014_f_().func_180495_p(pos);
                BlockState string = (BlockState)GFRegistry.GOLDEN_STRING_BLOCK.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(current.func_204520_s().func_206886_c().func_207185_a((ITag)FluidTags.field_206959_a)));
                boolean bl = replaceable = current.func_185904_a() == Material.field_151579_a || current.func_185904_a() == Material.field_151586_h;
                if (replaceable && current.func_177230_c() != GFRegistry.GOLDEN_STRING_BLOCK && string.func_196955_c((IWorldReader)event.player.func_130014_f_(), pos)) {
                    event.player.func_130014_f_().func_180501_a(pos, string, 3);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onAddPotion(PotionEvent.PotionAddedEvent event) {
        if (!event.getEntityLiving().func_130014_f_().func_201670_d() && GreekFantasy.CONFIG.isSwineEnabled() && event.getPotionEffect().func_188419_a() == GFRegistry.SWINE_EFFECT && GreekFantasy.CONFIG.canSwineApply(event.getEntityLiving().func_200600_R().getRegistryName().toString())) {
            int id = event.getEntityLiving().func_145782_y();
            GreekFantasy.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new SSwineEffectPacket(id, event.getPotionEffect().func_76459_b()));
        }
    }

    @SubscribeEvent
    public static void onPlayerInteract(PlayerInteractEvent event) {
        if (GreekFantasy.CONFIG.doesStunPreventUse() && event.getPlayer().func_70089_S() && CommonForgeEventHandler.isStunned((LivingEntity)event.getPlayer()) && event.isCancelable()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onPlayerInteract(PlayerInteractEvent.EntityInteract event) {
        HorseEntity horse;
        if (!event.isCanceled() && (!GreekFantasy.CONFIG.getGiantBoarNonNether() || event.getWorld().func_234923_W_() != World.field_234919_h_) && event.getTarget().func_200600_R() == EntityType.field_233588_G_ && event.getTarget() instanceof HoglinEntity && event.getWorld() instanceof ServerWorld && GIANT_BOAR_TRIGGER.func_230235_a_((Object)event.getItemStack().func_77973_b())) {
            HoglinEntity hoglin = (HoglinEntity)event.getTarget();
            if (!hoglin.func_70631_g_()) {
                GiantBoarEntity.spawnGiantBoar((ServerWorld)event.getWorld(), hoglin);
                if (!event.getPlayer().func_184812_l_()) {
                    event.getItemStack().func_190918_g(1);
                }
            }
        } else if (!event.isCanceled() && event.getTarget().func_200600_R() == EntityType.field_200762_B && event.getTarget() instanceof HorseEntity && event.getWorld() instanceof ServerWorld && ARION_TRIGGER.func_230235_a_((Object)event.getItemStack().func_77973_b()) && !(horse = (HorseEntity)event.getTarget()).func_70631_g_() && horse.func_110248_bS()) {
            ArionEntity.spawnArion((ServerWorld)event.getWorld(), event.getPlayer(), horse);
            if (!event.getPlayer().func_184812_l_()) {
                event.getItemStack().func_190918_g(1);
            }
        }
    }

    @SubscribeEvent
    public static void onProjectileImpact(ProjectileImpactEvent.Arrow event) {
        AbstractArrowEntity arrow = event.getArrow();
        if (!event.isCanceled() && !arrow.func_130014_f_().func_201670_d() && event.getRayTraceResult().func_216346_c() == RayTraceResult.Type.ENTITY) {
            Entity entity = ((EntityRayTraceResult)event.getRayTraceResult()).func_216348_a();
            double damage = arrow.func_70242_d();
            if (entity instanceof LivingEntity) {
                int achillesArmor = CommonForgeEventHandler.countAchillesArmor((LivingEntity)entity);
                float critChance = -1.0f;
                float immuneChance = -1.0f;
                if (CommonForgeEventHandler.isWearingNemeanHide((LivingEntity)entity)) {
                    immuneChance = NemeanLionHideItem.getProjectileImmunityChance();
                    damage *= 0.5;
                }
                if (achillesArmor > 0) {
                    immuneChance = Math.max(immuneChance, AchillesArmorItem.getProjectileImmunityChance(achillesArmor));
                    damage *= 0.8;
                    if (arrow.func_226278_cu_() - (double)arrow.func_213302_cg() * 0.5 < entity.func_226278_cu_() + (double)entity.func_213302_cg() * 0.24) {
                        critChance = AchillesArmorItem.getProjectileCritChance(achillesArmor);
                    }
                }
                if (critChance > 0.0f && Math.random() < (double)critChance) {
                    arrow.func_70239_b(arrow.func_70242_d() * (2.0 + 0.5 * (double)achillesArmor));
                } else if (immuneChance > 0.0f && Math.random() < (double)immuneChance) {
                    event.setCanceled(true);
                    damage = 0.0;
                    arrow.func_213317_d(arrow.func_213322_ci().func_216372_d(-0.45, 0.65, -0.45));
                }
                arrow.func_70239_b(damage);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerAttack(AttackEntityEvent event) {
        if (GreekFantasy.CONFIG.doesStunPreventUse() && event.getPlayer().func_70089_S() && CommonForgeEventHandler.isStunned((LivingEntity)event.getPlayer())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onLivingJump(LivingEvent.LivingJumpEvent event) {
        if (GreekFantasy.CONFIG.doesStunPreventJump() && CommonForgeEventHandler.isStunned(event.getEntityLiving())) {
            event.getEntityLiving().func_213317_d(event.getEntityLiving().func_213322_ci().func_72441_c(0.0, -0.42, 0.0));
        }
    }

    @SubscribeEvent
    public static void onBreakBlock(BlockEvent.BreakEvent event) {
        if (GreekFantasy.CONFIG.isDryadAngryOnHarvest() && event.getPlayer() != null && !event.getPlayer().func_184812_l_() && event.getState().func_235714_a_((ITag)BlockTags.field_200031_h)) {
            AxisAlignedBB aabb = new AxisAlignedBB(event.getPos()).func_186662_g((double)GreekFantasy.CONFIG.getDryadAngryRange());
            List dryads = event.getWorld().func_217357_a(DryadEntity.class, aabb);
            for (DryadEntity dryad : dryads) {
                if (!DryadEntity.isTreeAt((IWorldReader)event.getWorld(), event.getPos().func_177979_c(1), dryad.getVariant().getLogs()) && !DryadEntity.isTreeAt((IWorldReader)event.getWorld(), event.getPos().func_177979_c(2), dryad.getVariant().getLogs())) continue;
                GreekFantasy.LOGGER.debug("angry!");
                dryad.func_70604_c((LivingEntity)event.getPlayer());
                dryad.func_230259_a_(event.getPlayer().func_110124_au());
                dryad.func_230258_H__();
                dryad.tryExitTree();
            }
        }
    }

    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinWorldEvent event) {
        RabbitEntity rabbit;
        if (event.getEntity() != null && event.getEntity().func_200600_R() == EntityType.field_200736_ab && !event.getEntity().func_130014_f_().func_201670_d() && (rabbit = (RabbitEntity)event.getEntity()).func_175531_cl() != 99) {
            rabbit.field_70714_bg.func_75776_a(4, (Goal)new AvoidEntityGoal((CreatureEntity)rabbit, CerastesEntity.class, e -> !((CerastesEntity)e).isHiding(), 6.0f, 2.2, 2.2, EntityPredicates.field_188444_d::test));
        }
    }

    @SubscribeEvent
    public static void onEntitySpawn(LivingSpawnEvent.SpecialSpawn event) {
        SheepEntity sheep;
        if (event.getEntity() != null && event.getEntity().func_200600_R() == EntityType.field_200759_ay && event.getWorld().func_201674_k().nextDouble() * 100.0 < GreekFantasy.CONFIG.getCirceChance() && event.getWorld() instanceof World) {
            event.setCanceled(true);
            CirceEntity circe = (CirceEntity)GFRegistry.CIRCE_ENTITY.func_200721_a((World)event.getWorld());
            circe.func_70012_b(event.getX(), event.getY(), event.getZ(), 0.0f, 0.0f);
            event.getWorld().func_217376_c((Entity)circe);
        }
        if (event.getEntity() != null && event.getEntity().func_200600_R() == EntityType.field_200737_ac && event.getWorld() instanceof World && (sheep = (SheepEntity)event.getEntity()).func_175509_cj() == DyeColor.YELLOW && event.getWorld().func_201674_k().nextDouble() * 100.0 < GreekFantasy.CONFIG.getGoldenRamChance()) {
            event.setCanceled(true);
            GoldenRamEntity ram = (GoldenRamEntity)GFRegistry.GOLDEN_RAM_ENTITY.func_200721_a((World)event.getWorld());
            ram.func_70012_b(event.getX(), event.getY(), event.getZ(), 0.0f, 0.0f);
            event.getWorld().func_217376_c((Entity)ram);
        }
    }

    @SubscribeEvent
    public static void onEntityStruckByLightning(EntityStruckByLightningEvent event) {
        if (event.getEntity() instanceof LivingEntity && event.getEntity().func_200600_R() == EntityType.field_200781_U && ((LivingEntity)event.getEntity()).func_70660_b(Effects.field_76420_g) != null && event.getEntity().field_70170_p.func_175659_aa() != Difficulty.PEACEFUL && (double)event.getEntity().field_70170_p.field_73012_v.nextInt(100) < GreekFantasy.CONFIG.getLightningLionChance()) {
            NemeanLionEntity lion = (NemeanLionEntity)GFRegistry.NEMEAN_LION_ENTITY.func_200721_a(event.getEntity().field_70170_p);
            lion.func_82149_j(event.getEntity());
            if (event.getEntity().func_145818_k_()) {
                lion.func_200203_b(event.getEntity().func_200201_e());
                lion.func_174805_g(event.getEntity().func_174833_aM());
            }
            lion.func_110163_bv();
            event.getEntity().func_130014_f_().func_217376_c((Entity)lion);
            event.getEntity().func_70106_y();
        }
    }

    @SubscribeEvent
    public static void onLivingCheckSpawn(LivingSpawnEvent.CheckSpawn event) {
        int cRadius = GreekFantasy.CONFIG.getPalladiumChunkRange();
        int cVertical = GreekFantasy.CONFIG.getPalladiumYRange() / 2;
        if (GreekFantasy.CONFIG.isPalladiumEnabled() && !event.getEntityLiving().func_130014_f_().func_201670_d() && event.getWorld() instanceof ServerWorld && event.getEntityLiving() instanceof IMob && event.getEntityLiving().func_184222_aU()) {
            ServerWorld world = (ServerWorld)event.getWorld();
            BlockPos blockPos = new BlockPos(event.getX(), event.getY(), event.getZ());
            ChunkPos chunkPos = new ChunkPos(blockPos);
            GFWorldSavedData data = GFWorldSavedData.getOrCreate(world);
            for (int cX = -cRadius; cX <= cRadius; ++cX) {
                for (int cZ = -cRadius; cZ <= cRadius; ++cZ) {
                    ChunkPos cPos = new ChunkPos(chunkPos.field_77276_a + cX, chunkPos.field_77275_b + cZ);
                    if (!event.getWorld().func_217354_b(cPos.field_77276_a, cPos.field_77275_b)) continue;
                    for (BlockPos p : data.getPalladium((World)world, cPos)) {
                        if (!GFWorldSavedData.validatePalladium((World)world, p)) {
                            data.removePalladium(cPos, p);
                            continue;
                        }
                        if (Math.abs(p.func_177956_o() - blockPos.func_177956_o()) >= cVertical) continue;
                        event.setResult(Event.Result.DENY);
                        return;
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void onLivingTarget(LivingSetAttackTargetEvent event) {
        if (!event.getEntityLiving().func_130014_f_().func_201670_d() && event.getEntityLiving() instanceof MobEntity && event.getTarget() instanceof LivingEntity && GreekFantasy.CONFIG.isSwineEnabled() && GreekFantasy.CONFIG.doesSwinePreventTarget() && (CommonForgeEventHandler.isSwine(event.getEntityLiving()) || CommonForgeEventHandler.isSwine(event.getTarget()))) {
            ((MobEntity)event.getEntityLiving()).func_70624_b(null);
        }
    }

    @SubscribeEvent
    public static void onBiomeLoad(BiomeLoadingEvent event) {
        GFWorldGen.addBiomeFeatures(event);
        GFWorldGen.addBiomeSpawns(event);
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        PlayerEntity player = event.getPlayer();
        if (player instanceof ServerPlayerEntity) {
            GreekFantasy.PROXY.PANFLUTE_SONGS.getEntries().forEach(e -> GreekFantasy.CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new SPanfluteSongPacket((ResourceLocation)e.getKey(), (Song)((Optional)e.getValue()).get())));
            GreekFantasy.PROXY.DEITY.getEntries().forEach(e -> GreekFantasy.CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new SDeityPacket((ResourceLocation)e.getKey(), (Deity)((Optional)e.getValue()).get())));
            GreekFantasy.PROXY.FAVOR_CONFIGURATION.get(FavorConfiguration.NAME).ifPresent(f -> GreekFantasy.CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new SFavorConfigurationPacket((FavorConfiguration)f)));
        }
    }

    @SubscribeEvent
    public static void onAddReloadListeners(AddReloadListenerEvent event) {
        GreekFantasy.LOGGER.debug("onAddReloadListeners");
        event.addListener(GreekFantasy.PROXY.PANFLUTE_SONGS);
        event.addListener(GreekFantasy.PROXY.DEITY);
        event.addListener(GreekFantasy.PROXY.FAVOR_CONFIGURATION);
    }

    @SubscribeEvent
    public static void onAddCommands(RegisterCommandsEvent event) {
        FavorCommand.register((CommandDispatcher<CommandSource>)event.getDispatcher());
    }

    private static boolean isWearingNemeanHide(LivingEntity livingEntity) {
        return livingEntity.func_184582_a(EquipmentSlotType.HEAD).func_77973_b() == GFRegistry.NEMEAN_LION_HIDE;
    }

    private static int countAchillesArmor(LivingEntity livingEntity) {
        int count = 0;
        for (ItemStack stack : livingEntity.func_184193_aE()) {
            if (!(stack.func_77973_b() instanceof AchillesArmorItem)) continue;
            ++count;
        }
        return count;
    }

    private static boolean isStunned(LivingEntity entity) {
        return entity.func_70644_a(GFRegistry.STUNNED_EFFECT) || entity.func_70644_a(GFRegistry.PETRIFIED_EFFECT);
    }

    private static boolean isSwine(LivingEntity livingEntity) {
        return livingEntity.func_70644_a(GFRegistry.SWINE_EFFECT);
    }

    private static boolean hasSilkstep(PlayerEntity player) {
        return EnchantmentHelper.func_77506_a((Enchantment)GFRegistry.SILKSTEP_ENCHANTMENT, (ItemStack)player.func_184582_a(EquipmentSlotType.FEET)) > 0;
    }
}

