/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.event;

import greekfantasy.deity.IDeity;
import greekfantasy.deity.favor.FavorLevel;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.IStringSerializable;
import net.minecraftforge.event.entity.player.PlayerEvent;

public class FavorChangedEvent
extends PlayerEvent {
    private final IDeity deity;
    private final long oldFavor;
    private final Source source;
    private long newFavor;
    private boolean isLevelChange;

    public FavorChangedEvent(PlayerEntity playerIn, IDeity deityIn, long prevFavor, long curFavor, Source sourceIn) {
        super(playerIn);
        this.deity = deityIn;
        this.oldFavor = prevFavor;
        this.newFavor = curFavor;
        this.source = sourceIn;
        this.isLevelChange = FavorLevel.calculateLevel(curFavor) != FavorLevel.calculateLevel(prevFavor);
    }

    public IDeity getDeity() {
        return this.deity;
    }

    public long getOldFavor() {
        return this.oldFavor;
    }

    public long getNewFavor() {
        return this.newFavor;
    }

    public void setNewFavor(long favor) {
        this.newFavor = favor;
        this.isLevelChange = FavorLevel.calculateLevel(this.newFavor) != FavorLevel.calculateLevel(this.oldFavor);
    }

    public Source getSource() {
        return this.source;
    }

    public boolean isLevelChange() {
        return this.isLevelChange;
    }

    public static enum Source implements IStringSerializable
    {
        PASSIVE("passive"),
        GIVE_ITEM("item"),
        KILL_ENTITY("kill"),
        ATTACK_ENTITY("attack"),
        COMMAND("command"),
        OTHER("other");

        private final String name;

        private Source(String sourceName) {
            this.name = sourceName;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

