/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.feature;

import com.mojang.serialization.Codec;
import greekfantasy.GFRegistry;
import greekfantasy.entity.AraEntity;
import greekfantasy.feature.SimpleTemplateFeature;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.template.BlockIgnoreStructureProcessor;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class AraCampFeature
extends SimpleTemplateFeature {
    private static final ResourceLocation STRUCTURE_TENT_CHEST = new ResourceLocation("greekfantasy", "ara_camp/ara_tent_with_chest");
    private static final ResourceLocation STRUCTURE_TENT_NOCHEST = new ResourceLocation("greekfantasy", "ara_camp/ara_tent");

    public AraCampFeature(Codec<NoFeatureConfig> codec) {
        super(codec);
    }

    public boolean generate(ISeedReader reader, ChunkGenerator chunkGenerator, Random rand, BlockPos blockPosIn, NoFeatureConfig config) {
        if (!SimpleTemplateFeature.isValidDimension(reader)) {
            return false;
        }
        TemplateManager manager = reader.func_201672_e().func_184163_y();
        int tentsGenerated = 0;
        Rotation rotation = Rotation.func_222466_a((Random)rand);
        Mirror mirror = Mirror.NONE;
        BlockPos tentPos = AraCampFeature.getHeightPos(reader, blockPosIn.func_177982_a(4 + rand.nextInt(8), 0, 4 + rand.nextInt(8)));
        PlacementSettings placement = new PlacementSettings().func_186220_a(rotation).func_186214_a(mirror).func_189950_a(rand).func_215222_a((StructureProcessor)BlockIgnoreStructureProcessor.field_215204_a);
        if (this.generateTent(reader, manager.func_200220_a(this.getStructure(rand)), placement, tentPos, rand)) {
            ++tentsGenerated;
        }
        BlockPos tent2Offset = new BlockPos(-1 - rand.nextInt(4), 0, 7 + rand.nextInt(3)).func_190942_a(rotation);
        tentPos = AraCampFeature.getHeightPos(reader, tentPos.func_177971_a((Vector3i)tent2Offset));
        rotation = rotation.func_185830_a(Rotation.CLOCKWISE_90);
        if (this.generateTent(reader, manager.func_200220_a(this.getStructure(rand)), placement.func_186220_a(rotation), tentPos, rand)) {
            ++tentsGenerated;
        }
        return tentsGenerated > 0;
    }

    protected boolean generateTent(ISeedReader reader, Template template, PlacementSettings placement, BlockPos pos, Random rand) {
        if (!this.isValidPosition(reader, pos, template.func_186259_a().func_177979_c(3), placement.func_186215_c())) {
            return false;
        }
        ChunkPos chunkPos = new ChunkPos(pos);
        MutableBoundingBox mbb = new MutableBoundingBox(chunkPos.func_180334_c() - 8, pos.func_177956_o() - 8, chunkPos.func_180333_d() - 8, chunkPos.func_180332_e() + 8, pos.func_177956_o() + 16, chunkPos.func_180330_f() + 8);
        template.func_237146_a_((IServerWorld)reader, pos.func_177977_b(), pos.func_177977_b(), placement.func_186223_a(mbb), rand, 2);
        AraCampFeature.fillBelow(reader, pos.func_177979_c(2), template.func_186259_a(), placement.func_186215_c(), new Block[]{Blocks.field_150348_b});
        AraCampFeature.addAra(reader, rand, pos.func_177971_a((Vector3i)new BlockPos(3, 1, 2).func_190942_a(placement.func_186215_c())), 1 + rand.nextInt(3));
        return true;
    }

    protected static void addAra(ISeedReader world, Random rand, BlockPos pos, int count) {
        for (int i = 0; i < count; ++i) {
            AraEntity entity = (AraEntity)GFRegistry.ARA_ENTITY.func_200721_a((World)world.func_201672_e());
            entity.func_70012_b((double)pos.func_177958_n() + rand.nextDouble(), (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + rand.nextDouble(), 0.0f, 0.0f);
            entity.func_110163_bv();
            world.func_217376_c((Entity)entity);
        }
    }

    protected static boolean canPlaceOnBlock(ISeedReader world, BlockPos pos) {
        return pos.func_177956_o() > 3 && world.func_180495_p(pos).func_200132_m() && !world.func_180495_p(pos.func_177981_b(3)).func_200132_m();
    }

    @Override
    protected boolean isValidPosition(ISeedReader reader, BlockPos pos) {
        return pos.func_177956_o() > 3 && reader.func_180495_p(pos).func_200132_m() && AraCampFeature.isReplaceableAt((IWorldGenerationReader)reader, pos.func_177981_b(3));
    }

    @Override
    protected ResourceLocation getStructure(Random rand) {
        return rand.nextInt(100) < 38 ? STRUCTURE_TENT_CHEST : STRUCTURE_TENT_NOCHEST;
    }
}

