/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.feature;

import com.mojang.serialization.Codec;
import greekfantasy.feature.SimpleTemplateFeature;
import java.util.Random;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class ArachnePitFeature
extends SimpleTemplateFeature {
    private static final ResourceLocation STRUCTURE_PIT = new ResourceLocation("greekfantasy", "arachne_pit");

    public ArachnePitFeature(Codec<NoFeatureConfig> codec) {
        super(codec);
    }

    public boolean generate(ISeedReader reader, ChunkGenerator chunkGenerator, Random rand, BlockPos blockPosIn, NoFeatureConfig config) {
        if (!SimpleTemplateFeature.isValidDimension(reader)) {
            return false;
        }
        TemplateManager manager = reader.func_201672_e().func_184163_y();
        Template template = manager.func_200219_b(this.getStructure(rand));
        Rotation rotation = Rotation.func_222466_a((Random)rand);
        Mirror mirror = Mirror.NONE;
        BlockPos offset = new BlockPos(-9, 0, -9);
        BlockPos pos = new BlockPos(blockPosIn.func_177958_n(), 8 + rand.nextInt(92), blockPosIn.func_177952_p()).func_177971_a((Vector3i)offset.func_190942_a(rotation));
        ChunkPos chunkPos = new ChunkPos(pos);
        MutableBoundingBox mbb = new MutableBoundingBox(chunkPos.func_180334_c() - 10, pos.func_177956_o() - 16, chunkPos.func_180333_d() - 10, chunkPos.func_180332_e() + 10, pos.func_177956_o() + 16, chunkPos.func_180330_f() + 10);
        PlacementSettings placement = new PlacementSettings().func_186220_a(rotation).func_186214_a(mirror).func_189950_a(rand).func_186223_a(mbb);
        if (!this.isValidPosition(reader, pos, template.func_186259_a(), placement.func_186215_c())) {
            return false;
        }
        template.func_237146_a_((IServerWorld)reader, pos, pos, placement, rand, 2);
        return true;
    }

    protected static boolean canPlaceOnBlock(ISeedReader world, BlockPos pos) {
        return pos.func_177956_o() > 3 && world.func_180495_p(pos).func_200132_m() && !world.func_180495_p(pos.func_177981_b(3)).func_200132_m();
    }

    @Override
    protected boolean isValidPosition(ISeedReader reader, BlockPos pos) {
        return pos.func_177956_o() > 7 && pos.func_177956_o() < 100 && reader.func_180495_p(pos).func_200132_m();
    }

    @Override
    protected ResourceLocation getStructure(Random rand) {
        return STRUCTURE_PIT;
    }
}

