/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.feature;

import com.mojang.serialization.Codec;
import greekfantasy.GFRegistry;
import greekfantasy.entity.CyclopesEntity;
import greekfantasy.feature.SimpleTemplateFeature;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.template.BlockIgnoreStructureProcessor;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class CyclopesCaveFeature
extends SimpleTemplateFeature {
    private static final ResourceLocation STRUCTURE_CAVE = new ResourceLocation("greekfantasy", "cyclopes_cave");

    public CyclopesCaveFeature(Codec<NoFeatureConfig> codec) {
        super(codec);
    }

    public boolean generate(ISeedReader reader, ChunkGenerator chunkGenerator, Random rand, BlockPos blockPosIn, NoFeatureConfig config) {
        if (!SimpleTemplateFeature.isValidDimension(reader)) {
            return false;
        }
        TemplateManager manager = reader.func_201672_e().func_184163_y();
        Template template = manager.func_200219_b(this.getStructure(rand));
        Rotation rotation = Rotation.func_222466_a((Random)rand);
        Mirror mirror = Mirror.NONE;
        BlockPos offset = new BlockPos(-(template.func_186259_a().func_177958_n() / 2), -1, -(template.func_186259_a().func_177952_p() / 2));
        BlockPos heightPos = CyclopesCaveFeature.getHeightPos(reader, blockPosIn.func_177971_a((Vector3i)offset.func_190942_a(rotation)));
        ChunkPos chunkPos = new ChunkPos(heightPos);
        MutableBoundingBox mbb = new MutableBoundingBox(chunkPos.func_180334_c() - 16, heightPos.func_177956_o() - 16, chunkPos.func_180333_d() - 16, chunkPos.func_180332_e() + 16, heightPos.func_177956_o() + 16, chunkPos.func_180330_f() + 16);
        PlacementSettings placement = new PlacementSettings().func_186220_a(rotation).func_186214_a(mirror).func_189950_a(rand).func_186223_a(mbb).func_215222_a((StructureProcessor)BlockIgnoreStructureProcessor.field_215204_a);
        if (!this.isValidPosition(reader, heightPos, template.func_186259_a(), rotation)) {
            return false;
        }
        template.func_237146_a_((IServerWorld)reader, heightPos, heightPos, placement, rand, 2);
        CyclopesCaveFeature.fillBelow(reader, heightPos.func_177977_b(), template.func_186259_a(), rotation, new Block[]{Blocks.field_150346_d});
        BlockPos entityPos = heightPos.func_177973_b((Vector3i)offset.func_177982_a(2, 0, 2).func_190942_a(rotation)).func_177984_a();
        CyclopesEntity entity = (CyclopesEntity)GFRegistry.CYCLOPES_ENTITY.func_200721_a((World)reader.func_201672_e());
        entity.func_70012_b((double)entityPos.func_177958_n() + rand.nextDouble(), (double)entityPos.func_177956_o() + 0.5, (double)entityPos.func_177952_p() + rand.nextDouble(), 0.0f, 0.0f);
        entity.func_110163_bv();
        reader.func_217376_c((Entity)entity);
        return true;
    }

    protected static boolean canPlaceOnBlock(ISeedReader world, BlockPos pos) {
        return pos.func_177956_o() > 3 && world.func_180495_p(pos).func_200132_m() && !world.func_180495_p(pos.func_177981_b(3)).func_200132_m();
    }

    @Override
    protected boolean isValidPosition(ISeedReader reader, BlockPos pos) {
        return pos.func_177956_o() > 11 && pos.func_177956_o() < 200 && reader.func_180495_p(pos).func_200132_m();
    }

    @Override
    protected ResourceLocation getStructure(Random rand) {
        return STRUCTURE_CAVE;
    }
}

