/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.feature;

import com.mojang.serialization.Codec;
import greekfantasy.GFRegistry;
import greekfantasy.entity.HarpyEntity;
import greekfantasy.feature.SimpleTemplateFeature;
import greekfantasy.util.BiomeHelper;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.state.Property;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class HarpyNestFeature
extends Feature<NoFeatureConfig> {
    public static final String NAME = "harpy_nest_feature";

    public HarpyNestFeature(Codec<NoFeatureConfig> codec) {
        super(codec);
    }

    public boolean generate(ISeedReader reader, ChunkGenerator chunkGenerator, Random rand, BlockPos blockPosIn, NoFeatureConfig config) {
        if (!SimpleTemplateFeature.isValidDimension(reader)) {
            return false;
        }
        BlockPos blockPos = blockPosIn.func_177982_a(4 + rand.nextInt(8), 0, 4 + rand.nextInt(8));
        int y = reader.func_205770_a(Heightmap.Type.WORLD_SURFACE, blockPos).func_177956_o();
        BlockPos pos = new BlockPos(blockPos.func_177958_n(), y, blockPos.func_177952_p());
        if (!HarpyNestFeature.isDirtOrGrassAt((IWorldGenerationReader)reader, pos.func_177977_b())) {
            return false;
        }
        Optional biome = reader.func_201672_e().func_242406_i(pos);
        boolean isDesert = Objects.equals(biome, Optional.of(Biomes.field_76769_d)) || Objects.equals(biome, Optional.of(Biomes.field_76786_s));
        BlockState log = HarpyNestFeature.getLogState(biome);
        BlockState leaf = isDesert ? Blocks.field_150350_a.func_176223_P() : (BlockState)HarpyNestFeature.getLeavesState(log).func_206870_a((Property)LeavesBlock.field_208494_a, (Comparable)Integer.valueOf(3));
        int variant = rand.nextInt(2);
        Rotation rotation = Rotation.func_222466_a((Random)rand);
        switch (variant) {
            default: {
                return this.buildVariant0(reader, chunkGenerator, rand, log, leaf, pos, rotation);
            }
            case 1: 
        }
        return this.buildVariant1(reader, chunkGenerator, rand, log, leaf, pos, rotation);
    }

    public boolean buildVariant0(ISeedReader world, ChunkGenerator chunkGenerator, Random rand, BlockState log, BlockState leaf, BlockPos pos, Rotation rot) {
        int rh = rand.nextInt(3) - 1;
        for (int i = 0; i < 14 + rh; ++i) {
            HarpyNestFeature.set((IWorldWriter)world, pos.func_177981_b(i), log);
        }
        HarpyNestFeature.set((IWorldWriter)world, HarpyNestFeature.rot(pos.func_177981_b(4 + rh), 0, 1, rot), log);
        HarpyNestFeature.set((IWorldWriter)world, HarpyNestFeature.rot(pos.func_177981_b(5 + rh), 0, 2, rot), log);
        if (leaf.func_177230_c() != Blocks.field_150350_a) {
            HarpyNestFeature.generateLeavesAround((IWorldGenerationReader)world, rand, pos.func_177981_b(3 + rh), leaf, 2);
            HarpyNestFeature.generateLeavesAround((IWorldGenerationReader)world, rand, pos.func_177981_b(4 + rh), leaf, 2);
            HarpyNestFeature.generateLeavesAround((IWorldGenerationReader)world, rand, pos.func_177981_b(5 + rh), leaf, 1);
            HarpyNestFeature.generateLeavesAround((IWorldGenerationReader)world, rand, HarpyNestFeature.rot(pos.func_177981_b(5 + rh), 0, 1, rot), leaf, 1);
            HarpyNestFeature.generateLeavesAround((IWorldGenerationReader)world, rand, HarpyNestFeature.rot(pos.func_177981_b(5 + rh), 0, 2, rot), leaf, 1);
            HarpyNestFeature.generateLeavesAround((IWorldGenerationReader)world, rand, pos.func_177981_b(6 + rh), leaf, 1);
            HarpyNestFeature.generateLeavesAround((IWorldGenerationReader)world, rand, pos.func_177981_b(9 + rh), leaf, 1);
            HarpyNestFeature.generateLeavesAround((IWorldGenerationReader)world, rand, pos.func_177981_b(10 + rh), leaf, 2);
            HarpyNestFeature.generateLeavesAround((IWorldGenerationReader)world, rand, pos.func_177981_b(11 + rh), leaf, 2);
            HarpyNestFeature.generateLeavesAround((IWorldGenerationReader)world, rand, pos.func_177981_b(12 + rh), leaf, 2);
            HarpyNestFeature.generateLeavesAround((IWorldGenerationReader)world, rand, pos.func_177981_b(13 + rh), leaf, 1);
            HarpyNestFeature.set((IWorldWriter)world, pos.func_177981_b(14 + rh), leaf);
        }
        BlockPos nestPos = pos.func_177971_a((Vector3i)new BlockPos(0, 6 + rh, 2).func_190942_a(rot));
        HarpyNestFeature.generateNestAround((IWorldGenerationReader)world, nestPos, true);
        HarpyNestFeature.addHarpy(world, rand, nestPos.func_177984_a());
        if (rand.nextBoolean()) {
            HarpyNestFeature.addHarpy(world, rand, nestPos.func_177984_a());
        }
        return true;
    }

    public boolean buildVariant1(ISeedReader world, ChunkGenerator chunkGenerator, Random rand, BlockState log, BlockState leaf, BlockPos pos, Rotation rot) {
        int rh = rand.nextInt(3) - 1;
        for (int i = 0; i < 6 + rh; ++i) {
            HarpyNestFeature.set((IWorldWriter)world, pos.func_177981_b(i), log);
        }
        HarpyNestFeature.set((IWorldWriter)world, HarpyNestFeature.rot(pos.func_177981_b(4 + rh), 0, -1, rot), log);
        HarpyNestFeature.set((IWorldWriter)world, HarpyNestFeature.rot(pos.func_177981_b(5 + rh), 0, -2, rot), log);
        HarpyNestFeature.set((IWorldWriter)world, HarpyNestFeature.rot(pos.func_177981_b(4 + rh), 0, 1, rot), log);
        HarpyNestFeature.set((IWorldWriter)world, HarpyNestFeature.rot(pos.func_177981_b(5 + rh), 0, 2, rot), log);
        HarpyNestFeature.set((IWorldWriter)world, HarpyNestFeature.rot(pos.func_177981_b(4 + rh), -1, 0, rot), log);
        HarpyNestFeature.set((IWorldWriter)world, HarpyNestFeature.rot(pos.func_177981_b(5 + rh), -2, 0, rot), log);
        HarpyNestFeature.set((IWorldWriter)world, HarpyNestFeature.rot(pos.func_177981_b(5 + rh), -2, -1, rot), log);
        HarpyNestFeature.set((IWorldWriter)world, HarpyNestFeature.rot(pos.func_177981_b(6 + rh), -3, 0, rot), log);
        HarpyNestFeature.set((IWorldWriter)world, HarpyNestFeature.rot(pos.func_177981_b(5 + rh), 1, 0, rot), log);
        HarpyNestFeature.set((IWorldWriter)world, HarpyNestFeature.rot(pos.func_177981_b(5 + rh), 2, 0, rot), log);
        if (leaf.func_177230_c() != Blocks.field_150350_a) {
            HarpyNestFeature.generateLeavesAround((IWorldGenerationReader)world, rand, pos.func_177981_b(3 + rh), leaf, 1);
            HarpyNestFeature.generateLeavesAround((IWorldGenerationReader)world, rand, pos.func_177981_b(4 + rh), leaf, 2);
            HarpyNestFeature.generateLeavesAround((IWorldGenerationReader)world, rand, pos.func_177981_b(5 + rh), leaf, 3);
            HarpyNestFeature.generateLeavesAround((IWorldGenerationReader)world, rand, HarpyNestFeature.rot(pos.func_177981_b(5 + rh), -2, 0, rot), leaf, 1);
            HarpyNestFeature.generateLeavesAround((IWorldGenerationReader)world, rand, HarpyNestFeature.rot(pos.func_177981_b(6 + rh), -3, 0, rot), leaf, 1);
            HarpyNestFeature.generateLeavesAround((IWorldGenerationReader)world, rand, HarpyNestFeature.rot(pos.func_177981_b(6 + rh), -2, 1, rot), leaf, 1);
            HarpyNestFeature.generateLeavesAround((IWorldGenerationReader)world, rand, HarpyNestFeature.rot(pos.func_177981_b(7 + rh), -2, 1, rot), leaf, 1);
            HarpyNestFeature.generateLeavesAround((IWorldGenerationReader)world, rand, HarpyNestFeature.rot(pos.func_177981_b(7 + rh), -2, 0, rot), leaf, 1);
            HarpyNestFeature.generateLeavesAround((IWorldGenerationReader)world, rand, HarpyNestFeature.rot(pos.func_177981_b(6 + rh), -2, -1, rot), leaf, 1);
            HarpyNestFeature.generateLeavesAround((IWorldGenerationReader)world, rand, HarpyNestFeature.rot(pos.func_177981_b(5 + rh), 2, 0, rot), leaf, 1);
            HarpyNestFeature.generateLeavesAround((IWorldGenerationReader)world, rand, HarpyNestFeature.rot(pos.func_177981_b(6 + rh), 2, 0, rot), leaf, 1);
            HarpyNestFeature.generateLeavesAround((IWorldGenerationReader)world, rand, HarpyNestFeature.rot(pos.func_177981_b(6 + rh), 0, -2, rot), leaf, 1);
            HarpyNestFeature.generateLeavesAround((IWorldGenerationReader)world, rand, HarpyNestFeature.rot(pos.func_177981_b(7 + rh), 0, -2, rot), leaf, 1);
            HarpyNestFeature.generateLeavesAround((IWorldGenerationReader)world, rand, HarpyNestFeature.rot(pos.func_177981_b(6 + rh), 0, 2, rot), leaf, 1);
            HarpyNestFeature.generateLeavesAround((IWorldGenerationReader)world, rand, HarpyNestFeature.rot(pos.func_177981_b(7 + rh), 0, 2, rot), leaf, 1);
        }
        BlockPos nestPos = pos.func_177981_b(6 + rh);
        HarpyNestFeature.generateNestAround((IWorldGenerationReader)world, nestPos, true);
        HarpyNestFeature.addHarpy(world, rand, nestPos.func_177984_a());
        if (rand.nextBoolean()) {
            HarpyNestFeature.addHarpy(world, rand, nestPos.func_177984_a());
        }
        HarpyNestFeature.set((IWorldWriter)world, HarpyNestFeature.rot(nestPos, -1, 1, rot), leaf, 3);
        HarpyNestFeature.set((IWorldWriter)world, HarpyNestFeature.rot(nestPos.func_177981_b(1), -1, 1, rot), leaf);
        HarpyNestFeature.set((IWorldWriter)world, HarpyNestFeature.rot(nestPos.func_177981_b(2), -1, 1, rot), leaf);
        return true;
    }

    protected static void set(IWorldWriter writer, BlockPos pos, BlockState state) {
        HarpyNestFeature.set(writer, pos, state, 2);
    }

    protected static void set(IWorldWriter writer, BlockPos pos, BlockState state, int flag) {
        writer.func_180501_a(pos, state, flag);
    }

    protected static BlockPos rot(BlockPos origin, int x, int z, Rotation rot) {
        return origin.func_177971_a((Vector3i)new BlockPos(x, 0, z).func_190942_a(rot));
    }

    protected static boolean isAirOrLeavesAt(IWorldGenerationReader reader, BlockPos pos) {
        return reader.func_217375_a(pos, state -> state.func_196958_f() || state.func_235714_a_((ITag)BlockTags.field_206952_E));
    }

    protected static boolean isDirtOrGrassAt(IWorldGenerationReader reader, BlockPos pos) {
        return reader.func_217375_a(pos, state -> {
            Block block = state.func_177230_c();
            return HarpyNestFeature.func_227250_b_((Block)block) || block == Blocks.field_196658_i;
        });
    }

    protected static boolean isPlantAt(IWorldGenerationReader reader, BlockPos pos) {
        return reader.func_217375_a(pos, state -> {
            Material m = state.func_185904_a();
            return m == Material.field_151582_l || m == Material.field_151585_k;
        });
    }

    protected static boolean isReplaceableAt(IWorldGenerationReader reader, BlockPos pos) {
        return HarpyNestFeature.isAirOrLeavesAt(reader, pos) || HarpyNestFeature.isPlantAt(reader, pos);
    }

    protected static BlockState getLogState(Optional<RegistryKey<Biome>> biome) {
        return (BlockState)BiomeHelper.getLogForBiome(biome).func_206870_a((Property)RotatedPillarBlock.field_176298_M, (Comparable)Direction.Axis.Y);
    }

    protected static BlockState getLeavesState(BlockState log) {
        if (log.func_235714_a_((ITag)BlockTags.field_203288_q)) {
            return Blocks.field_196572_aa.func_176223_P();
        }
        if (log.func_235714_a_((ITag)BlockTags.field_203285_n)) {
            return Blocks.field_196574_ab.func_176223_P();
        }
        if (log.func_235714_a_((ITag)BlockTags.field_203290_s)) {
            return Blocks.field_196645_X.func_176223_P();
        }
        if (log.func_235714_a_((ITag)BlockTags.field_203287_p)) {
            return Blocks.field_196647_Y.func_176223_P();
        }
        if (log.func_235714_a_((ITag)BlockTags.field_203289_r)) {
            return Blocks.field_196648_Z.func_176223_P();
        }
        if (log.func_235714_a_(BiomeHelper.getOliveLogs())) {
            return GFRegistry.OLIVE_LEAVES.func_176223_P();
        }
        return Blocks.field_196642_W.func_176223_P();
    }

    protected static void generateLeavesAround(IWorldGenerationReader world, Random rand, BlockPos pos, BlockState leaf, int radius) {
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                BlockPos p = pos.func_177982_a(x, 0, z);
                if (!HarpyNestFeature.shouldGenerateLeaf(x, z, radius, rand) || !HarpyNestFeature.isAirOrLeavesAt(world, p)) continue;
                HarpyNestFeature.set((IWorldWriter)world, p, leaf);
            }
        }
    }

    protected static void generateNestAround(IWorldGenerationReader world, BlockPos pos, boolean forceReplace) {
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                BlockPos p = pos.func_177982_a(x, 0, z);
                if (!forceReplace && !HarpyNestFeature.isAirOrLeavesAt(world, p)) continue;
                HarpyNestFeature.set((IWorldWriter)world, p.func_177981_b(2), Blocks.field_150350_a.func_176223_P());
                HarpyNestFeature.set((IWorldWriter)world, p.func_177981_b(1), Blocks.field_150350_a.func_176223_P());
                HarpyNestFeature.set((IWorldWriter)world, p, GFRegistry.NEST_BLOCK.func_176223_P(), 3);
            }
        }
    }

    protected static void addHarpy(ISeedReader world, Random rand, BlockPos pos) {
        HarpyEntity entity = (HarpyEntity)GFRegistry.HARPY_ENTITY.func_200721_a((World)world.func_201672_e());
        entity.func_70012_b((double)pos.func_177958_n() + rand.nextDouble(), (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + rand.nextDouble(), 0.0f, 0.0f);
        entity.func_110163_bv();
        world.func_217376_c((Entity)entity);
    }

    protected static boolean shouldGenerateLeaf(int x, int z, int radius, Random rand) {
        boolean isNonStrictCorner2;
        boolean valid = Math.abs(x) != radius || Math.abs(z) != radius;
        boolean isNonStrictCorner = radius > 1 && Math.abs(x) == radius - 1 && Math.abs(z) == radius || Math.abs(x) == radius && Math.abs(z) == radius - 1;
        boolean bl = isNonStrictCorner2 = radius > 2 && Math.abs(x) == radius - 2 && Math.abs(z) == radius - 1 || Math.abs(x) == radius - 1 && Math.abs(z) == radius - 2;
        if (valid && isNonStrictCorner2) {
            boolean bl2 = valid = rand.nextInt(3) == 0;
        }
        if (valid && isNonStrictCorner) {
            valid = rand.nextInt(4) == 0;
        }
        return valid;
    }
}

