/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.feature;

import com.mojang.serialization.Codec;
import greekfantasy.feature.SimpleTemplateFeature;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.template.BlockIgnoreStructureProcessor;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class LionDenFeature
extends SimpleTemplateFeature {
    private static final ResourceLocation STRUCTURE_LION_DEN = new ResourceLocation("greekfantasy", "lion_den");

    public LionDenFeature(Codec<NoFeatureConfig> codec) {
        super(codec);
    }

    public boolean generate(ISeedReader reader, ChunkGenerator chunkGenerator, Random rand, BlockPos blockPosIn, NoFeatureConfig config) {
        if (!SimpleTemplateFeature.isValidDimension(reader)) {
            return false;
        }
        TemplateManager manager = reader.func_201672_e().func_184163_y();
        Rotation rotation = Rotation.func_222466_a((Random)rand);
        Mirror mirror = Mirror.NONE;
        BlockPos genPos = LionDenFeature.getHeightPos(reader, blockPosIn.func_177982_a(4 + rand.nextInt(8), 0, 4 + rand.nextInt(8)));
        PlacementSettings placement = new PlacementSettings().func_186220_a(rotation).func_186214_a(mirror).func_189950_a(rand).func_215222_a((StructureProcessor)BlockIgnoreStructureProcessor.field_215204_a);
        return this.generateDen(reader, manager.func_200220_a(this.getStructure(rand)), placement, genPos, rand);
    }

    protected boolean generateDen(ISeedReader reader, Template template, PlacementSettings placement, BlockPos pos, Random rand) {
        if (!this.isValidPosition(reader, pos, template.func_186259_a().func_177979_c(4), placement.func_186215_c())) {
            return false;
        }
        ChunkPos chunkPos = new ChunkPos(pos);
        MutableBoundingBox mbb = new MutableBoundingBox(chunkPos.func_180334_c() - 16, pos.func_177956_o() - 8, chunkPos.func_180333_d() - 16, chunkPos.func_180332_e() + 16, pos.func_177956_o() + 16, chunkPos.func_180330_f() + 16);
        template.func_237146_a_((IServerWorld)reader, pos.func_177977_b(), pos.func_177977_b(), placement.func_186223_a(mbb), rand, 2);
        LionDenFeature.fillBelow(reader, pos.func_177979_c(3), template.func_186259_a(), placement.func_186215_c(), new Block[]{Blocks.field_150322_A});
        return true;
    }

    protected static boolean canPlaceOnBlock(ISeedReader world, BlockPos pos) {
        return pos.func_177956_o() > 4 && world.func_180495_p(pos).func_200132_m() && !world.func_180495_p(pos.func_177981_b(4)).func_200132_m();
    }

    @Override
    protected boolean isValidPosition(ISeedReader reader, BlockPos pos) {
        return pos.func_177956_o() > 4 && reader.func_180495_p(pos).func_200132_m() && LionDenFeature.isReplaceableAt((IWorldGenerationReader)reader, pos.func_177981_b(4));
    }

    @Override
    protected ResourceLocation getStructure(Random rand) {
        return STRUCTURE_LION_DEN;
    }
}

