/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.feature;

import com.mojang.serialization.Codec;
import greekfantasy.feature.SimpleTemplateFeature;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.template.BlockIgnoreStructureProcessor;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class OliveTreeFeature
extends Feature<BaseTreeFeatureConfig> {
    private static final ResourceLocation OLIVE_TREE_0 = new ResourceLocation("greekfantasy", "olive_tree/olive_tree_0");
    private static final ResourceLocation OLIVE_TREE_1 = new ResourceLocation("greekfantasy", "olive_tree/olive_tree_1");
    private static final ResourceLocation OLIVE_TREE_2 = new ResourceLocation("greekfantasy", "olive_tree/olive_tree_2");

    public OliveTreeFeature(Codec<BaseTreeFeatureConfig> codec) {
        super(codec);
    }

    public boolean generate(ISeedReader reader, ChunkGenerator chunkGenerator, Random rand, BlockPos blockPosIn, BaseTreeFeatureConfig config) {
        if (!SimpleTemplateFeature.isValidDimension(reader)) {
            return false;
        }
        Mirror mirror = Mirror.NONE;
        Rotation rotation = Rotation.func_222466_a((Random)rand);
        TemplateManager manager = reader.func_201672_e().func_184163_y();
        Template template = manager.func_200220_a(OliveTreeFeature.getRandomTree(rand));
        BlockPos placementPos = blockPosIn;
        if (!(config.field_227372_q_ || OliveTreeFeature.isDirtOrGrassAt((IWorldGenerationReader)reader, (placementPos = OliveTreeFeature.getHeightPos(reader, placementPos)).func_177977_b()) && OliveTreeFeature.isAllReplaceable(reader, placementPos.func_177982_a(2, 1, 2), 3, 3))) {
            return false;
        }
        BlockPos offset = new BlockPos(-3, 0, -3);
        BlockPos pos = placementPos.func_177971_a((Vector3i)offset.func_190942_a(rotation));
        MutableBoundingBox mbb = new MutableBoundingBox(pos.func_177958_n() - 8, pos.func_177956_o() - 16, pos.func_177952_p() - 8, pos.func_177958_n() + 8, pos.func_177956_o() + 16, pos.func_177952_p() + 8);
        PlacementSettings placement = new PlacementSettings().func_186220_a(rotation).func_186214_a(mirror).func_189950_a(rand).func_186223_a(mbb).func_215222_a((StructureProcessor)BlockIgnoreStructureProcessor.field_215206_c);
        template.func_237146_a_((IServerWorld)reader, pos, pos, placement, rand, 2);
        return true;
    }

    private static ResourceLocation getRandomTree(Random rand) {
        int r = rand.nextInt(3);
        switch (r) {
            case 0: {
                return OLIVE_TREE_0;
            }
            case 1: {
                return OLIVE_TREE_1;
            }
        }
        return OLIVE_TREE_2;
    }

    protected static BlockPos getHeightPos(ISeedReader world, BlockPos original) {
        int y = world.func_205770_a(Heightmap.Type.WORLD_SURFACE_WG, original).func_177956_o();
        return new BlockPos(original.func_177958_n(), y, original.func_177952_p());
    }

    protected static boolean isAllReplaceable(ISeedReader world, BlockPos corner, int width, int height) {
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                for (int k = 0; k < width; ++k) {
                    if (OliveTreeFeature.isReplaceableAt((IWorldGenerationReader)world, corner.func_177982_a(i, j, k))) continue;
                    return false;
                }
            }
        }
        return true;
    }

    protected static boolean isDirtOrGrassAt(IWorldGenerationReader reader, BlockPos pos) {
        return reader.func_217375_a(pos, state -> {
            Block block = state.func_177230_c();
            return OliveTreeFeature.func_227250_b_((Block)block) || block == Blocks.field_196658_i;
        });
    }

    protected static boolean isPlantAt(IWorldGenerationReader reader, BlockPos pos) {
        return reader.func_217375_a(pos, state -> {
            Material m = state.func_185904_a();
            return m == Material.field_151582_l || m == Material.field_151585_k;
        });
    }

    protected static boolean isReplaceableAt(IWorldGenerationReader reader, BlockPos pos) {
        return OliveTreeFeature.func_236297_b_((IWorldGenerationBaseReader)reader, (BlockPos)pos) || OliveTreeFeature.isPlantAt(reader, pos);
    }
}

