/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.feature;

import com.mojang.serialization.Codec;
import greekfantasy.GFRegistry;
import greekfantasy.GreekFantasy;
import greekfantasy.entity.SatyrEntity;
import greekfantasy.feature.SimpleTemplateFeature;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.passive.horse.CoatColors;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.template.BlockIgnoreStructureProcessor;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class SatyrCampFeature
extends SimpleTemplateFeature {
    private static final ResourceLocation STRUCTURE_CAMPFIRE = new ResourceLocation("greekfantasy", "satyr_camp/satyr_campfire");
    private static final ResourceLocation STRUCTURE_TENT_CHEST = new ResourceLocation("greekfantasy", "satyr_camp/satyr_tent_with_chest");
    private static final ResourceLocation STRUCTURE_TENT_NOCHEST = new ResourceLocation("greekfantasy", "satyr_camp/satyr_tent");

    public SatyrCampFeature(Codec<NoFeatureConfig> codec) {
        super(codec);
    }

    public boolean generate(ISeedReader reader, ChunkGenerator chunkGenerator, Random rand, BlockPos blockPosIn, NoFeatureConfig config) {
        if (!SimpleTemplateFeature.isValidDimension(reader)) {
            return false;
        }
        TemplateManager manager = reader.func_201672_e().func_184163_y();
        BlockPos tent1Offset = new BlockPos(4 + rand.nextInt(4), 0, rand.nextInt(4) - 2);
        BlockPos tent2Offset = new BlockPos(2 + rand.nextInt(4), 0, 5 + rand.nextInt(3));
        BlockPos tent3Offset = new BlockPos(2 + rand.nextInt(4), 0, 5 + rand.nextInt(3));
        BlockPos tent4Offset = new BlockPos(2 + rand.nextInt(4), 0, 5 + rand.nextInt(3));
        Rotation rotation = Rotation.func_222466_a((Random)rand);
        Mirror mirror = Mirror.NONE;
        PlacementSettings placement = new PlacementSettings().func_186220_a(rotation).func_186214_a(mirror).func_189950_a(rand).func_215222_a((StructureProcessor)BlockIgnoreStructureProcessor.field_215204_a);
        SatyrEntity.GroupData data = new SatyrEntity.GroupData((CoatColors)Util.func_240989_a_((Object[])CoatColors.values(), (Random)rand));
        BlockPos campfirePos = SatyrCampFeature.getHeightPos(reader, blockPosIn.func_177982_a(4 + rand.nextInt(8), 0, 4 + rand.nextInt(8)));
        if (this.generateTemplate(reader, manager.func_200220_a(STRUCTURE_CAMPFIRE), placement, campfirePos, rand, false, data, 0)) {
            SatyrCampFeature.addSatyr(reader, rand, campfirePos.func_177984_a(), data, 1 + rand.nextInt(2));
            int tentsGenerated = 0;
            BlockPos tentPos = SatyrCampFeature.getHeightPos(reader, campfirePos.func_177971_a((Vector3i)tent1Offset.func_190942_a(rotation)));
            if (this.generateTemplate(reader, manager.func_200220_a(this.getStructure(rand)), placement, tentPos, rand, true, data, tentsGenerated)) {
                ++tentsGenerated;
            }
            tentPos = SatyrCampFeature.getHeightPos(reader, campfirePos.func_177971_a((Vector3i)tent2Offset.func_190942_a(rotation)));
            rotation = rotation.func_185830_a(Rotation.CLOCKWISE_90);
            if (this.generateTemplate(reader, manager.func_200220_a(this.getStructure(rand)), placement.func_186220_a(rotation), tentPos, rand, true, data, tentsGenerated)) {
                ++tentsGenerated;
            }
            tentPos = SatyrCampFeature.getHeightPos(reader, campfirePos.func_177971_a((Vector3i)tent3Offset.func_190942_a(rotation)));
            rotation = rotation.func_185830_a(Rotation.CLOCKWISE_90);
            if (this.generateTemplate(reader, manager.func_200220_a(this.getStructure(rand)), placement.func_186220_a(rotation), tentPos, rand, true, data, tentsGenerated)) {
                ++tentsGenerated;
            }
            tentPos = SatyrCampFeature.getHeightPos(reader, campfirePos.func_177971_a((Vector3i)tent4Offset.func_190942_a(rotation)));
            rotation = rotation.func_185830_a(Rotation.CLOCKWISE_90);
            if (this.generateTemplate(reader, manager.func_200220_a(this.getStructure(rand)), placement.func_186220_a(rotation), tentPos, rand, true, data, tentsGenerated)) {
                ++tentsGenerated;
            }
            return true;
        }
        return false;
    }

    protected boolean generateTemplate(ISeedReader reader, Template template, PlacementSettings placement, BlockPos pos, Random rand, boolean satyrs, ILivingEntityData data, int tentsGenerated) {
        if (tentsGenerated > 2 || !this.isValidPosition(reader, pos, template.func_186259_a(), placement.func_186215_c())) {
            return false;
        }
        MutableBoundingBox mbb = new MutableBoundingBox(pos.func_177958_n() - 12, pos.func_177956_o() - 16, pos.func_177952_p() - 12, pos.func_177958_n() + 12, pos.func_177956_o() + 16, pos.func_177952_p() + 12);
        template.func_237146_a_((IServerWorld)reader, pos, pos, placement.func_186223_a(mbb), rand, 2);
        SatyrCampFeature.fillBelow(reader, pos.func_177977_b(), template.func_186259_a(), placement.func_186215_c(), new Block[]{Blocks.field_150346_d});
        if (satyrs) {
            SatyrCampFeature.addSatyr(reader, rand, pos.func_177971_a((Vector3i)new BlockPos(3, 1, 2).func_190942_a(placement.func_186215_c())), data, 1 + rand.nextInt(2));
        }
        return true;
    }

    protected static void addSatyr(ISeedReader world, Random rand, BlockPos pos, ILivingEntityData data, int count) {
        for (int i = 0; i < count; ++i) {
            SatyrEntity entity = (SatyrEntity)GFRegistry.SATYR_ENTITY.func_200721_a((World)world.func_201672_e());
            entity.func_70012_b((double)pos.func_177958_n() + rand.nextDouble(), (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + rand.nextDouble(), 0.0f, 0.0f);
            entity.func_110163_bv();
            if (rand.nextInt(100) < GreekFantasy.CONFIG.getSatyrShamanChance()) {
                entity.setShaman(true);
            }
            entity.setCoatColor(((SatyrEntity.GroupData)data).variant);
            world.func_217376_c((Entity)entity);
        }
    }

    @Override
    protected boolean isValidPosition(ISeedReader reader, BlockPos pos) {
        return pos.func_177956_o() > 3 && reader.func_180495_p(pos).func_200132_m() && SatyrCampFeature.isReplaceableAt((IWorldGenerationReader)reader, pos.func_177981_b(3));
    }

    @Override
    protected ResourceLocation getStructure(Random rand) {
        return rand.nextBoolean() ? STRUCTURE_TENT_CHEST : STRUCTURE_TENT_NOCHEST;
    }
}

